/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * userinfoT.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: userinfoT.h,v 1.3 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifndef __USERINFOT_H__
#define __USERINFOT_H__

#define UINFO_NICK_SIZE 63
#define UINFO_CNX_SIZE 15
#define UINFO_UEMAIL_SIZE 64
#define UINFO_UDESC_SIZE 64

#define UINFO_BIT_BUSY (1<<0)
#define UINFO_BIT_POPULATED (1<<1)
#define UINFO_BIT_IS_OP (1<<2)
#define UINFO_BIT_IS_ONLINE (1<<3)

#define SET_BIT(org_value,bit)								((org_value)|(bit))
#define CLEAR_BIT(org_value,bit)							 ((org_value)&~(bit))

/**************************************************/
/* structure containing the information of a user */
/**************************************************/
typedef struct
{
	unsigned char entry_is_busy;
																							 /* bit 0: 0= entry is empty, 1= entry is occupied */
																							 /* bit 1: 0= partial content (only nickname is populated), 1=entry fully populated */
																							 /* bit 2: 0= normal user, 1= Op */
																							 /* bit 3: 0= offline user, 1=online user */
	char nickname[UINFO_NICK_SIZE];
	unsigned long long share_size;
	char cnx_type[UINFO_CNX_SIZE];
	unsigned char uflag;
	char uemail[UINFO_UEMAIL_SIZE];
	char udesc[UINFO_UDESC_SIZE];
} LMP_UINFO;

#endif
