/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gconf/gconf-client.h>
#include <gnome.h>

#include "interface.h"
#include "support.h"

#include "main.h"
#include "gui_layout.h"
#include "bittorrent_clist.h"
#include "misc_gtk.h"
#include "callbacks.h"

/* GConf variables */
GConfClient *gconf_engine=NULL;

static pid_t dc_gui2_pid=-1;

GtkWidget *main_window=NULL;
GtkWidget *bt_popup=NULL;

/* this string is "$HOME/.dctc" */
GString *dctc_main_dir=NULL;
 
GString *dctc_dir;

GString *bt2dc_gui2_directory=NULL;       /* name of the directory containing the directory used by dc_gui2 to store running bittorrent data = $HOME/.dc_gui2/bt2dc_gui2/ */

gboolean utf8_mode=FALSE;

guint32 bittorrent_list_refresh_rate=0;      /* delay between 2 refresh of the bittorrent list (in 1/1000ths of seconds) */
guint bittorrent_list_refresh_rate_gta=0;       /* handle returned by gtk_timeout_add for this refresh (only meaningful if the previous var !=0) */
   
static gboolean on_plug_delete_event(GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	on_app1_delete_event(GTK_WIDGET(user_data),NULL,NULL);	/* delete the main widget */
	/* it is a bit weird but despite of the call of gtk_main_quit in the previous function */
	/* the program reachs this part of the code */
	return FALSE;
}

static gint check_ppid(gpointer data)
{
	if(getppid()!=dc_gui2_pid)	 /* this process has a new parent => previous parent is dead */
	{
		gtk_main_quit();			  /* only quit, don't save anything */
	}
	return TRUE;	/* don't stop periodic call */
}


/********************************************/
/* set the periodic call rate of a function */
/*************************************************************/
/* if new_rate=0, a current running periodic call is removed */
/*************************************************************/
static void set_periodic_function_call_rate(guint32 *rate, guint *handle, GtkFunction function_to_call, gpointer xtra_data_to_send_to_function, guint32 new_rate)
{
	if(new_rate==0)
	{
		/* disable periodic call */
		if(*handle!=0)
		{
			gtk_timeout_remove(*handle);
			*handle=0;
		}
		*rate=0;
	}
	else
	{	/* set a periodic call */
		if(*rate!=new_rate)
		{
			/* at a different speed of the current one */
			if(*handle!=0)
				gtk_timeout_remove(*handle);
			
			*rate=new_rate;
			*handle=gtk_timeout_add(new_rate, function_to_call, xtra_data_to_send_to_function);
		}
	}
}

void update_bt_refresh_rate(GConfClient *client, guint cnxn_id, GConfEntry *entry, gpointer user_data)
{
	gfloat refresh_rate;

	refresh_rate=gconf_client_get_float(gconf_engine,"/apps/Dc_gui2/GUIPrefs/bittorrent_refresh_rate_spinbutton_spin_val",NULL);
	if(refresh_rate==0)
	{
		refresh_rate=5;		/* default refresh rate: 5 secondes */
	}
	set_periodic_function_call_rate(&bittorrent_list_refresh_rate,&bittorrent_list_refresh_rate_gta,
                                 bittorrent_list_periodic_refresh,NULL,
                                 1000*refresh_rate);
}

void update_tooltips_display(GConfClient *client, guint cnxn_id, GConfEntry *entry, gpointer user_data)
{
   GtkWidget *w;

	gint ttip_no_display;

   w=get_widget_by_widget_name(main_window,"tooltips");

	printf("update key\n");
	ttip_no_display=gconf_client_get_int(gconf_engine,"/apps/Dc_gui2/GUIPrefs/disable_tooltips_checkbutton_toggle_val",NULL);
	if(ttip_no_display)
		gtk_tooltips_disable(GTK_TOOLTIPS(w));
	else
		gtk_tooltips_enable(GTK_TOOLTIPS(w));
}

/* if the environnement var EMB_WID is defined, its value is used as GdkNativeWindow for embedding the process */
int
main (int argc, char *argv[])
{
	char *path;
	GdkNativeWindow sock_id=0;
	char *t;

	dc_gui2_pid=getppid();

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

	gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
											argc, argv,
											GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
											NULL);

	path=getenv("HOME");

	t=getenv("EMB_WID");
	if(t!=NULL)
		sock_id=strtoul(t,NULL,10);

	dctc_main_dir=g_string_new(NULL);
	g_string_sprintf(dctc_main_dir,"%s/.dctc",(path!=NULL)?path:".");

	dctc_dir=g_string_new(NULL);
	g_string_sprintf(dctc_dir,"%s/running",dctc_main_dir->str);

	/* bittorrent directory = $HOME/.dc_gui2/bt2dc_gui2/ */
	bt2dc_gui2_directory=g_string_new(NULL);
	g_string_sprintf(bt2dc_gui2_directory,"%s/.dc_gui2/bt2dc_gui2/",(path!=NULL)?path:".");

	/* build a gconf engine */
	gconf_engine=gconf_client_get_default();

	/*
	 * The following code was added by Glade to create one of each component
	 * (except popup menus), just so that you see something after building
	 * the project. Delete any components that you don't want shown initially.
	 */
	main_window = create_app1 ();
	bt_popup=create_bt_popup_menu ();

	bmav4_bittorrent_clist();
	init_bt_array();
	gui_full_restore(main_window,NULL);
	gtk_widget_realize(main_window);

	if(sock_id==0)
		gtk_widget_show(main_window);
	else
	{
		GtkWidget *root_window;
		GtkWidget *base_widget;

		/* install a watchdog to end this program if dc_gui2 disappears */
		gtk_timeout_add(1000,check_ppid,NULL);

		base_widget=get_widget_by_widget_name(main_window,"scrolledwindow1");

		root_window=gtk_plug_new(sock_id);
		g_signal_connect((gpointer) root_window,"delete_event", G_CALLBACK(on_plug_delete_event),base_widget);

		gtk_widget_realize(root_window);

		gtk_widget_reparent(base_widget,root_window);
		gtk_widget_show(root_window);
	}

	/* add monitoring on some gconf variable */
	gconf_client_add_dir(gconf_engine,"/apps/Dc_gui2/GUIPrefs",GCONF_CLIENT_PRELOAD_NONE,NULL);
	gconf_client_notify_add(gconf_engine, "/apps/Dc_gui2/GUIPrefs/bittorrent_refresh_rate_spinbutton_spin_val", update_bt_refresh_rate,NULL,NULL,NULL);
	gconf_client_notify_add(gconf_engine, "/apps/Dc_gui2/GUIPrefs/disable_tooltips_checkbutton_toggle_val", update_tooltips_display,NULL,NULL,NULL);
	
	/* initialized periodic update */
	{
		gfloat refresh_rate;

		refresh_rate=gconf_client_get_float(gconf_engine,"/apps/Dc_gui2/GUIPrefs/bittorrent_refresh_rate_spinbutton_spin_val",NULL);
		if(refresh_rate==0)
		{
			refresh_rate=5;		/* default refresh rate: 5 secondes */
		}
		set_periodic_function_call_rate(&bittorrent_list_refresh_rate,&bittorrent_list_refresh_rate_gta,
	                                 bittorrent_list_periodic_refresh,NULL,
	                                 1000*refresh_rate);
	}

	{	/* set the tooltips display mode */
   	GtkWidget *w;
		gint ttip_no_display;

   	w=get_widget_by_widget_name(main_window,"tooltips");

		printf("update key\n");
		ttip_no_display=gconf_client_get_int(gconf_engine,"/apps/Dc_gui2/GUIPrefs/disable_tooltips_checkbutton_toggle_val",NULL);
		if(ttip_no_display)
			gtk_tooltips_disable(GTK_TOOLTIPS(w));
		else
			gtk_tooltips_enable(GTK_TOOLTIPS(w));
	}

	gtk_main ();

	g_object_unref(G_OBJECT(gconf_engine));
	gconf_engine=NULL;

	return 0;
}

