#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "misc_gtk.h"

static int assoc_init=0;
static GData *assoc_wid_name=NULL;

void widget_log(GtkWidget *w)
{
	char *name;

	name=gtk_widget_get_name(w);
	if(name!=NULL)
	{
		if(assoc_init==0)
		{
			g_datalist_init(&assoc_wid_name);
			assoc_init=1;
		}

		g_datalist_set_data(&assoc_wid_name,name,w);
	}
}

void widget_unlog(GtkWidget *w)
{
	char *name;

	name=gtk_widget_get_name(w);
	if(name!=NULL)
	{
		if(assoc_init==0)
		{
			g_datalist_init(&assoc_wid_name);
			assoc_init=1;
		}

		g_datalist_remove_data(&assoc_wid_name,name);
	}
}

/* search inside the wid widget childs to find a widget having the */
/* given widget_name */
GtkWidget *get_widget_by_widget_name(const char *widget_name)
{
	if(assoc_init==0)
		return NULL;

	return g_datalist_get_data(&assoc_wid_name,widget_name);

}

/***************************************************************************/
/* take the string contained in the gtk_entry having the name "entry_name" */
/* and compare it to array.                                                */
/***************************************************************************/
/* output: index of the entry_name content string into array       */
/*         on error or when the string is not found, 0 is returned */
/*******************************************************************/
int gtk_entry_to_number(char *entry_name, const char *array[])
{
	GtkWidget *w;
	int i;
	char *param;

	w=get_widget_by_widget_name(entry_name);
	if(w==NULL)
	{
		printf("%s not found\n",entry_name);
		return 0;
	}

	param=gtk_entry_get_text(GTK_ENTRY(w));
	i=0;
	while(array[i]!=NULL)
	{
		if(!strcmp(array[i],param))
			return i;
		i++;
	}
	printf("%s (in %s) not found\n",param,entry_name);
	return 0;
}

/***************************************************************************/
/* take the string contained in the gtk_entry having the name "entry_name" */
/* and compare it to array.                                                */
/***************************************************************************/
/* output: index of the entry_name content string into array        */
/*         on error or when the string is not found, -1 is returned */
/********************************************************************/
int gtk_entry_to_number_wo_default(char *entry_name, const char *array[])
{
	GtkWidget *w;
	int i;
	char *param;

	w=get_widget_by_widget_name(entry_name);
	if(w==NULL)
	{
		printf("%s not found\n",entry_name);
		return -1;
	}

	param=gtk_entry_get_text(GTK_ENTRY(w));
	i=0;
	while(array[i]!=NULL)
	{
		if(!strcmp(array[i],param))
			return i;
		i++;
	}
	return -1;
}

