#!/usr/bin/env perl

# Some tests for 'darcs push' 

use Test::More tests => 9;
use strict;
use vars qw/$DARCS/;

die 'darcs not found' unless $ENV{DARCS} || (-x "$ENV{PWD}/../darcs");
$DARCS = $ENV{DARCS} || "$ENV{PWD}/../darcs";

`rm -rf temp1 temp2`;
`mkdir -p temp1 temp2/one/two`;
chdir 'temp1';
`$DARCS init`;

chdir '../temp2';
`$DARCS init`;
chdir 'one/two';

###

my $test_name = 'darcs push should work relative to the current directory';
my $push_out = `$DARCS push -a ../../../temp1 2>&1`;
like($push_out, qr/No recorded local changes to push/i, $test_name);

###

my $test_name = 'darcs push should push into repo specified with --repo';
chdir '../../';  # now in temp2
`$DARCS add one`;
`$DARCS record --patch-name 'uno' --all --author foo\@bar`;
chdir '../';     # now outside of any repo
like(`$DARCS push --repodir temp2 --all ../temp1`, # temp2 is relative to temp1
	qr/Finished apply./i, $test_name);

SELF_PUSH: {
    chdir './temp1'; 

    my $default_repo_pre_test = 'Before trying to pull from self, defaultrepo does not exist';
    ok( (! -r './_darcs/prefs/defaultrepo'),$default_repo_pre_test);

    my $test_name = 'return special message when you try to push to yourself';
    like(`$DARCS push -a \`pwd\` 2>&1`, qr/Can't push to current repo!/i, $test_name);

    my $set_default_repo_test = "and don't update the default repo to be the current dir";
    ok( (! -r './_darcs/prefs/defaultrepo'),$set_default_repo_test);

    chdir '../';     # now outside of any repo
}

ok(-d 'temp1', "temp1 exists here");
`rm -rf temp1`;
ok((!-d 'temp1'), 'temp1 directory was deleted');

ok(-d 'temp2', "temp1 exists here");
`rm -rf temp2`;
ok((!-d 'temp2'), 'temp1 directory was deleted');




