<?php
/**
 * Calendar with links to news archives
 * This is to display a small calendar allowing a simple
 * access to the news archives.
 *
 * daCode http://www.dacode.org/
 * src/phplib/cal.php3
 * $Id: cal.php3,v 1.19.2.9 2002/07/26 21:33:37 ruffy Exp $
 *
 * Depends: Config Utils Html Session
 *
 *@author Pascal Terjan <pascal_terjan@bigfoot.com>
 */
class Cal {
	/**
	 * Cache instance
	 *@var object Cache
	 */
	var $cache;
	
	/**
	 * Html subclass instance
	 *@var object Html
	 */
	var $html;
	
	/**
	 * Session instance
	 *@var object Session
	 */
	var $session;

	/**
	 * Constructor 
	 */
	Function Cal() {
		$this->html  = LoadClass('Html');
		$this->cache = LoadClass('Cache');
		$this->session = LoadClass('Session');
	}


	/**
	 * Draw the calendar.
	 * @param int $day Current day
	 * @param int $month Current month
	 * @param int $year Current year
	 * @return string A sidebox with the calendar
	 *@access public
	 */
	Function calbox($day, $month, $year) {
		global $config, $LANG, $HTTP_SERVER_VARS, $path;

		if (empty($day)) {

			/*
			 * This is to get the info from the url in case the page has been
			 * archived
			 */

			if (!isset($path) || empty($path)) {

				if (!empty($HTTP_SERVER_VARS['REQUEST_URI'])) {
					$path = ereg_replace('^/'.$config->htmldir, '/', 
						$HTTP_SERVER_VARS['REQUEST_URI']);
				} else {
					$path = '/';
				}
				if (ereg("^(.*)\\.(html|$config->php)", $path, $res)) {
					$path = $res[1];
					$config->ext = '.'.$res[2];
				}

			}


			if  (ereg('^/([0-9]+)/([0-9]+)/([0-9]+)/index', $path, $res)) {
				$day   = $res[3];
				$month = $res[2];
				$year  = $res[1];
			} else {
				$day   = date("d");
				$month = date("n");
				$year  = date("Y");
			}
		}

		$cachetmp = array ($day, $month, $year,
						$config->score,$config->hide_sig,$config->ext);

		$fcontents = $this->cache->check_box("7200","cal", $cachetmp);

		if (!empty($fcontents)) {
			return $fcontents;
		}

		/* Current day to know when to stop putting links */
		$thisday = date("j");

		/* Two digits month */
		$m2 = ((strlen($month)-1)?"":"0").$month;

		/* Number of days in the month */
		$n = "31";
		if($month == "2") {
			$n -= "2";
			if($year % "4") {
				$n--;
			}
		} elseif ($month < "8" && !($month % "2")) {
			$n--;
		} elseif($month > "8" and ($month % "2")) {
			$n--;
		}

		/* Number of the empty cells before first day of the week + 1 */
		$s = date("w", mktime(0, 0, 0, $month, 1, $year));
		if ($LANG=="fr") {
			if(!$s) {
				$s = 7;
			}
		} else {
			$s++;
		}

		/* Is the month displayed already finished ? */
		$passed = ($year<date("Y"))||((int)$month<(int)date("n")) &&
			($year==date("Y"));

		/* Is the month displayed the current one ? */
		$current = ($year==date("Y"))&&((int)$month==(int)date("n"));

		$d = 1;

		/* Display links for previous/next month + name of current one */
		$prev = mktime(0,0,0,$month-1,1,$year);
		$cur = mktime(0,0,0,$month,$day,$year);
		$next = mktime(0,0,0,$month+1,1,$year);
		$prevy = date("Y",$prev);
		$nexty = date("Y",$next);
		$prevm = date("m",$prev);
		$nextm = date("m",$next);
		$curname = ucfirst(lecho(strtolower(date("F",$cur))));

		$out = '<table width="100%"><tr>'.
			'<td class="calmonth" width="25%"><a href="'.
			$this->session->newsurls("","","",$prevy,$prevm,"01",-2,0).
			'">&lt;&lt;</a></td>'.
			'<td class="calcurmonth" width="50%">'.$curname.' '.$year.'</td>';

		if ($passed) {
			$out .= '<td class="calmonth" width="25%"><a href="'.
				$this->session->newsurls("","","",$nexty,$nextm,"01",-2,0).
				'">&gt;&gt;</a></td>';
		} else {
			$out .= '<td class="calmonth" width="25%">&nbsp;</td>';
		}
		$out .= '</tr></table>';

		$day_array = array (lecho("sunday"),lecho("monday"),
			lecho("tuesday"), lecho("wednesday"),lecho("thursday"),
			lecho("friday"), lecho("saturday"));

		/* Display the days names */
		$out .= '<div align="center"><table width="91%"><tr>';
		if ($LANG=="fr") {
			for ($i=1; $i<7; $i++) {
				$out .= '<td class="cal" width="7%">'.
					ucfirst(substr($day_array[$i],0,2)).'</td>';
			}
			$out .= '<td class="cal" width="7%">'.
				ucfirst(substr($day_array[0],0,2)).'</td>';
		} else {
			/* if not in french first day is sunday */
			for($i=0; $i<7; $i++){
				$out .= '<td class="cal" width="7%">'.
					ucfirst(substr($day_array[$i],0,2)).'</td>';
			}
		}

		$out .= "</tr>\n";

		/* Display the real calendar */
		while ($d<=$n) {
			$out .= '<tr>';
			for ($i=1; $i<=7; $i++) {
				/* Are we before the first day or after the last one ? */
				if ((($d==1) && ($i<$s)) || ($d>$n)) {
					$out .= "<td>&nbsp;</td>\n";
				} else {
				/* Do we need a link ? */
					if (($passed) || ($current && ($thisday>=$d))) {
						$d2 = ((strlen($d)-1)?"":"0").$d;
						$out .= '<td class="cal"><a href="'.
						$this->session->newsurls("", "", "", $year, $m2, $d2,-2,0).'">';

						if ($day == $d) {
							$out .= '<b><u>'.$d.'</u></b>';
						} else {
							$out .= $d;
						}

						$out .= "</a></td>\n";
					} else {
						$out .= '<td class="cal">'.$d."</td>\n";
					}

					$d++;
				}
			}

			$out .= "</tr>\n";
		}
		$out .= "</table></div>\n";
		$title = lecho("Calendar");
		$out = '<!-- CAL -->'.$this->html->sidebox($title,$out."<br />").
		'<!-- /CAL -->';

		$this->cache->write_box("cal",$cachetmp,$out);

		return $out;
	}

}

?>
