/*  cssed (c) Iago Rubio 2003, 2004 - A tiny CSS editor.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 

#define CSSED_WINDOW(n) (CssedWindow*) n

// colors used in the output window
#define ERROR_COLOR_STRING "red"
#define WARNING_COLOR_STRING "navy"

typedef enum {
	EOL_MODE_CRLF,
	EOL_MODE_CR,
	EOL_MODE_LF		
} CssedEolMode;

typedef enum {
	CSSED_CODEPAGE_DEFAULT,
	CSSED_CODEPAGE_UTF8,
	CSSED_CODEPAGE_DBCS
} CssedCodePage;
/* Those are the cssed supported file types.
	Each time you adds anything here, you must update:
	document.c:document_set_filetype()
	document.c:document_get_filetype_from_filename()
	document.c:document_set_font_by_name()
	document.c:document_set_font_size()
*/
typedef enum {
	CSSED_FILETYPE_CSS,			// core language
	CSSED_FILETYPE_HTML,		// this is not just HTML but ASP and PHP
	CSSED_FILETYPE_XML,			// XML and SVG
	CSSED_FILETYPE_TEXT,		// No style , must use LmNull ??
	CSSED_FILETYPE_SH,			// shell and bash scripts
	CSSED_FILETYPE_C,			// not just C but CPP
	CSSED_FILETYPE_APACHE_CONF,	// apache conf files
	CSSED_FILETYPE_LISP,		// mostly for emacs.el files
	CSSED_FILETYPE_PERL,		// perl scripts
	CSSED_FILETYPE_PYTHON,		// python
	CSSED_FILETYPE_SQL,			// SQL (Ansi) 
	CSSED_FILETYPE_DIFF,		// diff and patch files
	CSSED_FILETYPE_MAKE,		// Makefiles - I use make for almost everything :)
	CSSED_FILETYPE_BYNARY,		// not used but may be ( hex rendering ? )
	CSSED_FILETYPE_UNKNOW		// internall use. Never use it.
} CssedFileType;

// those are opaque use only provided functions
typedef struct _CssedDoc CssedDoc;
typedef struct _CssedWindow CssedWindow;

// configuration will be private in a near future
typedef struct _CssedConfig {
	// window
	gint window_x;
	gint window_y;
	gint window_width;
	gint window_height;
	gint notebook_height;
	gint sidebar_width;
	gint treeview_height;
	// document
	gboolean linenumbers;
	gboolean autocompletion;
	gboolean lineendings;
	gboolean whitespaces;
	gboolean folding;
	gboolean lineswraped;
	gchar* font;
	gint font_size;
	// opened docs
	GList* opened_docs;
	// highlighting
	gint DEFAULT_fore_color;
	gint DEFAULT_back_color;
	gboolean DEFAULT_bold;
	gint TAG_fore_color;
	gint TAG_back_color;
	gboolean TAG_bold;
	gint PSEUDOCLASS_fore_color;
	gint PSEUDOCLASS_back_color;
	gboolean PSEUDOCLASS_bold;
	gint UNKNOWN_PSEUDOCLASS_fore_color;
	gint UNKNOWN_PSEUDOCLASS_back_color;	
	gboolean UNKNOWN_PSEUDOCLASS_bold;
	gint OPERATOR_fore_color;
	gint OPERATOR_back_color;
	gboolean OPERATOR_bold;
	gint IDENTIFIER_fore_color;	
	gint IDENTIFIER_back_color;	
	gboolean IDENTIFIER_bold;
	gint UNKNOWN_IDENTIFIER_fore_color;
	gint UNKNOWN_IDENTIFIER_back_color;
	gboolean UNKNOWN_IDENTIFIER_bold;
	gint VALUE_fore_color;
	gint VALUE_back_color;	
	gboolean VALUE_bold;
	gint COMMENT_fore_color;
	gint COMMENT_back_color;
	gboolean COMMENT_bold;
	gint IMPORTANT_fore_color;
	gint IMPORTANT_back_color;
	gboolean IMPORTANT_bold;
	gint DIRECTIVE_fore_color;
	gint DIRECTIVE_back_color;
	gboolean DIRECTIVE_bold;
	gint DOUBLESTRING_fore_color;
	gint DOUBLESTRING_back_color;	
	gboolean DOUBLESTRING_bold;
	gint SINGLESTRING_fore_color;
	gint SINGLESTRING_back_color;
	gboolean SINGLESTRING_bold;
	gint CLASS_fore_color;
	gint CLASS_back_color;	
	gboolean CLASS_bold;
	gint ID_fore_color;
	gint ID_back_color;	
	gboolean ID_bold;
	gint VALID_VALUE_fore_color;
	gint VALID_VALUE_back_color;
	gboolean VALID_VALUE_bold;
	gint FUNCTION_fore_color;
	gint FUNCTION_back_color;
	gboolean FUNCTION_bold;
	gint NUMBER_fore_color;
	gint NUMBER_back_color;
	gboolean NUMBER_bold;
	gint UNIT_fore_color;
	gint UNIT_back_color;
	gboolean UNIT_bold;
	gint COLOR_fore_color;
	gint COLOR_back_color;	
	gboolean COLOR_bold;
	gint HEXACOLOR_fore_color;
	gint HEXACOLOR_back_color;	
	gboolean HEXACOLOR_bold;
	gint ATTR_MATCH_fore_color;
	gint ATTR_MATCH_back_color;	
	gboolean ATTR_MATCH_bold;
	gint LANGUAGE_fore_color;
	gint LANGUAGE_back_color;	
	gboolean LANGUAGE_bold;
} CssedConfig;

typedef struct _CssedConfigParserData {
	CssedWindow* window;
	gint depth;
	gint state;	
	GList* plugins_list; 					// store plugins to be loaded from the config file
}  CssedConfigParserData;

/* window functions*/
CssedWindow* cssed_window_new(void);
void cssed_window_quit( CssedWindow* window );
void cssed_window_destroy( CssedWindow* window );
gint cssed_window_get_width( CssedWindow* window );
gint cssed_window_get_height( CssedWindow* window );
// object access
GtkWidget* cssed_window_get_window_widget ( CssedWindow* window );
void cssed_window_set_window_widget ( CssedWindow* window, GtkWidget* widget );
GtkWidget* cssed_window_get_document_notebook ( CssedWindow* window );
void cssed_window_set_document_notebook ( CssedWindow* window, GtkWidget* widget );
GtkWidget* cssed_window_get_footer_notebook ( CssedWindow* window );
void cssed_window_set_footer_notebook ( CssedWindow* window, GtkWidget* widget );
GtkWidget* cssed_window_get_sidebar_notebook ( CssedWindow* window );
void cssed_window_set_sidebar_notebook ( CssedWindow* window, GtkWidget* widget );
GtkWidget* cssed_window_get_css_definition_treeview ( CssedWindow* window );
void cssed_window_set_css_definition_treeview ( CssedWindow* window, GtkWidget* widget );
GtkWidget* cssed_window_get_selector_scanner_treeview ( CssedWindow* window );
void cssed_window_set_selector_scanner_treeview ( CssedWindow* window, GtkWidget* widget );
GtkWidget* cssed_window_get_output_treeview ( CssedWindow* window );
void cssed_window_set_output_treeview ( CssedWindow* window, GtkWidget* widget );
GtkWidget* cssed_window_get_digest_treeview ( CssedWindow* window );
void cssed_window_set_digest_treeview ( CssedWindow* window, GtkWidget* widget );
GtkWidget* cssed_window_get_pop_menu ( CssedWindow* window );
void cssed_window_set_pop_menu ( CssedWindow* window, GtkWidget* widget );
GtkTextBuffer* cssed_window_get_scratch_buffer ( CssedWindow* window );
void cssed_window_set_scratch_buffer ( CssedWindow* window, GtkTextBuffer* widget );
//
void cssed_window_dynamic_menus_set_full( CssedWindow* window,
										  GtkWidget *menu_item_line_numbers,
										  GtkWidget *menu_item_endings,
										  GtkWidget *menu_item_white_spaces,
										  GtkWidget *menu_item_lines_wrapped,
										  GtkWidget *menu_item_eol_mode_cr,
										  GtkWidget *menu_item_eol_mode_lf,
										  GtkWidget *menu_item_eol_mode_crlf,
										  GtkWidget *menu_item_autocompletion,
										  GtkWidget *menu_item_folding );
										  
void cssed_window_dynamic_menus_set_state(CssedWindow* window,
										  gboolean line_numbers_enabled,
										  gboolean line_endings_enabled,
										  gboolean white_spaces_enabled,
										  gboolean lines_wrapped_enabled,
										  gboolean autocompletion_enabled,
										  gboolean folding_enabled );
										  
void cssed_window_dynamic_menus_set_eols_state( CssedWindow* window, 
												CssedEolMode eols );										  
//
void cssed_window_dynamic_widgets_set(	CssedWindow* window,
										GtkWidget* save_button,			
										GtkWidget* save_main_menu,	
										GtkWidget* undo_button,
										GtkWidget* undo_main_menu,
										GtkWidget* undo_pop_menu,
										GtkWidget* redo_button,
										GtkWidget* redo_main_menu,
										GtkWidget* redo_pop_menu );
//
void 
cssed_window_panes_set(	CssedWindow* window, 
						GtkWidget* vpaned_main,
						GtkWidget* hpaned_up,
						GtkWidget* vpaned_sidebar );

void
cssed_window_ensure_output_visible( CssedWindow* window );

void
cssed_window_ensure_selector_scanner_visible( CssedWindow* window );
//
void cssed_window_set_last_open_dir( CssedWindow* window, gchar* dirname );
gchar* cssed_window_get_last_open_dir( CssedWindow* window );
void cssed_window_set_last_save_dir( CssedWindow* window, gchar* dirname );
gchar* cssed_window_get_last_save_dir( CssedWindow* window );
//
void cssed_window_set_last_scan_file( CssedWindow* window, gchar* filename );
gchar* cssed_window_get_last_scan_file( CssedWindow* window );
//
void cssed_window_output_write( CssedWindow* window, gchar* message );
void cssed_window_output_clear( CssedWindow* window );
//
void cssed_window_digest_write( CssedWindow* window, gchar* first_col,  gchar* second_col);
void cssed_window_digest_clear( CssedWindow* window );
//
void cssed_window_selector_scanner_write( CssedWindow* window, gchar* first_col,  gchar* second_col);
void cssed_window_selector_scanner_clear( CssedWindow* window );
void cssed_window_selector_scanner_edited ( CssedWindow* window,
											gchar *path_string,
											gchar *new_text 	);
// config
CssedConfig* cssed_window_get_config( CssedWindow* window );
CssedConfig* cssed_window_config_new ();
// widgets
void cssed_window_enable_save ( CssedWindow* window );
void cssed_window_disable_save( CssedWindow* window );
void cssed_window_enable_undo ( CssedWindow* window );
void cssed_window_disable_undo( CssedWindow* window );
void cssed_window_enable_redo ( CssedWindow* window );
void cssed_window_disable_redo( CssedWindow* window );
// config
void cssed_window_show_preferences_dialog( CssedWindow* window );
// document list
void cssed_window_add_document_to_list( CssedWindow* window, CssedDoc* doc );
void cssed_window_delete_document_from_list( CssedWindow* window, CssedDoc* doc );
gint cssed_window_get_document_list_length( CssedWindow* window );
GList* cssed_window_get_document_list_first( CssedWindow* window );
// plugins list
void cssed_window_add_plugin_to_list( CssedWindow* window, gpointer plugin );
void cssed_window_delete_plugin_from_list( CssedWindow* window, gpointer plugin );
gint cssed_window_get_plugin_list_length( CssedWindow* window );
GList* cssed_window_get_plugin_list_first( CssedWindow* window );
// keyword list
gchar* cssed_window_get_keyword_list( CssedWindow* window );
void cssed_window_set_keyword_list( CssedWindow* window, gchar* keywords );
void cssed_window_free_keyword_list( CssedWindow* window );
// css dialogs
void cssed_window_css_dialog_insert( CssedWindow* window, gchar* key, gpointer class );
void cssed_window_css_dialog_remove_by_keyword( CssedWindow* window, gchar* key );
gpointer cssed_window_css_dialog_lookup_by_keyword( CssedWindow* window, gchar* key );
gboolean cssed_window_css_dialog_keyword_in_use( CssedWindow* window, gchar* key );
//
gboolean cssed_window_is_file_opened( CssedWindow* window, gchar* file );
//
gint cssed_window_get_num_docs( CssedWindow* window );
void cssed_window_set_ndoc_active( CssedWindow* window, gint doc_number );
