/*  
    switch.c: for cscore

    Copyright (C) 1991 Barry Vercoe

    This file is part of Csound.

    Csound is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Csound is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Csound; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "cscore.h"                              /*   CSCORE_SWITCH.C  */

                     /* cscore control test: switch betw two 2-sect scores */
                     /* the warped/un-warped quality should be preserved   */

void cscore()        /* program callable from either Csound or Cscore_main */
{
	EVLIST *a, *b;
	FILE   *fp1, *fp2;

	fp1 = getcurfp();
	fp2 = filopen("score2.srt");

	a = lget();		/* read sect from score 1 */
	lput(a);		/* write it out as is */
	putstr("s");
	setcurfp(fp2);
	b = lget();             /* read sect from score 2 */
	lput(b);		/* write it out as is */
	putstr("s");

	lrelev(a);              /* optional to reclaim space */
	lrelev(b);

	setcurfp(fp1);
	a = lget();		/* read next sect from score 1 */
	lput(a);		/* write it out */
	putstr("s");
	setcurfp(fp2);
	b = lget();             /* read next sect from score 2 */
	lput(b);		/* write it out */
	putstr("e");
}


