/***************************************************************************
 *   Copyright (C) 2004 by Armand                                          *
 *   armand@blackbox                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef ERREUR_H
#define ERREUR_H

#include <wx/wxprec.h>
#ifndef WX_PRECOMP
	#include <wx/wx.h>
#endif

#include <../P11Error.hh>

/**
 * A subclass of Cryptonit::P11Error, used to pop-up information or error
 * dialogs caused by PKCS#11 unexpected states.
 * @author Armand
 */
class Erreur : public Cryptonit::P11Error
{
public:
	Erreur(wxWindow* parent, const wxString& caption = wxT("PKCS#11 information"));
	
	virtual void newMessage(P11E_TYPE _type, 
			std::string _title, 
			std::string _explanation = "");
			
	virtual ~Erreur();

private:
	wxWindow * parentwindow;
	wxString dlgCaption;
	wxString dlgMessage;
	long dlgStyle;

};

#endif
