/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright ? 2004 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */
#ifndef _P11_DEVICE_HH_
#define _P11_DEVICE_HH_

#include <string>

namespace Cryptonit
{
    class P11Device
    {
    private:

	/* Device information */
	/* NOTE: Is it a good idea to distingusih this informations ? */

	/** Vendor name */
	std::string vendor;

	/** Product name */
	std::string product;

	/** Manufacturer name, different from Vendor in case of rebranding */
	std::string manufacturer;

	/** Original modem name, different from product in case of rebranding */
	std::string model;


	/* Driver information */
	/** Driver filename without the path.
	 *  This filename is OS dependant. Leave it blank if there is no driver
	 *  for the OS.
	 *  This value does not guarantee the file existence.
	 */
	std::string driverFilename;

	/** Complete path to the driver.
	 *  This value does not guarantee the file existence.
	 */
	std::string driverPath;

    public:

	/** Create a new P11Device */
	P11Device( const std::string vendor_, const std::string product_,
		   const std::string driverPath_,
		   const std::string driverFilename_)
	    : vendor(vendor_), product(product_), driverPath(driverPath_),
	      driverFilename(driverFilename_) {};

	/** Create a new P11Device */
	P11Device( const std::string vendor_, const std::string product_,
		   const std::string manufacturer_, const std::string model_,
		   const std::string driverPath_,
		   const std::string driverFilename_)
	    : vendor(vendor_), product(product_), manufacturer(manufacturer_),
	      model(model_), driverPath(driverPath_),
	      driverFilename(driverFilename_) {};

	~P11Device() {};

	std::string getVendor() { return vendor; };
	std::string getProduct() { return product; };
	std::string getManufacturer() { return manufacturer; };
	std::string getModel() { return model; };

	std::string getDriverFilename() { return driverFilename; };
	std::string getDriverPath() { return driverPath; };

	/** Concatenation of getDriverPath with get DriverFilename
	 *  This value does not guarantee the file existence.
	 */
	std::string getDriverFile() { return driverPath + driverFilename; };
    };
}
#endif
