#include "memory"

void Memory::free(void *ptr) {
    if (!ptr)
	return;
    
    for (unsigned i = 0; i < s_memlog.size(); i++) {
	Mutex::lock(&s_memlog);
	MemoryEntry ent = s_memlog[i];
	Mutex::unlock(&s_memlog);
	if (ent.ptr == ptr) {
	    if (s_follow) {
		Mutex::lock(&cout);
		cout << "Memory::free(" << ptr << ")\n";
		Mutex::unlock(&cout);
	    }
	    ::free (ent.ptr);
	    Mutex::lock(&s_memlog);
	    s_memlog.erase(s_memlog.begin() + i);
	    Mutex::unlock(&s_memlog);
	    return;
	}
    }
    cerr << "FREE Request for non previously allocated memory\n";
}
