/*****************************************************************
 *
 *   menu.c
 *
 *     Copyright (c) 2000  Kam Tik <kamtik@hongkong.com>
 *
 *	http://debian.kamtik.net
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 ******************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "cpanel.h"
#include "defaults.h"
#include <stdio.h>

extern gboolean if_gb;
extern gboolean if_float;
extern gboolean if_root;
extern gboolean if_not_warning;
extern gint coord_x;
extern gint coord_y;
extern gchar version_server_name[STR_BUFFER_SIZE];
extern gint version_port;

GtkWidget *entry_coord[2];
GtkWidget *check_button[2];

GtkWidget *entry_version_server[2];

GtkWidget *create_menu(GtkWidget *menu, gchar *label);

void trad_selected(GtkWidget *button, gpointer data)
{
	if_gb = 0;
}

void simp_selected(GtkWidget *button, gpointer data)
{
	if_gb = 1;
}

void show_note(GtkWidget *button, gpointer data)
{
	simple_message_dialog(_("Please set locale again and restart CPanel"),_("Close"));
}

void show_hints(GtkWidget *button, gpointer *data)
{
	show_help("cpanel_help",_("Welcome to CPanel"),600,400);
}

void ok_pref(GtkWidget *button, gpointer *data)
{
	coord_x = atof(gtk_entry_get_text(GTK_ENTRY(entry_coord[0])));
	coord_y = atof(gtk_entry_get_text(GTK_ENTRY(entry_coord[1])));
	if_float = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_button[0]));
	if_not_warning = !(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_button[1])));
	strcpy(version_server_name, gtk_entry_get_text(GTK_ENTRY(entry_version_server[0])));
	version_port = atof(gtk_entry_get_text(GTK_ENTRY(entry_version_server[1])));

	saveconfig();
}

void preference(GtkWidget *menu, gpointer *data)
{
	GtkWidget *dialog;
	GtkWidget *button;
	GtkWidget *options;
	GtkWidget *notebook;
	GtkWidget *label;
	GtkWidget *frame;
	GtkWidget *vbox;
	GtkWidget *hbox;
	gchar *str_x;
	gchar *str_y;
	gchar *str_version_port;

	dialog = gtk_dialog_new();

	notebook = gtk_notebook_new();

	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),notebook,FALSE,FALSE,0);

	/*********************
	 * Positioning page
	 * *******************/
	label = gtk_label_new(_("Positioning"));
	frame = gtk_frame_new("");
	vbox = gtk_vbox_new(FALSE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),frame,label);

	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",
			GTK_SIGNAL_FUNC(close_win),dialog);

	gtk_window_set_title(GTK_WINDOW(dialog),_("Options"));
	gtk_container_set_border_width(GTK_CONTAINER(dialog),5);

	/* making a check option */
	check_button[0] = make_check_opt(_("Use floating tools tar"),if_float);
	gtk_box_pack_start(GTK_BOX(vbox),check_button[0],TRUE,TRUE,1);
	/* getting x, y coordinates */
	str_x = malloc(10*sizeof(gchar));
	str_y = malloc(10*sizeof(gchar));
	sprintf(str_x,"%d",coord_x);
	sprintf(str_y,"%d",coord_y);
	options = make_opt(_("X Coordinate: "),entry_coord,0,str_x);
	gtk_box_pack_start(GTK_BOX(vbox), options,TRUE,TRUE,1);
	options = make_opt(_("Y Coordinate: "),entry_coord,1,str_y);
	gtk_box_pack_start(GTK_BOX(vbox), options,TRUE,TRUE,1);

	gtk_container_add(GTK_CONTAINER(frame),vbox);

	/***************************
	 * Safety Policy
	 * *************************/
	
	label = gtk_label_new(_("Safety Policy"));
	frame = gtk_frame_new("");

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),frame,label);

	check_button[1] = make_check_opt(_("Show all warnings"),!if_not_warning);
	gtk_container_add(GTK_CONTAINER(frame),check_button[1]);

	/**************************
	 * Versioning System
	 * ************************/

	label = gtk_label_new(_("Update reminder"));
	frame = gtk_frame_new("");

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),frame,label);
	hbox = gtk_hbox_new(FALSE,0);

	options = make_opt(_("Server name: "),entry_version_server,0,version_server_name);
	gtk_box_pack_start(GTK_BOX(hbox),options,FALSE,FALSE,3);

	str_version_port = malloc(10*sizeof(gchar));
	sprintf(str_version_port,"%d",version_port);
	options = make_opt(_("Port: "),entry_version_server,1,str_version_port);
	gtk_box_pack_start(GTK_BOX(hbox),options,FALSE,FALSE,3);

	gtk_container_add(GTK_CONTAINER(frame),hbox);

	/**************************
	 * buttons
	 * ***********************/

	button = gtk_button_new_with_label(_("Cancel"));
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),dialog);
	gtk_box_pack_end(GTK_BOX(GTK_DIALOG(dialog)->action_area),
			button,TRUE,TRUE,0);

	button = gtk_button_new_with_label(_("OK"));
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(ok_pref),NULL);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),dialog);
	gtk_box_pack_end(GTK_BOX(GTK_DIALOG(dialog)->action_area),
			button,TRUE,TRUE,0);

	gtk_widget_grab_default(button);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
}

void select_lang(GtkWidget *ment_item, gpointer data)
{
	GtkWidget *win;
	GtkWidget *button;
	GtkWidget *radio;
	GSList *group = NULL;

	win = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(win),_("Select Language"));
	gtk_container_set_border_width(GTK_CONTAINER(win),10);

	radio = gtk_radio_button_new_with_label(group,_("Traditional Chinese"));
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(radio));
	gtk_signal_connect(GTK_OBJECT(radio),"toggled",
			GTK_SIGNAL_FUNC(trad_selected),NULL);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),radio,FALSE,FALSE,5);
	if(!if_gb)
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(radio),TRUE);

	radio = gtk_radio_button_new_with_label(group,_("Simplified Chinese"));
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(radio));
	gtk_signal_connect(GTK_OBJECT(radio),"toggled",
			GTK_SIGNAL_FUNC(simp_selected),NULL);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),radio,FALSE,FALSE,5);
	if(if_gb)
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(radio),TRUE);

	button = gtk_button_new_with_label(_("Close"));
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(radio),"clicked",
			GTK_SIGNAL_FUNC(show_note),NULL);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),win);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,2);
	gtk_widget_grab_default(button);

	gtk_widget_show_all(win);
}

GtkWidget *cpanel_create_menu_bar(void)
{
	GtkWidget *menu_bar;
	GtkWidget *menu;
	GtkWidget *menu_item;

	menu_bar = gtk_menu_bar_new();

	/* Program */
	menu_item = gtk_menu_item_new_with_label(_("Program"));
	gtk_menu_bar_append(GTK_MENU_BAR(menu_bar),menu_item);

	menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item),menu);

	if(if_root)
	{
	menu_item = create_menu(menu, _("Smart Update"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(apt_process),"cpanel");
	}

	if(if_root)
	{
	menu_item = create_menu(menu, _("Install New Programs"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(install_list),NULL);
	}

	menu_item = create_menu(menu, _("Quit"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(save_opt),NULL);
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(gtk_exit),NULL);

	/* Setting */
	menu_item = gtk_menu_item_new_with_label(_("Setting"));
	gtk_menu_bar_append(GTK_MENU_BAR(menu_bar),menu_item);

	menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item),menu);

	menu_item = create_menu(menu, _("Select Language"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(select_lang),NULL);

	if(if_root)
	{
	menu_item = create_menu(menu, _("Chinese TrueType fonts setup"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(xtt_config),NULL);
	}

	menu_item = create_menu(menu, _("Preference"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(preference),NULL);

	/* Help */
	menu_item = gtk_menu_item_new_with_label(_("Help"));
	gtk_menu_bar_append(GTK_MENU_BAR(menu_bar),menu_item);

	menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item),menu);

	menu_item = create_menu(menu, _("System Check"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(sys_info_page),NULL);

	menu_item = create_menu(menu, _("Hints"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(show_hints),NULL);

	menu_item = create_menu(menu, _("About"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(display_about_page),NULL);


	return menu_bar;
}


GtkWidget *create_menu(GtkWidget *menu, gchar *label)
{
	GtkWidget *menu_item;

	menu_item = gtk_menu_item_new_with_label(label);
	gtk_menu_append(GTK_MENU(menu),menu_item);

	return menu_item;
}
