#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "cpanel.h"

extern gboolean if_gb;
extern gboolean is_xcin23;
extern gboolean is_xacv;
extern gboolean is_chinput;
extern gboolean is_pydict;
extern gboolean if_xcingb;

extern gboolean is_bsmi00lp;
extern gboolean is_bkai00mp;
extern gboolean is_gbsn00lp;
extern gboolean is_gkai00mp;

void install_list(GtkWidget *pre_button, gpointer data)
{
	GtkWidget *win;
	GtkWidget *button;
	GtkWidget *frame;
	GtkWidget *button_box;

	win = gtk_dialog_new();
	gtk_container_set_border_width(GTK_CONTAINER(win),10);
	gtk_window_set_title(GTK_WINDOW(win),_("Install new program"));

	/* XA + CV */
if(!is_xacv)
{
	frame = gtk_frame_new(_("XA+CV"));
	button_box = gtk_hbox_new(FALSE,0);

	button = pack_icon_label_button(PREFIX "/share/cpanel/pixmaps/xacv_icon.xpm",_(" Install xa+cv"),button_box,win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(apt_process),"xa+cv");

	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/help_icon.xpm",button_box, win);
        gtk_signal_connect(GTK_OBJECT(button),"clicked",
                        GTK_SIGNAL_FUNC(xacv_help),NULL);

	gtk_container_add(GTK_CONTAINER(frame),button_box);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),frame,FALSE,FALSE,4);
}

if(!is_chinput)
{
	frame = gtk_frame_new(_("Chinput"));
	button_box = gtk_hbox_new(FALSE,0);

	button = pack_icon_label_button(PREFIX "/share/cpanel/pixmaps/chinput.xpm",_(" Install chinput"),button_box,win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(apt_process),"chinput");

	/*
	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/help_icon.xpm",button_box, win);
        gtk_signal_connect(GTK_OBJECT(button),"clicked",
                        GTK_SIGNAL_FUNC(chinput_help),NULL);
			*/

	gtk_container_add(GTK_CONTAINER(frame),button_box);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),frame,FALSE,FALSE,4);
}

if(!is_bsmi00lp || !is_bkai00mp || !is_gbsn00lp || !is_gkai00mp)
{
	frame = gtk_frame_new(_("Chinese fonts"));
	button_box = gtk_hbox_new(FALSE,0);

	if(!is_bsmi00lp)
	{
	button = pack_button(_("Arphic Mingti (Big5)"),button_box);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(apt_process),"xfonts-arphic-bsmi00lp");
	}

	if(!is_bkai00mp)
	{
	button = pack_button(_("Arphic Songti (Big5)"),button_box);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(apt_process),"xfonts-arphic-bsai00mp");
	}

	if(!is_gbsn00lp)
	{
	button = pack_button(_("Arphic Songti (GB)"),button_box);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(apt_process),"xfonts-arphic-gbsn00lp");
	}

	if(!is_gkai00mp)
	{
	button = pack_button(_("Arphic Mingti (GB)"),button_box);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(apt_process),"xfonts-arphic-gkai00mp");
	}


	gtk_container_add(GTK_CONTAINER(frame),button_box);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),frame,FALSE,FALSE,4);
}


	/* XCIN 2.3 */
if(!is_xcin23 && !if_gb)
{
	frame = gtk_frame_new(_("Chinese Input"));
	button_box = gtk_hbox_new(FALSE,0);

	button = pack_icon_label_button(PREFIX "/share/cpanel/pixmaps/xcin23_icon.xpm",_(" Install xcin2.3"),button_box,win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(apt_process),"xcin2.3");

	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/help_icon.xpm",button_box,win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(xcin23_help),NULL);

	gtk_container_add(GTK_CONTAINER(frame),button_box);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),frame,FALSE,FALSE,4);
}

	/* Chinese Dictionary */
if(!is_pydict && !if_gb)
{
	frame = gtk_frame_new(_("Chinese Dictionary"));
	button_box = gtk_hbox_new(FALSE,0);

	button = pack_icon_label_button(PREFIX "/share/cpanel/pixmaps/pydict_icon.xpm",_(" Install PyDict"),button_box,win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
                        GTK_SIGNAL_FUNC(apt_process),"pydict");
	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/help_icon.xpm",button_box,win);
        gtk_signal_connect(GTK_OBJECT(button),"clicked",
                        GTK_SIGNAL_FUNC(pydict_help),NULL);

        gtk_container_add(GTK_CONTAINER(frame),button_box);
        gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),frame,FALSE,FALSE,4);
}


	/* CLOSE Window */
	button = gtk_button_new_with_label(_("Close"));
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),win);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,0);
	gtk_widget_grab_default(button);
	gtk_widget_show_all(win);
}
