/*****************************************************************
 *
 *   crxvt.c
 *
 *     Copyright (c) 2000  Kam Tik <kamtik@hongkong.com>
 *
 *	http://debian.kamtik.net
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 ******************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "cpanel.h"
#include "defaults.h"

extern gchar crxvt_command[STR_BUFFER_SIZE];
extern gchar crxvt_bg[STR_BUFFER_SIZE];
extern gchar crxvt_fg[STR_BUFFER_SIZE];
extern gchar crxvt_fonts[STR_BUFFER_SIZE];
extern gchar crxvt_im[STR_BUFFER_SIZE];

GtkWidget *entry[5];

void ok_crxvt(GtkWidget *button, gpointer *data)
{
	strcpy(crxvt_command,gtk_entry_get_text(GTK_ENTRY(entry[0])));
	strcpy(crxvt_bg,gtk_entry_get_text(GTK_ENTRY(entry[1])));
	strcpy(crxvt_fg,gtk_entry_get_text(GTK_ENTRY(entry[2])));
	strcpy(crxvt_fonts,gtk_entry_get_text(GTK_ENTRY(entry[3])));
	strcpy(crxvt_im,gtk_entry_get_text(GTK_ENTRY(entry[4])));
}

void def_crxvt(GtkWidget *button, gpointer *data)
{
	gtk_entry_set_text(GTK_ENTRY(entry[0]),CRXVT_COMMAND);
	gtk_entry_set_text(GTK_ENTRY(entry[1]),CRXVT_BG);
	gtk_entry_set_text(GTK_ENTRY(entry[2]),CRXVT_FG);
	gtk_entry_set_text(GTK_ENTRY(entry[3]),CRXVT_FONTS);
	gtk_entry_set_text(GTK_ENTRY(entry[4]),CRXVT_IM);
}

void help_crxvt(GtkWidget *button, gpointer *data)
{
	show_help("crxvt_opt",_("Help - crxvt Options"),
			600,300);
}


void crxvt(GtkWidget *button, gpointer *data)
{
	gchar *command;
	command = g_strconcat(crxvt_command," -bg ",crxvt_bg," -fg ",crxvt_fg,
			" -fm \"",crxvt_fonts,"\" -im ",crxvt_im," &",NULL);
	system(command);
}

void crxvt_opt(GtkWidget *button, gpointer *data)
{
	/* entry[]: 0.command 1.bg 2.fg 3.fonts 4.im */
	GtkWidget *win;
	GtkWidget *vbox;
	GtkWidget *hbox;
	/* buttons */
	GtkWidget *ok_button;
	GtkWidget *cancel_button;
	GtkWidget *def_button;
	GtkWidget *help_button;
	GtkWidget *separator;

	/* Make the button inactive */
	win = make_opt_win(_("Options - crxvt"),button);

	vbox = gtk_vbox_new(FALSE,0);

	/* Make Option: make_opt(label,entry,number,value) */
	hbox = make_opt(_("Command: "),entry,0,crxvt_command);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,1);
	hbox = make_opt(_("Background: "),entry,1,crxvt_bg);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,1);
	hbox = make_opt(_("Foreground: "),entry,2,crxvt_fg);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,1);
	hbox = make_fonts_opt(_("Fonts: "),entry,3,crxvt_fonts,win);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,1);
	hbox = make_opt(_("XIM Server Name: "),entry,4,crxvt_im);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,1);

	/* OK CANEL DEFAULT HELP */
	ok_button = gtk_button_new_with_label(_("OK"));
	gtk_signal_connect(GTK_OBJECT(ok_button),"clicked",
			GTK_SIGNAL_FUNC(ok_crxvt),NULL);

	cancel_button = gtk_button_new_with_label(_("Cancel"));

	def_button = gtk_button_new_with_label(_("Use Defaults"));
	gtk_signal_connect(GTK_OBJECT(def_button),"clicked",
			GTK_SIGNAL_FUNC(def_crxvt),NULL);

	help_button = gtk_button_new_with_label(_("Help"));
	gtk_signal_connect(GTK_OBJECT(help_button),"clicked",
			GTK_SIGNAL_FUNC(help_crxvt),NULL);

	/* Make buttons: make_button(ok,canel,def,help,win); */
	separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox),separator,FALSE,FALSE,5);
	hbox = make_button(ok_button,cancel_button,def_button,help_button,
			win,button);
	gtk_box_pack_end(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

	/* show window */
	gtk_container_add(GTK_CONTAINER(win),vbox);
	gtk_widget_show_all(win);
}

void crxvt_help(GtkWidget *button, gpointer *data)
{
	show_help("crxvt_help",_("Help - crxvt"),500,200);
}
