/*  cpanel - Debian Chinese Panel
 *  Copyright (C) 2000  Kam Tik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "cpanel.h"

extern gboolean if_gb;
extern gboolean if_root;
extern gboolean if_woody_locales;
extern gboolean is_zh_TW_linked;
extern gboolean is_zh_CN_linked;
extern gboolean if_welcome;
extern gboolean if_float;
extern gint coord_x;
extern gint coord_y;
extern gboolean is_crxvt;
extern gboolean is_xcin;
extern gboolean is_xacv;
extern gboolean is_xcin23;
extern gboolean is_xcingb;
extern gboolean is_pydict;

gboolean start_by_main_win=1;
gboolean if_config_loaded=0;

/* prototype */
void core(void);
void arg_handler(int argc, char *argv[]);

void show_win(GtkWidget *button, gpointer *win)
{
	gtk_widget_show_all(GTK_WIDGET(win));
}

void hide_win(GtkWidget *button, gpointer *win)
{
	gtk_widget_hide(GTK_WIDGET(win));
}

void show_mini(GtkWidget *button, gpointer *win)
{
	if(!if_float)
	gtk_widget_show_all(GTK_WIDGET(win));
}

void show_float(GtkWidget *button, gpointer *win)
{
	if(if_float)
	{
	gtk_widget_popup(GTK_WIDGET(win),coord_x,coord_y);
	gtk_widget_show_all(GTK_WIDGET(win));
	}
}

int main(int argc, char *argv[])
{
	gboolean locales_warning = 0;

	/* argument handling */
	arg_handler(argc,argv);

	/* here we search the if files are present */
	search_file();
	search_program();
	sys_check();
	if(!if_config_loaded)
		loadconfig();

	/* set locale */
if(if_gb)
{
	setenv("LANG","zh_CN.GB2312",1);
	setenv("LC_ALL","zh_CN.GB2312",1);
}
else
{
	setenv("LANG","zh_TW.Big5",1);
	setenv("LC_ALL","zh_TW.Big5",1);
}

	/* link if woody locales is installed */
	if(if_woody_locales)
	{
		if(!is_zh_TW_linked || !is_zh_CN_linked)
		{
			if(if_root)
			{
				FILE *f;
				printf("Generating Chinese locales...\n");
				system("mv /etc/locale.gen /tmp");
				f = fopen("/etc/locale.gen","w");
				if(!f)
					g_warning("Error processing /etc/locale.gen!");
				fprintf(f,"zh_CN GB2312\nzh_CN.GB18030 GB18030\nzh_HK BIG5HKSCS\nzh_TW BIG5\nzh_TW.EUC-TW EUC-TW");
				fclose(f);
				
				system("locale-gen");
				system("rm /etc/locale.gen");
				system("mv /tmp/locale.gen /etc");
				printf("DONE!\n");
			}
			else
				locales_warning =1;
		}
	}

	/* gettext */
	gtk_set_locale();
	bindtextdomain("cpanel","/usr/share/locale");
	textdomain("cpanel");

	gtk_init(&argc,&argv);

	if(if_welcome)
		init_process();
	/*
		simple_message_dialog(_("Thank you for using CPanel.\nCPanel will now create ~/.cpanelrc for storing your settings.\nPlease set the GTK+ fonts and Locale now.\nEnjoy!"),_("Close"));
		*/
	if(locales_warning)
		simple_message_dialog("Note: you are using woody's locales,\nplease login as root and execute CPanel once.\nWe will fix the problem for you.",_("OK"));

	if(if_version_newer())
		update_notice_dialog();

	core();

	gtk_main();
	return 0;
}

void core(void)
{
	/* main */
	GtkWidget *main_win, *top_banner, *mini_banner, *mini_banner_float;
	GtkWidget *frame;
	GtkWidget *button;
	GtkWidget *button4mini;
	GtkWidget *hbox;
	/* GtkWidget *container; */
	GtkWidget *vbox;
	GtkWidget *vbox1;
	GtkWidget *vbox2;
	GtkWidget *vbox_in_frame;
	GtkWidget *button_box;
	GtkWidget *menu;
	/* mini */
	GtkWidget *mini_win;
	GtkWidget *mini_hbox;
	GtkWidget *mini_hbox_float;
	GtkWidget *mini_button;
	GtkWidget *main_button;
	GtkWidget *main_button_float;
	GtkWidget *mini_win_float;

	/* Make windows */
	main_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);

	mini_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	mini_win_float = gtk_window_new(GTK_WINDOW_POPUP);

	gtk_window_set_title(GTK_WINDOW(main_win),MAIN_WIN_TITLE);
	gtk_window_set_title(GTK_WINDOW(mini_win),MINI_WIN_TITLE);


	gtk_container_set_border_width(GTK_CONTAINER(mini_win),MINI_WIN_BORDER);
	gtk_container_set_border_width(GTK_CONTAINER(mini_win_float),MINI_WIN_BORDER);
	gtk_widget_realize(main_win);
	gtk_widget_realize(mini_win);
	gtk_widget_realize(mini_win_float);
	gtk_signal_connect(GTK_OBJECT(main_win),"delete_event",
			GTK_SIGNAL_FUNC(save_opt),NULL);
	gtk_signal_connect(GTK_OBJECT(main_win),"destroy",
			GTK_SIGNAL_FUNC(save_opt),NULL);
	gtk_signal_connect(GTK_OBJECT(mini_win),"delete_event",
			GTK_SIGNAL_FUNC(save_opt),NULL);
	gtk_signal_connect(GTK_OBJECT(mini_win),"destroy",
			GTK_SIGNAL_FUNC(save_opt),NULL);
	gtk_signal_connect(GTK_OBJECT(main_win),"delete_event",
			GTK_SIGNAL_FUNC(gtk_exit),NULL);
	gtk_signal_connect(GTK_OBJECT(main_win),"destroy",
			GTK_SIGNAL_FUNC(gtk_exit),NULL);
	gtk_signal_connect(GTK_OBJECT(mini_win),"delete_event",
			GTK_SIGNAL_FUNC(gtk_exit),NULL);
	gtk_signal_connect(GTK_OBJECT(mini_win),"destroy",
			GTK_SIGNAL_FUNC(gtk_exit),NULL);

	/* Main boxes */
	hbox = gtk_hbox_new(FALSE,1);
	vbox = gtk_vbox_new(FALSE,0);
	vbox1 = gtk_vbox_new(FALSE,0);
	vbox2 = gtk_vbox_new(FALSE,0);
	mini_hbox = gtk_hbox_new(FALSE,0);
	mini_hbox_float = gtk_hbox_new(FALSE,0);

	gtk_container_set_border_width(GTK_CONTAINER(hbox),MAIN_WIN_BORDER);

	/* Make banners */
	top_banner=xpm_box(main_win,PREFIX "/share/cpanel/pixmaps/banner.xpm");
	gtk_box_pack_start(GTK_BOX(vbox),top_banner,TRUE,TRUE,0);
	mini_banner=xpm_box(mini_win,PREFIX "/share/cpanel/pixmaps/mini_banner.xpm");
	mini_banner_float=xpm_box(mini_win_float,PREFIX "/share/cpanel/pixmaps/mini_banner.xpm");
	gtk_box_pack_start(GTK_BOX(mini_hbox),mini_banner,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(mini_hbox_float),mini_banner_float,FALSE,FALSE,0);

	/* menu */
	menu = cpanel_create_menu_bar();
	gtk_box_pack_start(GTK_BOX(vbox),menu,FALSE,FALSE,0);

	/**********************************************
	 * Main Contents
	 * use pack_button & then signal_connect
	 * ********************************************/
	/* --Chinese Terminals-- */
if(is_crxvt)
{
	frame = gtk_frame_new(_("Chinese Terminals"));
	gtk_container_set_border_width(GTK_CONTAINER(frame),2);

if(if_gb)
{
	/* crxvt-gb */
	button_box = gtk_hbox_new(FALSE,0);

	/* pack_button(label,box) */
	button = pack_icon_label_button(PREFIX "/share/cpanel/pixmaps/crxvt_icon.xpm", _("  crxvt-gb"),button_box, main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(crxvt_gb),NULL);
	button4mini = pack_icon_button(PREFIX "/share/cpanel/pixmaps/crxvt_icon.xpm",mini_hbox, mini_win);
	gtk_signal_connect(GTK_OBJECT(button4mini),"clicked",
			GTK_SIGNAL_FUNC(crxvt_gb),NULL);
	button4mini = pack_icon_button(PREFIX "/share/cpanel/pixmaps/crxvt_icon.xpm",mini_hbox_float, mini_win_float);
	gtk_signal_connect(GTK_OBJECT(button4mini),"clicked",
			GTK_SIGNAL_FUNC(crxvt_gb),NULL);

	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/help_icon.xpm",button_box, main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(crxvt_gb_help),NULL);

	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/opt_icon.xpm",button_box, main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(crxvt_gb_opt),NULL);
}
else
{
	/* crxvt */
	button_box = gtk_hbox_new(FALSE,0);

	/* pack_button(label,box) */
	button = pack_icon_label_button(PREFIX "/share/cpanel/pixmaps/crxvt_icon.xpm", _("  crxvt"),button_box, main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(crxvt),NULL);
	button4mini = pack_icon_button(PREFIX "/share/cpanel/pixmaps/crxvt_icon.xpm",mini_hbox, mini_win);
	gtk_signal_connect(GTK_OBJECT(button4mini),"clicked",
			GTK_SIGNAL_FUNC(crxvt),NULL);
	button4mini = pack_icon_button(PREFIX "/share/cpanel/pixmaps/crxvt_icon.xpm",mini_hbox_float, mini_win_float);
	gtk_signal_connect(GTK_OBJECT(button4mini),"clicked",
			GTK_SIGNAL_FUNC(crxvt),NULL);

	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/help_icon.xpm",button_box, main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(crxvt_help),NULL);

	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/opt_icon.xpm",button_box, main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(crxvt_opt),NULL);
}

	gtk_container_add(GTK_CONTAINER(frame),button_box);
	gtk_box_pack_start(GTK_BOX(vbox1),frame,FALSE,FALSE,0);
}

	/* --XA+CV-- */
if(is_xacv)
{
	frame = gtk_frame_new(_("XA+CV"));
	gtk_container_set_border_width(GTK_CONTAINER(frame),2);
	/* xacv */
	button_box = gtk_hbox_new(FALSE,0);
	button = pack_icon_label_button(PREFIX "/share/cpanel/pixmaps/xacv_icon.xpm",_(" xa+cv"),button_box,main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(xacv),NULL);
	button4mini = pack_icon_button(PREFIX "/share/cpanel/pixmaps/xacv_icon.xpm",mini_hbox,mini_win);
	gtk_signal_connect(GTK_OBJECT(button4mini),"clicked",
			GTK_SIGNAL_FUNC(xacv),NULL);
	button4mini = pack_icon_button(PREFIX "/share/cpanel/pixmaps/xacv_icon.xpm",mini_hbox_float,mini_win_float);
	gtk_signal_connect(GTK_OBJECT(button4mini),"clicked",
			GTK_SIGNAL_FUNC(xacv),NULL);
	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/help_icon.xpm",button_box, main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(xacv_help),NULL);
	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/opt_icon.xpm",button_box, main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(xacv_opt),NULL);

	gtk_container_add(GTK_CONTAINER(frame),button_box);
	gtk_box_pack_start(GTK_BOX(vbox1),frame,FALSE,FALSE,0);
}

	/* --GTK+ Set Fonts-- */
	frame = gtk_frame_new(_("GTK+ set fonts"));
	gtk_container_set_border_width(GTK_CONTAINER(frame),2);
	/* gtk_fonts */
	button_box = gtk_hbox_new(FALSE,0);
	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/help_icon.xpm",button_box, main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(gtk_fonts_help),NULL);
	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/opt_icon.xpm",button_box, main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(gtk_fonts_opt),NULL);

	gtk_container_add(GTK_CONTAINER(frame),button_box);
	gtk_box_pack_start(GTK_BOX(vbox1),frame,FALSE,FALSE,0);

	/* --Chinese Input-- */
if(is_xcin || is_xcin23 || is_xcingb)
{
	frame = gtk_frame_new(_("Chinese Input"));
	gtk_container_set_border_width(GTK_CONTAINER(frame),2);
	vbox_in_frame = gtk_vbox_new(FALSE,0);
	/* xcin */
if(is_xcin)
{
	button_box = gtk_hbox_new(FALSE,0);

	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/help_icon.xpm",button_box, main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(xcin_help),NULL);

	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/opt_icon.xpm",button_box, main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(xcin_opt),NULL);
	
	gtk_box_pack_start(GTK_BOX(vbox_in_frame),button_box,FALSE,FALSE,2);
}

	/* xcin2.3 */
if(is_xcin23 && !if_gb)
{
	button_box = gtk_hbox_new(FALSE,0);
	button = pack_icon_label_button(PREFIX "/share/cpanel/pixmaps/xcin23_icon.xpm",_(" xcin2.3"),button_box,main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(xcin23),NULL);
	button4mini = pack_icon_button(PREFIX "/share/cpanel/pixmaps/xcin23_icon.xpm",mini_hbox,mini_win);
	gtk_signal_connect(GTK_OBJECT(button4mini),"clicked",
			GTK_SIGNAL_FUNC(xcin23),NULL);
	button4mini = pack_icon_button(PREFIX "/share/cpanel/pixmaps/xcin23_icon.xpm",mini_hbox_float,mini_win_float);
	gtk_signal_connect(GTK_OBJECT(button4mini),"clicked",
			GTK_SIGNAL_FUNC(xcin23),NULL);

	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/help_icon.xpm",button_box, main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(xcin23_help),NULL);

	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/opt_icon.xpm",button_box, main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(xcin23_opt),NULL);
	
	gtk_box_pack_start(GTK_BOX(vbox_in_frame),button_box,FALSE,FALSE,2);
}

	/* xcingb */
if(is_xcingb && if_gb)
{
	button_box = gtk_hbox_new(FALSE,0);
	button = pack_icon_label_button(PREFIX "/share/cpanel/pixmaps/xcin23_icon.xpm",_(" xcingb"),button_box,main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(xcingb),NULL);

	button4mini = pack_icon_button(PREFIX "/share/cpanel/pixmaps/xcin23_icon.xpm",mini_hbox,mini_win);
	gtk_signal_connect(GTK_OBJECT(button4mini),"clicked",
			GTK_SIGNAL_FUNC(xcingb),NULL);
	button4mini = pack_icon_button(PREFIX "/share/cpanel/pixmaps/xcin23_icon.xpm",mini_hbox_float,mini_win_float);
	gtk_signal_connect(GTK_OBJECT(button4mini),"clicked",
			GTK_SIGNAL_FUNC(xcingb),NULL);

	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/help_icon.xpm",button_box,main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(xcingb_help),NULL);

	gtk_box_pack_start(GTK_BOX(vbox_in_frame),button_box,FALSE,FALSE,2);

}

	gtk_container_add(GTK_CONTAINER(frame),vbox_in_frame);
	gtk_box_pack_start(GTK_BOX(vbox2),frame,FALSE,FALSE,0);
}

	/* --Chinese Dictionary-- */
if(is_pydict && !if_gb)
{
	frame = gtk_frame_new(_("Chinese Dictionary"));
	gtk_container_set_border_width(GTK_CONTAINER(frame),2);
	/* pydict */
	button_box = gtk_hbox_new(FALSE,0);
	button = pack_icon_label_button(PREFIX "/share/cpanel/pixmaps/pydict_icon.xpm",_(" PyDict"),button_box,main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(pydict),NULL);

	/* mini button */
	button4mini = pack_icon_button(PREFIX "/share/cpanel/pixmaps/pydict_icon.xpm",mini_hbox,mini_win);
	gtk_signal_connect(GTK_OBJECT(button4mini),"clicked",
			GTK_SIGNAL_FUNC(pydict),NULL);
	button4mini = pack_icon_button(PREFIX "/share/cpanel/pixmaps/pydict_icon.xpm",mini_hbox_float,mini_win_float);
	gtk_signal_connect(GTK_OBJECT(button4mini),"clicked",
			GTK_SIGNAL_FUNC(pydict),NULL);

	/* help button */
	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/help_icon.xpm",button_box,main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(pydict_help),NULL);

	gtk_container_add(GTK_CONTAINER(frame),button_box);
	gtk_box_pack_start(GTK_BOX(vbox2),frame,FALSE,FALSE,0);
}

	/* --Set Locale-- */
	frame = gtk_frame_new(_("Set Locale"));
	gtk_container_set_border_width(GTK_CONTAINER(frame),2);
	
	/* set locale */
	button_box = gtk_hbox_new(FALSE,0);
	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/help_icon.xpm",button_box,main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(set_locale_help),NULL);
	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/opt_icon.xpm",button_box,main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(set_locale_opt),NULL);

	gtk_container_add(GTK_CONTAINER(frame),button_box);
	gtk_box_pack_start(GTK_BOX(vbox2),frame,FALSE,FALSE,0);

	/* packing 2 columns together */
	gtk_box_pack_start(GTK_BOX(hbox),vbox1,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(hbox),vbox2,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

	/* Setting up the buttons */
	hbox = gtk_hbox_new(FALSE,0);
	button = pack_icon_button(PREFIX "/share/cpanel/pixmaps/exit_icon.xpm", hbox, main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(save_opt),NULL);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(gtk_exit),NULL);
	button = pack_icon_button(PREFIX "/share/cpanel/pixmaps/about_icon.xpm", hbox, main_win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(display_about_page),NULL);

if(if_root)
{
	button = gtk_button_new_with_label(_("Install New Programs"));
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(install_list),NULL);
	gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
}
if(if_root)
{
	button = gtk_button_new_with_label(_("Setup TrueType fonts"));
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(xtt_config),NULL);
	gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
}

	mini_button = pack_button_end(_("Tools bar <--"), hbox);
	gtk_signal_connect(GTK_OBJECT(mini_button),"clicked",
			GTK_SIGNAL_FUNC(show_mini),mini_win);
	gtk_signal_connect(GTK_OBJECT(mini_button),"clicked",
			GTK_SIGNAL_FUNC(show_float),mini_win_float);
	gtk_signal_connect(GTK_OBJECT(mini_button),"clicked",
			GTK_SIGNAL_FUNC(hide_win),main_win);

	main_button = gtk_button_new_with_label(_("-->"));
	gtk_signal_connect(GTK_OBJECT(main_button),"clicked",
			GTK_SIGNAL_FUNC(hide_win),mini_win);

	main_button_float = gtk_button_new_with_label(_("-->"));
	gtk_signal_connect(GTK_OBJECT(main_button_float),"clicked",
			GTK_SIGNAL_FUNC(hide_win),mini_win_float);

	gtk_signal_connect(GTK_OBJECT(main_button),"clicked",
			GTK_SIGNAL_FUNC(show_win),main_win);
	gtk_signal_connect(GTK_OBJECT(main_button_float),"clicked",
			GTK_SIGNAL_FUNC(show_win),main_win);

	gtk_box_pack_end(GTK_BOX(mini_hbox),main_button,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(mini_hbox_float),main_button_float,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(vbox),hbox,FALSE,FALSE,3);
	gtk_container_add(GTK_CONTAINER(mini_win),mini_hbox);
	gtk_container_add(GTK_CONTAINER(mini_win_float),mini_hbox_float);
	gtk_container_add(GTK_CONTAINER(main_win),vbox);

	if(start_by_main_win)
		gtk_widget_show_all(main_win);
	else 
	{
		if(if_float)
		{
			gtk_widget_popup(GTK_WIDGET(mini_win_float),
					coord_x,coord_y);
			gtk_widget_show_all(mini_win_float);
		}
		else
			gtk_widget_show_all(mini_win);
	}

}

GtkWidget *pack_button(gchar *label, GtkWidget *box)
{
	GtkWidget *button;

	button = gtk_button_new_with_label(label);
	gtk_box_pack_start(GTK_BOX(box),button,FALSE,FALSE,0);
	return button;
}

GtkWidget *pack_button_end(gchar *label, GtkWidget *box)
{
	GtkWidget *button;

	button = gtk_button_new_with_label(label);
	gtk_box_pack_end(GTK_BOX(box),button,FALSE,FALSE,0);
	return button;
}

GtkWidget *pack_icon_button(gchar *path, GtkWidget *box, GtkWidget *win)
{
	GtkWidget *button;
	GtkWidget *icon;

	button = gtk_button_new();
	icon=xpm_box(win, path);
	gtk_container_add(GTK_CONTAINER(button),icon);
	gtk_box_pack_start(GTK_BOX(box),button,FALSE,FALSE,0);
	return button;
}

GtkWidget *pack_icon_button_end(gchar *path, GtkWidget *box, GtkWidget *win)
{
	GtkWidget *button;
	GtkWidget *icon;

	button = gtk_button_new();
	icon=xpm_box(win, path);
	gtk_container_add(GTK_CONTAINER(button),icon);
	gtk_box_pack_end(GTK_BOX(box),button,FALSE,FALSE,0);
	return button;
}

GtkWidget *pack_icon_label_button(gchar *path, gchar *text, GtkWidget *box, GtkWidget *win)
{
	GtkWidget *button;
	GtkWidget *label;
	GtkWidget *icon;
	GtkWidget *hbox;

	button = gtk_button_new();
	label = gtk_label_new(text);
	icon = xpm_box(win, path);
	hbox = gtk_hbox_new(FALSE,0);

	gtk_box_pack_start(GTK_BOX(hbox),icon,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(button),hbox);
	gtk_box_pack_start(GTK_BOX(box),button,FALSE,FALSE,0);
	return button;
}

void arg_handler(int argc, char *argv[])
{
	int c;

	if(argc>1)
	{
		for(c=1; c<argc; c++)
		{
		if(!strcmp(argv[c],"--help") || !strcmp(argv[c],"-h"))
		{
			printf("Debian Chinese Panel\n");
			printf("Version %d.%d.%d\n\n",VERSION_MAJOR,VERSION_MINOR,VERSION_MICRO);
			printf("Options\n");
			printf("\t--help    | -h\tprint this page\n");
			printf("\t--version | -v\tshow version number\n");
			printf("\t--bar     | -b\tStart Cpanel in tools bar form\n");
			printf("\t--big5    | -t\tSet language to Traditional Chinese\n");
			printf("\t--gb2312  | -s\tSet language to Simplified Chinese\n");
			printf("\n");
			exit(0);
		}
		else if(!strcmp(argv[c],"--version") || !strcmp(argv[c],"-v"))
		{
			printf("Version %d.%d.%d\n",VERSION_MAJOR,VERSION_MINOR,VERSION_MICRO);
			exit(0);
		}
		else if(!strcmp(argv[c],"--bar") || !strcmp(argv[c],"-b"))
			start_by_main_win = 0;
		else if(!strcmp(argv[c],"--big5") || !strcmp(argv[c],"-t"))
		{
			loadconfig();
			if_gb = 0;
			if_config_loaded=1;
		}
		else if(!strcmp(argv[c],"--gb2312") || !strcmp(argv[c],"-s"))
		{
			loadconfig();
			if_gb = 1;
			if_config_loaded=1;
		}
		else
		{
			printf("Invalid option \'%s\'\n",argv[c]);
			printf("Try \"cpanel --help\" instead.\n");
			exit(0);
		}
		}
	}
}
