/*****************************************************************
 *
 *   sys_chk.c
 *
 *     Copyright (c) 2000  Kam Tik <kamtik@hongkong.com>
 *
 *	http://debian.kamtik.net
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 ******************************************************************/

#include "cpanel.h"

#define STABLE " (potato)"
#define UNSTABLE " (woody)"

void check_user(void);
gchar *check_ver(gchar *program);
void check_programs(void);
gboolean check_if_potato(gchar *ver_program, gchar *potato_ver);

gboolean if_root = 0;
gboolean if_woody_locales;
gchar *username;
gint no_of_potato;
gint no_of_woody;

extern gboolean is_crxvt;
extern gboolean is_xcin;
extern gboolean is_xcin23;
extern gboolean is_xacv;
extern gboolean is_pydict;
extern gboolean is_chdrv;

gchar *ver_locales;
gchar *ver_crxvt;
gchar *ver_xcin;
gchar *ver_xcin23;
gchar *ver_xacv;
gchar *ver_pydict;
gchar *ver_chdrv;

void sys_info_page(GtkWidget *widget, gpointer data)
{
	GtkWidget *win;
	GtkWidget *button;
	GtkWidget *label;
	GtkWidget *column1;
	GtkWidget *column2;
	GtkWidget *hbox;
	gchar *str;
	gchar *str2;
	float unstable_level;
	gint c;

	/* init */
	no_of_potato =0;
	no_of_woody = 0;

	win = gtk_dialog_new();
	gtk_container_set_border_width(GTK_CONTAINER(win),5);
	gtk_window_set_title(GTK_WINDOW(win),_("System Check"));

	/* Check user */
	str = g_strconcat(_("User: "),username,NULL);
	label = gtk_label_new(str);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),label,FALSE,FALSE,2);

	/* Check locales */
	str = g_strconcat("locales: ",ver_locales,check_if_potato(ver_locales,"2.1.3-13")?STABLE:UNSTABLE,NULL);
	label = gtk_label_new(str);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),label,FALSE,FALSE,2);

	/* Check programs */
	check_programs();
	hbox = gtk_hbox_new(FALSE,2);
	column1 = gtk_vbox_new(FALSE,1);
	column2 = gtk_vbox_new(FALSE,1);

	if(is_crxvt) {
	str = g_strconcat("crxvt: ",ver_crxvt,check_if_potato(ver_crxvt,"2.6.2-2")?STABLE:UNSTABLE,NULL);
	label = gtk_label_new(str);
	gtk_box_pack_start(GTK_BOX(column1),label,FALSE,FALSE,1);
	}

	if(is_xcin) {
	str = g_strconcat("xcin: ",ver_xcin,check_if_potato(ver_xcin,"2.5.2-1")?STABLE:UNSTABLE,NULL);
	label = gtk_label_new(str);
	gtk_box_pack_start(GTK_BOX(column2),label,FALSE,FALSE,1);
	}

	if(is_xacv) {
	str = g_strconcat("xa+cv: ",ver_xacv,check_if_potato(ver_xacv,"0.6-1")?STABLE:UNSTABLE,NULL);
	label = gtk_label_new(str);
	gtk_box_pack_start(GTK_BOX(column1),label,FALSE,FALSE,1);
	}

	if(is_xcin23) {
	str = g_strconcat("xcin2.3: ",ver_xcin23,check_if_potato(ver_xcin23,"2.3.04.3-1")?STABLE:UNSTABLE,NULL);
	label = gtk_label_new(str);
	gtk_box_pack_start(GTK_BOX(column2),label,FALSE,FALSE,1);
	}

	if(is_pydict) {
	str = g_strconcat("pydict: ",ver_pydict,check_if_potato(ver_pydict,"None")?STABLE:UNSTABLE,NULL);
	label = gtk_label_new(str);
	gtk_box_pack_start(GTK_BOX(column1),label,FALSE,FALSE,1);
	}

	if(is_chdrv) {
	str = g_strconcat("chdrv : ",ver_chdrv,check_if_potato(ver_chdrv,"1.0.13-0.1")?STABLE:UNSTABLE,NULL);
	label = gtk_label_new(str);
	gtk_box_pack_start(GTK_BOX(column2),label,FALSE,FALSE,1);
	}

	gtk_box_pack_start(GTK_BOX(hbox),column1,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(hbox),column2,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),hbox,FALSE,FALSE,2);

	str = malloc(20*sizeof(gchar));
	str2 = malloc(20*sizeof(gchar));
	unstable_level = (no_of_woody*100)/(no_of_potato+no_of_woody);
	sprintf(str,"%f",unstable_level);
	c = 0;
	while(*(str+c) != '.') c++;
	*(str+c) = '\0';
	strcpy(str2,str);
	str = g_strconcat(_("Woody Level: "),str2,_("% (just for fun!)"),NULL);
	label = gtk_label_new(str);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),label,FALSE,FALSE,5);

	button = gtk_button_new_with_label(_("Close"));
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),win);
	
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,0);

	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_widget_grab_default(button);
	gtk_grab_add(win);
	gtk_widget_show_all(win);
}

void sys_check(void)
{
	/* check user name */
	username = malloc(256*sizeof(gchar));
	system("whoami > /tmp/who.cpanel");
	check_user();
	system("rm /tmp/who.cpanel");

	/* check locales version */
	ver_locales = check_ver("locales");
	if(*(ver_locales+2)=='1')
		if_woody_locales = 0;
	else
		if_woody_locales = 1;

}

void check_user(void)
{
	FILE *f;
	gchar str[256];
	gint c;
	
	f = fopen("/tmp/who.cpanel","r");
	if(!f)
		g_warning("Error occur when checking /tmp/who.cpanel, please fix me");
	else
	{
		fgets(str,256,f);
		for (c = 0; str[c]!='\n';c++) ;
		str[c] = '\0';
		strcpy(username,str);
	}
	if(!strcasecmp(username,"root")) if_root = 1;
}

void check_programs(void)
{
	if(is_crxvt)
	ver_crxvt = check_ver("rxvt-ml");
	if(is_xcin)
	ver_xcin = check_ver("xcin");
	if(is_xcin23)
	ver_xcin23 = check_ver("xcin2.3");
	if(is_xacv)
	ver_xacv = check_ver("xa+cv");
	if(is_pydict)
	ver_pydict = check_ver("pydict");
	if(is_chdrv)
	ver_chdrv = check_ver("chdrv");
}

gboolean check_if_potato(gchar *ver_program, gchar *potato_ver)
{
	if(!strcasecmp(ver_program,potato_ver))
	{
		no_of_potato +=1;
		return 1;
	}
	else
	{
		no_of_woody +=1;
		return 0;
	}
}

gchar *check_ver(gchar *program)
{
	gchar *command;
	FILE *f;
	gchar str[256];
	gint c;
	gchar *pointer = "None";
	gchar *str_pointer;

	command = g_strconcat("dpkg -l ",program," > /tmp/ver.cpanel",NULL);
	system(command);
	f = fopen("/tmp/ver.cpanel","r");
	if(!f)
		g_warning("Error occur when checking /tmp/ver.cpanel, please fix me");
	else
	{
		while(fgets(str,256,f))
		{
			/* check if program is installed */
			c = 0;
			if(str[c]!='i') continue;

			c = 1;
			if(str[c]!='i') continue;

			/* get version */
			c = 19;
			str_pointer = str+c;

			while(str[c]!=' ' && c <= 32) c++;
			str[c] = '\0';

			pointer = malloc(15*sizeof(gchar));
			strcpy(pointer,str_pointer);
		}
	}
	system("rm /tmp/ver.cpanel");
	return pointer;
}
