/*****************************************************************
 *
 *   rcfile.c
 *
 *     Copyright (c) 2000  Kam Tik <kamtik@hongkong.com>
 *
 *	http://debian.kamtik.net
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 ******************************************************************/

/*******************************
 * Debian Chinese Panel
 * rcfile
 *
 * Copyright (C) 2000 Kam Tik
 * Released under GPL
 * *****************************/
#include "cpanel.h"
#include "defaults.h"

void set_def(void);

/* Variables for External Use */
gchar crxvt_command[STR_BUFFER_SIZE];
gchar crxvt_command_gb[STR_BUFFER_SIZE];
gchar crxvt_bg[STR_BUFFER_SIZE];
gchar crxvt_fg[STR_BUFFER_SIZE];
gchar crxvt_fonts[STR_BUFFER_SIZE];
gchar crxvt_fonts_gb[STR_BUFFER_SIZE];
gchar crxvt_im[STR_BUFFER_SIZE];
gchar xcin_command[STR_BUFFER_SIZE];
gchar xcin_im[STR_BUFFER_SIZE];
gchar xcin23_command[STR_BUFFER_SIZE];
gchar xcin23_in[STR_BUFFER_SIZE];
gchar gtk_font[STR_BUFFER_SIZE];
gchar gtk_font_gb[STR_BUFFER_SIZE];
gchar locale[STR_BUFFER_SIZE];
gchar wm_command[STR_BUFFER_SIZE];
gboolean if_gb;
gboolean if_cv_wm;
gboolean if_xa;
gboolean if_cv;
gboolean if_welcome=0;

gboolean if_float;
gint coord_x;
gint coord_y;

/****************************************
 * Load configuration parameters
 * **************************************/
void loadconfig(void)
{
	FILE *f;
	gchar *rc_path;
	gchar str[1024];
	gchar option[1024];
	gchar value[1024];
	gchar *option_ptr;
	gchar *value_ptr;
	gint c,len; /* count & string length */

	rc_path = g_strconcat(getenv("HOME"),"/",RC_FILE_NAME,NULL);

	f = fopen(rc_path,"r");
	if(!f)
	{
		g_free(rc_path);
		set_def();
		saveconfig();
		/* 2nd parameter: 0 for big5, 1 for gb */
		save_gtk_fonts(GTK_FONT,0);
		save_gtk_fonts(GTK_FONT_GB,1);
		if_welcome = 1;
		return;
	}

	while(fgets(str,1024,f))
	{
		len = strlen(str);
		c = 0;

		/* skip space before string */
		while(str[c]==' ' && c < len) c++;
		/* skip lines */
		if(str[c]=='#') continue;
		if(str[c]=='\n') continue;
		if(str[c]==':') continue;

		/* point to start of first character of the option */
		option_ptr = str + c;

		/* end option */
		while(str[c]!=' ' && str[c]!='\n' && c < len) c++;
		str[c] = '\0';

		/* gets its value */
		if(c >= len) value[0]='\0';
		else
		{
			c++;
			while(str[c]==' ' && c < len) c++;
			value_ptr = str + c;
			while(str[c]!='\n' && c<len) c++;
			str[c] = '\0';
		}

		strcpy(option,option_ptr);
		strcpy(value,value_ptr);

		/**********************************
		 * OK, got option & value
		 * Please add options here!
		 * ********************************/

		/* crxvt options */
		if(!strcasecmp(option,"crxvt_command"))
			strcpy(crxvt_command,value);
		if(!strcasecmp(option,"crxvt_command_gb"))
			strcpy(crxvt_command_gb,value);
		if(!strcasecmp(option,"crxvt_bg")) strcpy(crxvt_bg,value);
		if(!strcasecmp(option,"crxvt_fg")) strcpy(crxvt_fg,value);
		if(!strcasecmp(option,"crxvt_fonts")) strcpy(crxvt_fonts,value);
		if(!strcasecmp(option,"crxvt_fonts_gb")) 
			strcpy(crxvt_fonts_gb,value);
		if(!strcasecmp(option,"crxvt_im")) strcpy(crxvt_im,value);
		/* xcin options */
		if(!strcasecmp(option,"xcin_command"))
			strcpy(xcin_command,value);
		if(!strcasecmp(option,"xcin_im")) strcpy(xcin_im,value);
		/* xcin2.3 options */
		if(!strcasecmp(option,"xcin23_command"))
			strcpy(xcin23_command,value);
		if(!strcasecmp(option,"xcin23_in"))
			strcpy(xcin23_in,value);
		/* gtk_fonts options */
		if(!strcasecmp(option,"gtk_font"))
			strcpy(gtk_font,value);
		if(!strcasecmp(option,"gtk_font_gb"))
			strcpy(gtk_font_gb,value);
		/* set_locale options */
		if(!strcasecmp(option, "locale"))
			strcpy(locale,value);
		if(!strcasecmp(option, "wm_command"))
			strcpy(wm_command,value);
		if(!strcasecmp(option, "if_cv_wm"))
			if_cv_wm = atof(value);
		if(!strcasecmp(option, "if_xa"))
			if_xa = atof(value);
		if(!strcasecmp(option, "if_cv"))
			if_cv = atof(value);
		if(!strcasecmp(option, "if_float"))
			if_float = atof(value);
		if(!strcasecmp(option, "coord_x"))
			coord_x = atof(value);
		if(!strcasecmp(option, "coord_y"))
			coord_y = atof(value);
		if(!strcasecmp(option, "if_gb"))
			if_gb = atof(value);
	}
	g_free(rc_path);
}

void saveconfig(void)
{
	FILE *f;
	gchar *rc_path;

	rc_path = g_strconcat(getenv("HOME"),"/",RC_FILE_NAME,NULL);

	f = fopen(rc_path,"w");
	if(!f)
	{
		printf("Error saving config file: %s\n",rc_path);
		printf("Does $HOME point to your home dir??\n");
		g_free(rc_path);
		return;
	}

	fprintf(f,"#######################################################\n");
	fprintf(f,"#                 Debian Chinese Panel                #\n");
	fprintf(f,"#                    Version %d.%d.%d                    #\n"
			,VERSION_MAJOR,VERSION_MINOR,VERSION_MICRO);
	fprintf(f,"#                                                     #\n");
	fprintf(f,"#  Nothing here need to be changed by hand            #\n");
	fprintf(f,"#  If you know what you're doing, just do it :)       #\n");
	fprintf(f,"#######################################################\n");
	fprintf(f,"\n");
	
	fprintf(f,"#### GB support ####\n");
	fprintf(f,"if_gb %d\n",if_gb);
	fprintf(f,"\n");
	
	fprintf(f,"#### crxvt ####\n");
	fprintf(f,"crxvt_command %s\n",crxvt_command);
	fprintf(f,"crxvt_command_gb %s\n",crxvt_command_gb);
	fprintf(f,"crxvt_bg %s\n",crxvt_bg);
	fprintf(f,"crxvt_fg %s\n",crxvt_fg);
	fprintf(f,"crxvt_fonts %s\n",crxvt_fonts);
	fprintf(f,"crxvt_fonts_gb %s\n",crxvt_fonts_gb);
	fprintf(f,"crxvt_im %s\n",crxvt_im);
	fprintf(f,"\n");

	fprintf(f,"#### xcin ####\n");
	fprintf(f,"xcin_command %s\n",xcin_command);
	fprintf(f,"xcin_im %s\n",xcin_im);
	fprintf(f,"\n");

	fprintf(f,"#### xcin2.3 ####\n");
	fprintf(f,"xcin23_command %s\n",xcin23_command);
	fprintf(f,"xcin23_in %s\n",xcin23_in);
	fprintf(f,"\n");

	fprintf(f,"#### gtk_fonts ####\n");
	fprintf(f,"gtk_font %s\n",gtk_font);
	fprintf(f,"gtk_font_gb %s\n",gtk_font_gb);
	fprintf(f,"\n");

	fprintf(f,"#### set_locale ####\n");
	fprintf(f,"locale %s\n",locale);
	fprintf(f,"wm_command %s\n",wm_command);
	fprintf(f,"if_cv_wm %d\n",if_cv_wm);
	fprintf(f,"\n");

	fprintf(f,"#### xacv ####\n");
	fprintf(f,"if_xa %d\n",if_xa);
	fprintf(f,"if_cv %d\n",if_cv);
	fprintf(f,"\n");

	fprintf(f,"#### Option settings ####\n");
	fprintf(f,"if_float %d\n",if_float);
	fprintf(f,"coord_x %d\n",coord_x);
	fprintf(f,"coord_y %d\n",coord_y);
	

	fprintf(f,"#######################################################\n");
	fprintf(f,"#                         EOF                         #\n");
	fprintf(f,"#######################################################");

	fclose(f);

	g_free(rc_path);
}

void set_def(void)
{
	/* Edit here when new options made! */
	strcpy(crxvt_command,CRXVT_COMMAND);
	strcpy(crxvt_command_gb,CRXVT_COMMAND_GB);
	strcpy(crxvt_bg,CRXVT_BG);
	strcpy(crxvt_fg,CRXVT_FG);
	strcpy(crxvt_fonts,CRXVT_FONTS);
	strcpy(crxvt_fonts_gb,CRXVT_FONTS_GB);
	strcpy(crxvt_im,CRXVT_IM);
	strcpy(xcin_command,XCIN_COMMAND);
	strcpy(xcin_im,XCIN_IM);
	strcpy(xcin23_command,XCIN23_COMMAND);
	strcpy(xcin23_in,XCIN23_IN);
	strcpy(gtk_font,GTK_FONT);
	strcpy(gtk_font_gb,GTK_FONT_GB);
	strcpy(locale,LOCALE);
	if_cv_wm = IF_CV_WM;
	if_xa = IF_XA;
	if_cv = IF_CV;
	if_float = IF_FLOAT;
	coord_x = COORD_X;
	coord_y = COORD_Y;
}
