#include "cpanel.h"

extern gboolean if_gb;
extern gboolean is_xcin23;
extern gboolean is_xacv;
extern gboolean is_pydict;
extern gboolean if_xcingb;

void install_list(GtkWidget *pre_button, gpointer data)
{
	GtkWidget *win;
	GtkWidget *button;
	GtkWidget *frame;
	GtkWidget *button_box;
	GtkWidget *vbox;

	win = gtk_dialog_new();
	gtk_container_set_border_width(GTK_CONTAINER(win),10);
	gtk_window_set_title(GTK_WINDOW(win),_("Install new program"));

	/* XA + CV */
if(!is_xacv)
{
	frame = gtk_frame_new(_("XA+CV"));
	button_box = gtk_hbox_new(FALSE,0);

	button = pack_icon_label_button(PREFIX "/share/cpanel/pixmaps/xacv_icon.xpm",_(" Install xa+cv"),button_box,win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(apt_process),"xa+cv");

	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/help_icon.xpm",button_box, win);
        gtk_signal_connect(GTK_OBJECT(button),"clicked",
                        GTK_SIGNAL_FUNC(xacv_help),NULL);

	gtk_container_add(GTK_CONTAINER(frame),button_box);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),frame,FALSE,FALSE,4);
}

	/* XCIN 2.3 */
if(!is_xcin23 && !if_gb)
{
	frame = gtk_frame_new(_("Chinese Input"));
	button_box = gtk_hbox_new(FALSE,0);

	button = pack_icon_label_button(PREFIX "/share/cpanel/pixmaps/xcin23_icon.xpm",_(" Install xcin2.3"),button_box,win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(apt_process),"xcin2.3");

	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/help_icon.xpm",button_box,win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(xcin23_help),NULL);

	gtk_container_add(GTK_CONTAINER(frame),button_box);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),frame,FALSE,FALSE,4);
}

	/* Chinese Dictionary */
if(!is_pydict && !if_gb)
{
	frame = gtk_frame_new(_("Chinese Dictionary"));
	button_box = gtk_hbox_new(FALSE,0);

	button = pack_icon_label_button(PREFIX "/share/cpanel/pixmaps/pydict_icon.xpm",_(" Install PyDict"),button_box,win);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
                        GTK_SIGNAL_FUNC(apt_process),"pydict");
	button = pack_icon_button_end(PREFIX "/share/cpanel/pixmaps/help_icon.xpm",button_box,win);
        gtk_signal_connect(GTK_OBJECT(button),"clicked",
                        GTK_SIGNAL_FUNC(pydict_help),NULL);

        gtk_container_add(GTK_CONTAINER(frame),button_box);
        gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),frame,FALSE,FALSE,4);
}


	/* CLOSE Window */
	button = gtk_button_new_with_label(_("Close"));
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),win);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,0);
	gtk_widget_grab_default(button);
	gtk_widget_show_all(win);
}
