/*
    comedi/drivers/plx9052.h
    Definitions for the PLX-9052 PCI interface chip

    Copyright (C) 2002 MEV Ltd. <http://www.mev.co.uk/>

    COMEDI - Linux Control and Measurement Device Interface
    Copyright (C) 2000 David A. Schleef <ds@schleef.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _PLX9052_H_
#define _PLX9052_H_

/*
 * PLX PCI9052 INTCSR register (used for PCI236 card).
 */
#define PLX9052_INTCSR	0x4C	/* Offset in Local Configuration Registers */
/* Local Interrupt 1 Enable */
#define PLX9052_INTCSR_LI1ENAB_MASK		0x0001	/* (post-shift) */
#define PLX9052_INTCSR_LI1ENAB_SHIFT		0
#define PLX9052_INTCSR_LI1ENAB_VAL_DISABLED	0	/* (pre-shift) */
#define PLX9052_INTCSR_LI1ENAB_VAL_ENABLED	1	/* (pre-shift) */
#define PLX9052_INTCSR_LI1ENAB_SHIFTED_DISABLED	\
	(PLX9052_INTCSR_LI1ENAB_VAL_DISABLED << PLX9052_INTCSR_LI1ENAB_SHIFT)
#define PLX9052_INTCSR_LI1ENAB_SHIFTED_ENABLED	\
	(PLX9052_INTCSR_LI1ENAB_VAL_ENABLED << PLX9052_INTCSR_LI1ENAB_SHIFT)
/* Local Interrupt 1 Polarity */
#define PLX9052_INTCSR_LI1POL_MASK		0x0002	/* (post-shift) */
#define PLX9052_INTCSR_LI1POL_SHIFT		1
#define PLX9052_INTCSR_LI1POL_VAL_LOW		0	/* (pre-shift) */
#define PLX9052_INTCSR_LI1POL_VAL_HIGH		1	/* (pre-shift) */
#define PLX9052_INTCSR_LI1POL_SHIFTED_LOW	\
	(PLX9052_INTCSR_LI1POL_VAL_LOW << PLX9052_INTCSR_LI1POL_SHIFT)
#define PLX9052_INTCSR_LI1POL_SHIFTED_HIGH	\
	(PLX9052_INTCSR_LI1POL_VAL_HIGH << PLX9052_INTCSR_LI1POL_SHIFT)
/* Local Interrupt 1 Status (read-only) */
#define PLX9052_INTCSR_LI1STAT_MASK		0x0004	/* (post-shift) */
#define PLX9052_INTCSR_LI1STAT_SHIFT		2
#define PLX9052_INTCSR_LI1STAT_VAL_INACTIVE	0	/* (pre-shift) */
#define PLX9052_INTCSR_LI1STAT_VAL_ACTIVE	1	/* (pre-shift) */
#define PLX9052_INTCSR_LI1STAT_SHIFTED_INACTIVE	\
	(PLX9052_INTCSR_LI1STAT_VAL_INACTIVE << PLX9052_INTCSR_LI1STAT_SHIFT)
#define PLX9052_INTCSR_LI1STAT_SHIFTED_ACTIVE	\
	(PLX9052_INTCSR_LI1STAT_VAL_ACTIVE << PLX9052_INTCSR_LI1STAT_SHIFT)
/* Local Interrupt 2 Enable */
#define PLX9052_INTCSR_LI2ENAB_MASK		0x0008	/* (post-shift) */
#define PLX9052_INTCSR_LI2ENAB_SHIFT		3
#define PLX9052_INTCSR_LI2ENAB_VAL_DISABLED	0	/* (pre-shift) */
#define PLX9052_INTCSR_LI2ENAB_VAL_ENABLED	1	/* (pre-shift) */
#define PLX9052_INTCSR_LI2ENAB_SHIFTED_DISABLED	\
	(PLX9052_INTCSR_LI2ENAB_VAL_DISABLED << PLX9052_INTCSR_LI2ENAB_SHIFT)
#define PLX9052_INTCSR_LI2ENAB_SHIFTED_ENABLED	\
	(PLX9052_INTCSR_LI2ENAB_VAL_ENABLED << PLX9052_INTCSR_LI2ENAB_SHIFT)
/* Local Interrupt 2 Polarity */
#define PLX9052_INTCSR_LI2POL_MASK		0x0010	/* (post-shift) */
#define PLX9052_INTCSR_LI2POL_SHIFT		4
#define PLX9052_INTCSR_LI2POL_VAL_LOW		0	/* (pre-shift) */
#define PLX9052_INTCSR_LI2POL_VAL_HIGH		1	/* (pre-shift) */
#define PLX9052_INTCSR_LI2POL_SHIFTED_LOW	\
	(PLX9052_INTCSR_LI2POL_VAL_LOW << PLX9052_INTCSR_LI2POL_SHIFT)
#define PLX9052_INTCSR_LI2POL_SHIFTED_HIGH	\
	(PLX9052_INTCSR_LI2POL_VAL_HIGH << PLX9052_INTCSR_LI2POL_SHIFT)
/* Local Interrupt 2 Status (read-only) */
#define PLX9052_INTCSR_LI2STAT_MASK		0x0020	/* (post-shift) */
#define PLX9052_INTCSR_LI2STAT_SHIFT		5
#define PLX9052_INTCSR_LI2STAT_VAL_INACTIVE	0	/* (pre-shift) */
#define PLX9052_INTCSR_LI2STAT_VAL_ACTIVE	1	/* (pre-shift) */
#define PLX9052_INTCSR_LI2STAT_SHIFTED_INACTIVE	\
	(PLX9052_INTCSR_LI2STAT_VAL_INACTIVE << PLX9052_INTCSR_LI2STAT_SHIFT)
#define PLX9052_INTCSR_LI2STAT_SHIFTED_ACTIVE	\
	(PLX9052_INTCSR_LI2STAT_VAL_ACTIVE << PLX9052_INTCSR_LI2STAT_SHIFT)
/* PCI Interrupt Enable */
#define PLX9052_INTCSR_PCIENAB_MASK		0x0040	/* (post-shift) */
#define PLX9052_INTCSR_PCIENAB_SHIFT		6
#define PLX9052_INTCSR_PCIENAB_VAL_DISABLED	0	/* (pre-shift) */
#define PLX9052_INTCSR_PCIENAB_VAL_ENABLED	1	/* (pre-shift) */
#define PLX9052_INTCSR_PCIENAB_SHIFTED_DISABLED	\
	(PLX9052_INTCSR_PCIENAB_VAL_DISABLED << PLX9052_INTCSR_PCIENAB_SHIFT)
#define PLX9052_INTCSR_PCIENAB_SHIFTED_ENABLED	\
	(PLX9052_INTCSR_PCIENAB_VAL_ENABLED << PLX9052_INTCSR_PCIENAB_SHIFT)
/* Software Interrupt */
#define PLX9052_INTCSR_SOFTINT_MASK		0x0080	/* (post-shift) */
#define PLX9052_INTCSR_SOFTINT_SHIFT		7
#define PLX9052_INTCSR_SOFTINT_VAL_UNASSERTED	0	/* (pre-shift) */
#define PLX9052_INTCSR_SOFTINT_VAL_ASSERTED	1	/* (pre-shift) */
#define PLX9052_INTCSR_SOFTINT_SHIFTED_UNASSERTED \
	(PLX9052_INTCSR_SOFTINT_VAL_UNASSERTED << PLX9052_INTCSR_SOFTINT_SHIFT)
#define PLX9052_INTCSR_SOFTINT_SHIFTED_ASSERTED	\
	(PLX9052_INTCSR_SOFTINT_VAL_ASSERTED << PLX9052_INTCSR_SOFTINT_SHIFT)
/* Local Interrupt 1 Select Enable */
#define PLX9052_INTCSR_LI1SEL_MASK		0x0100	/* (post-shift) */
#define PLX9052_INTCSR_LI1SEL_SHIFT		8
#define PLX9052_INTCSR_LI1SEL_VAL_LEVEL		0	/* (pre-shift) */
#define PLX9052_INTCSR_LI1SEL_VAL_EDGE		1	/* (pre-shift) */
#define PLX9052_INTCSR_LI1SEL_SHIFTED_LEVEL	\
	(PLX9052_INTCSR_LI1SEL_VAL_LEVEL << PLX9052_INTCSR_LI1SEL_SHIFT)
#define PLX9052_INTCSR_LI1SEL_SHIFTED_EDGE	\
	(PLX9052_INTCSR_LI1SEL_VAL_EDGE << PLX9052_INTCSR_LI1SEL_SHIFT)
/* Local Interrupt 2 Select Enable */
#define PLX9052_INTCSR_LI2SEL_MASK		0x0200	/* (post-shift) */
#define PLX9052_INTCSR_LI2SEL_SHIFT		9
#define PLX9052_INTCSR_LI2SEL_VAL_LEVEL		0	/* (pre-shift) */
#define PLX9052_INTCSR_LI2SEL_VAL_EDGE		1	/* (pre-shift) */
#define PLX9052_INTCSR_LI2SEL_SHIFTED_LEVEL	\
	(PLX9052_INTCSR_LI2SEL_VAL_LEVEL << PLX9052_INTCSR_LI2SEL_SHIFT)
#define PLX9052_INTCSR_LI2SEL_SHIFTED_EDGE	\
	(PLX9052_INTCSR_LI2SEL_VAL_EDGE << PLX9052_INTCSR_LI2SEL_SHIFT)
/* Local Edge Triggerable Interrupt 1 Clear Bit */
#define PLX9052_INTCSR_LI1CLRINT_MASK		0x0400	/* (post-shift) */
#define PLX9052_INTCSR_LI1CLRINT_SHIFT		10
#define PLX9052_INTCSR_LI1CLRINT_VAL_UNASSERTED	0	/* (pre-shift) */
#define PLX9052_INTCSR_LI1CLRINT_VAL_ASSERTED	1	/* (pre-shift) */
#define PLX9052_INTCSR_LI1CLRINT_SHIFTED_UNASSERTED \
	(PLX9052_INTCSR_LI1CLRINT_VAL_UNASSERTED << PLX9052_INTCSR_LI1CLRINT_SHIFT)
#define PLX9052_INTCSR_LI1CLRINT_SHIFTED_ASSERTED \
	(PLX9052_INTCSR_LI1CLRINT_VAL_ASSERTED << PLX9052_INTCSR_LI1CLRINT_SHIFT)
/* Local Edge Triggerable Interrupt 2 Clear Bit */
#define PLX9052_INTCSR_LI2CLRINT_MASK		0x0800	/* (post-shift) */
#define PLX9052_INTCSR_LI2CLRINT_SHIFT		11
#define PLX9052_INTCSR_LI2CLRINT_VAL_UNASSERTED	0	/* (pre-shift) */
#define PLX9052_INTCSR_LI2CLRINT_VAL_ASSERTED	1	/* (pre-shift) */
#define PLX9052_INTCSR_LI2CLRINT_SHIFTED_UNASSERTED \
	(PLX9052_INTCSR_LI2CLRINT_VAL_UNASSERTED << PLX9052_INTCSR_LI2CLRINT_SHIFT)
#define PLX9052_INTCSR_LI2CLRINT_SHIFTED_ASSERTED \
	(PLX9052_INTCSR_LI2CLRINT_VAL_ASSERTED << PLX9052_INTCSR_LI2CLRINT_SHIFT)
/* ISA Interface Mode Enable (read-only over PCI bus) */
#define PLX9052_INTCSR_ISAMODE_MASK		0x1000	/* (post-shift) */
#define PLX9052_INTCSR_ISAMODE_SHIFT		12
#define PLX9052_INTCSR_ISAMODE_VAL_DISABLED	0	/* (pre-shift) */
#define PLX9052_INTCSR_ISAMODE_VAL_ENABLED	1	/* (pre-shift) */
#define PLX9052_INTCSR_ISAMODE_SHIFTED_DISABLED	\
	(PLX9052_INTCSR_ISAMODE_VAL_DISABLED << PLX9052_INTCSR_ISAMODE_SHIFT)
#define PLX9052_INTCSR_ISAMODE_SHIFTED_ENABLED	\
	(PLX9052_INTCSR_ISAMODE_VAL_ENABLED << PLX9052_INTCSR_ISAMODE_SHIFT)
/*
 * INTCSR values for PCI236.
 */
/* Disable interrupt, also clear any interrupt there */
#define PCI236_INTR_DISABLE ( PLX9052_INTCSR_LI1ENAB_SHIFTED_DISABLED \
        | PLX9052_INTCSR_LI1POL_SHIFTED_HIGH \
        | PLX9052_INTCSR_LI2POL_SHIFTED_HIGH \
        | PLX9052_INTCSR_PCIENAB_SHIFTED_DISABLED \
        | PLX9052_INTCSR_LI1SEL_SHIFTED_EDGE \
        | PLX9052_INTCSR_LI1CLRINT_SHIFTED_ASSERTED )
/* Enable interrupt, also clear any interrupt there. */
#define PCI236_INTR_ENABLE ( PLX9052_INTCSR_LI1ENAB_SHIFTED_ENABLED \
        | PLX9052_INTCSR_LI1POL_SHIFTED_HIGH \
        | PLX9052_INTCSR_LI2POL_SHIFTED_HIGH \
        | PLX9052_INTCSR_PCIENAB_SHIFTED_ENABLED \
        | PLX9052_INTCSR_LI1SEL_SHIFTED_EDGE \
        | PLX9052_INTCSR_LI1CLRINT_SHIFTED_ASSERTED )

#endif /* _PLX9052_H_ */
