unit UIrreg;
{Collatinus - Extraction du lexique d'un texte latin.

Copyright (C) 1998 Y. Ouvrard.

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le
modifier conformment aux dispositions de la Licence Publique Gnrale GNU,
telle que publie par la Free Software Foundation ; version 2 de la licence,
ou encore ( votre choix) toute version ultrieure.
Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE
GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION
A UN OBJET PARTICULIER.
Pour plus de dtail, voir la Licence Publique Gnrale GNU .
Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme
temps que ce programme ; si ce n'est pas le cas, crivez  la
Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
Pour tout contact avec l'auteur : yves.ouvrard@collatinus.org }

interface

uses
  SysUtils, Classes, UDes;

type

  TDonneesIrreg = Class(TDef)
    Canon : string;
    Constructor Create(F : cardinal; M : integer ; K : String);
    end;

  TListeIrreg = class(TStringList)
   public 
    Constructor Lis(R : TReader);
    Constructor Lis_xml;
    Procedure Ecris(W : TWriter);
    Procedure Ajoute(C, K : String ; F : cardinal; M : integer);
    {C : forme irrgulire; K : Canon; F : Flags; M : modle (!)}
    Function Definitions(N : integer) : TList;
    Function Definition(N, D : integer) : TDonneesIrreg;
    {GraphieFNum renvoie la graphie de l'irrgulier de canon K et de rang Num}
    function GraphieFNum(K : string; Num : integer) : string;
    {DefKNum renvoie la morpho de l'irrg de canon K et de rang Num dans la base}
    function DefKNum(K : string; Num : integer) : TDonneesIrreg;
    { conmme DefKNum, mais avec destruction }
    Procedure DeleteKF(K : string; F : integer);
    Procedure IrregsK(K : string; L : TStrings);
    end;

var
  Irregs : TListeIrreg;

implementation

uses Crt, utiles;

//|||||||||||||||||||||||
// TDonneesIrreg ||||||||
//|||||||||||||||||||||||

Constructor TDonneesIrreg.Create(F : cardinal; M : integer ; K : String);
// F : flags; M : Modle; K : Canon
Begin
inherited Create(M,1,F);
{TDef.Create(M, RN : integer; Fl : cardinal)}
Canon := K;
end;

//|||||||||||||||||||||
// TListeIrreg ||||||||
//|||||||||||||||||||||


Constructor TListeIrreg.Lis(R : TReader);
var i, iliste, f : integer;
    FIrr, c : String;
Begin
inherited Create;
Sorted := true;
i := R.ReadInteger;
While i > 0 do
  begin
  dec(i);
  FIrr := R.ReadString;
  //  supprimer sitt la conversion faite.
  if Firr[length(Firr)] in ['0'..'9'] then
    system.delete(Firr, length(Firr), 1);
  iliste := R.ReadInteger;
  While iliste > 0 do
      begin
      c := R.ReadString;
      f := R.ReadInteger;
      Ajoute(Firr, c, f, R.ReadInteger);
      dec(iliste);
      end;
  end;
end;

Constructor TListeIrreg.Lis_xml;

var
   liste : TStringList;
   chemin : string;
   i : integer;
   // points : integer;
   gr, k : string;
   modl : integer;
   c, n, g, p, t, m, v : integer;
   Fl : cardinal;  
{const
   roue = '|/-\';}

   function debaliser(b, l : string) : string;
   var
      len : integer;
      p : integer;
   begin
      len := length (b);
      p := pos('<' + b + '>', l) + len + 2;
      result := copy (l, p, length(l));
      p := pos ('</' + b, result) - 1;
      result := copy (result, 1, p);
   end;

begin
inherited Create;
Sorted := True;
Duplicates := dupAccept ;
liste := TStringList.Create;
if fileexists (share + 'irregs.xml')
   then chemin := share
else chemin := extractFilePath(Paramstr(0));
writeln ('lecture des irrguliers en ' + chemin);
liste.LoadFromFile (chemin + 'irregs.xml');
// passer l''en-tte
i := 0;
while pos('<collatinus>', liste[i]) < 1
   do inc (i);
inc (i);
// points := 0;
Fl:=0;gr:='';c := 0;g:=0;m:=0;n:=0;p:=0;t:=0;v:=0;k:='';modl:=0;
while pos('</collatinus>', liste[i]) < 1 do
   begin
      if pos ('<graphie>', liste[i]) > 0
        then gr := debaliser('graphie', liste[i])
      else if pos ('<modele>', liste[i]) > 0
         then modl := StrToInt (debaliser ('modele', liste[i]))
      else if pos ('<cas>', liste[i]) > 0
         then c := StrToInt (debaliser ('cas', liste[i]))
      else if pos ('<nombre>', liste[i]) > 0
         then n := StrToInt (debaliser ('nombre', liste[i]))
      else if pos ('<genre>', liste[i]) > 0
         then g := StrToInt (debaliser ('genre', liste[i]))
      else if pos ('<personne>', liste[i]) > 0
         then p := StrToInt (debaliser ('personne', liste[i]))
      else if pos ('<temps>', liste[i]) > 0
         then t := StrToInt (debaliser ('temps', liste[i]))
      else if pos ('<mode>', liste[i]) > 0
         then m := StrToInt (debaliser ('mode', liste[i]))
      else if pos ('<voix>', liste[i]) > 0
         then v := StrToInt (debaliser ('voix', liste[i]))
      else if pos ('<canon>', liste[i]) > 0
         then k := debaliser ('canon', liste[i])
      else if pos ('</irreg>', liste[i]) > 0 then
         begin
            if c > 0 then Fl := Cas[c - 1];
            if g > 0 then Fl := Fl or Genres[g-1];
            if n > 0 then Fl := Fl or Nombres[n-1];
            if m > 0 then Fl := fl or Modes[m-1];
            if p > 0 then Fl := Fl or Personnes[p-1];
            if t > 0 then Fl := Fl or Temps[t-1];
            if v > 0 then Fl := Fl or Voix[v-1];
		  
    {C : forme irrgulire; K : Canon; F : Flags; M : modle (!)}
	    Ajoute(gr, k, Fl, modl);
	    Fl:=0;gr:='';c := 0;g:=0;m:=0;n:=0;p:=0;t:=0;v:=0;k:='';modl:=0;
	    {// code  dcommenter pour avoir un signal de chargement
            inc (points);
            if points mod 100 = 0 then
               begin
                  GotoXY(2,WhereY);
                  ClrEol;
                  write(roue[1+((points div 100) mod 4)]);
               end;}
         end;
      inc (i);
   end;
liste.free;
GotoXY(1, WhereY);
ClrEol;
end;

Procedure TListeIrreg.Ecris(W : TWriter);
var i, j : integer;
Begin
W.WriteInteger(Count);
For i := 0 to count-1 do
  begin
  W.WriteString(Strings[i]);
  W.WriteInteger(Definitions(i).count);
  For j := 0 to Definitions(i).count-1 do With Definition(i, j) do
    Begin
    W.WriteString(Canon);
    W.WriteInteger(Flags);
    W.WriteInteger(Modele);
    end;
  end;
end;

Procedure TListeIrreg.Ajoute(C : String ; K : String; F : cardinal; M : integer);
var p : integer;
Begin
if Find(C, p) then
  TList(Objects[p]).Add(TDonneesIrreg.Create(F, M, K))
  else
  Begin
  AddObject(C, TList.Create);
  Ajoute(C, K, F, M);
  end;
end;

Function TListeIrreg.Definitions(N : integer) : TList;
Begin
  Result := TList(Objects[N]);
end;


Function TListeIrreg.Definition(N, D : integer) : TDonneesIrreg;
Begin
Result := TDonneesIrreg(Definitions(N)[D]);
end;

Procedure TListeIrreg.IrregsK(K: string; L: TStrings);
var iIrr, IDef : integer;
begin
   // renvoie la liste des formes irrgulires du canon K
L.Clear;
for iIrr := 0 to count - 1
   do for iDef := 0 to Definitions(iIrr).Count - 1
      do if Definition(iIrr, iDef).Canon = K
      then L.Add(strings[iIrr] + ' : ' + Definition(iIrr, iDef).Graphie(false));
end;

procedure TListeIrreg.DeleteKF(K : string; F : integer);
var
   iIrr, iDef, N : integer;
   inuentum : boolean;
begin
N := 0;
inuentum := false;
for iIrr := 0 to count - 1 do
   begin
      for iDef := 0 to Definitions(iIrr).Count - 1
         do if Definition(iIrr, iDef).Canon = K then
             begin
                if N = F then
                   begin
                      Definitions(iIrr).Delete(iDef);
                      if Definitions(iIrr).Count = 0 then
                         begin
                            delete(iIrr);
                            inuentum := true;
                            break;
                         end;
                   end;
                inc(N);
             end;
      if inuentum
         then break;
   end;
end;

function TListeIrreg.DefKNum(K: string; Num: integer): TDonneesIrreg;
var
   iIrr, iDef, N : integer;
   inuentum : boolean;
begin
Result := nil;
N := 0;
inuentum := false;
for iIrr := 0 to count - 1 do
   begin
      for iDef := 0 to Definitions(iIrr).Count - 1
         do if Definition(iIrr, iDef).Canon = K then
             begin
                if N = Num then
                   begin
                      inuentum := true;
                      result := Definition(iIrr, iDef);
                      break;
                   end;
                inc(N);
             end;
      if inuentum
         then break;
   end;
end;

function TListeIrreg.GraphieFNum(K: string; Num: integer): string;
var
   iIrr, iDef, N : integer;
   inuentum : boolean;
begin
Result := '';
N := 0;
inuentum := false;
for iIrr := 0 to count - 1 do
   begin
      for iDef := 0 to Definitions(iIrr).Count - 1
         do if Definition(iIrr, iDef).Canon = K then
             begin
                if N = Num then
                   begin
                      inuentum := true;
                      result := strings[iIrr];
                      break;
                   end;
                inc(N);
             end;
      if inuentum
         then break;
   end;
end;

end.
