#!/usr/bin/ruby -w
# mb - prepares a mail for a bug report

DATE='2007/11/26'
SDATE=DATE.gsub('/', '')

# max number of lines to include in the bug report
$maxlines=20

if ARGV.length > 1
  $maxlines = ARGV[1].to_i * $maxlines
end

# fetch the error from a build that failed during the build phase
def get_buglog_build(log, lines)
  if $idxbuildfinished - $idxbuilding < $maxlines
    STDERR.puts "Log is short enough, sending everything"
    return lines[$idxbuilding..$idxbuildfinished]
  end
  # get the last "entering" message
#  p lines.grep(/^make.*: Entering directory `/)
  if not (l = lines.grep(/^make.*: Entering directory `/)).empty?
    idxent = lines.rindex(l[-1])
    puts l[-1]
    if $idxbuildfinished - idxent < $maxlines
      STDERR.puts "Cutting from last 'Entering directory'"
      return lines[idxent..$idxbuildfinished]
    end
  end
  STDERR.puts "Cutting last #{$maxlines} lines"
  return lines[($idxbuildfinished - $maxlines)..$idxbuildfinished]
end

# guess the log filename
file = ARGV[0]
if not File::exists?(file)
  lst = Dir::glob("#{file}*")
  if lst.length == 0
    puts "No matching logfile."
    exit 1
  elsif lst.length > 1
    lst2 = lst.join("\n  ")
    puts "Several matching logfiles:\n  #{lst2}"
    exit 1
  else
    file = lst[0]
  end
end

$log = IO::read(file)
$lines = $log.split(/\n/)

# gets the important stuff
dbh = $lines.grep(/^DC-Build-Header:/)[0]
dbs = $lines.grep(/^DC-Build-Status:/)[0]
junk, $package, $version, rest = dbh.split(' ', 4)
junk, $result, $time = dbs.split(' ', 3)

STDERR.puts "P:#{$package} V:#{$version} R:#{$result} T:#{$time}"

if (g = $lines.grep(/^Build finished at /)).empty?
  # didn't display the "Build finished" message
  if not (g = $lines.grep(/^Source-dependencies not satisfied; /)).empty?
    
    STDERR.puts "Failed during build-deps phase ..."
    # failed to install build dep.
    $idxfailedbuilddeps = $lines.index(g[0])
    g = $lines.grep(/^\*\* Using build dependencies supplied by package:/)
    $idxstartbd = $lines.index(g[0])
    $buglog = $lines[$idxstartbd..$idxfailedbuilddeps]
   else
     puts "UNKNOWN CASE"
     exit 1
   end
else
  $idxbuildfinished = $lines.index(g[0]) - 2
  if not (l = $lines.grep(/^dpkg-source: building.*\.dsc$/)).empty?
    STDERR.puts "Failed during build phase ..."
    $idxbuilding = $lines.index(l[0])
    $buglog = get_buglog_build($log, $lines)

  elsif not (l = $lines.grep(/^ \/usr\/bin\/fakeroot debian\/rules clean/)).empty?
    STDERR.puts "Failed during cleaning phase ..."
    $idxstartbd = $lines.index(l[0])
    $buglog = $lines[$idxstartbd..$idxbuildfinished]
  elsif not (l = $lines.grep(/^dpkg-checkbuilddeps: Unmet build dependencies:/)).empty? or not (l = $lines.grep(/^dpkg-buildpackage: warning: Build dependencies\/conflicts unsatisfied; aborting.$/)).empty?
    STDERR.puts "Failed during check for build deps phase ..."
    g = $lines.grep(/^\*\* Using build dependencies supplied by package:/)
    $idxstartbd = $lines.index(g[0])
    $buglog = $lines[$idxstartbd..$idxbuildfinished]
  else
    STDERR.puts "Failed BEFORE build phase, dunno what to do."
    exit 1
  end
end

versions = `apt-cache showsrc #{$package} |grep "^Version:" | awk '{print $2}'`.split
versions.each do |v|
  if `dpkg --compare-versions #{v} gt #{$version} ; echo $?`.to_i == 0
    puts "There's a newer version available: #{v} (vs: #{$version})."
    STDIN.getc
  end
end

File::open("mutt.#{$package}", "w") do |f|
  f.puts "From: #{ENV['DEBFULLNAME']} <#{ENV['DEBEMAIL']}>"
  f.puts "To: submit@bugs.debian.org"
  f.puts "Subject: #{$package}: FTBFS: XXX"
  f.puts
  f.puts "Package: #{$package}"
  f.puts "version: #{$version}"
  f.puts "Severity: serious"
  f.puts "User: debian-qa@lists.debian.org"
  f.puts "Usertags: qa-ftbfs-#{SDATE} qa-ftbfs"
  f.puts "Justification: FTBFS on i386"
  f.puts
  f.puts <<-EOF
Hi,

During a rebuild of all packages in sid, your package failed to build on i386.

Relevant part:

  EOF
  f.puts " > " + $buglog.join("\n > ")
  f.puts <<-EOF

The full build log is available from:
	http://people.debian.org/~lucas/logs/#{DATE}

A list of current common problems and possible solutions is available at 
http://wiki.debian.org/qa.debian.org/FTBFS . You're welcome to contribute!

About the archive rebuild: The rebuild was done on about 50 AMD64 nodes
of the Grid'5000 platform, using a clean chroot containing a sid i386
environment.  Internet was not accessible from the build systems.
  EOF
end
STDERR.puts
cmd = "mutt -H mutt.#{$package}"
STDERR.puts cmd
STDIN.getc
system(cmd)
