// Generated by CoffeeScript 1.4.0
(function() {
  var Lexer, RESERVED, compile, fs, lexer, parser, path, stripBOM, vm, _ref,
    __hasProp = {}.hasOwnProperty;

  fs = require('fs');

  path = require('path');

  _ref = require('./lexer'), Lexer = _ref.Lexer, RESERVED = _ref.RESERVED;

  parser = require('./parser').parser;

  vm = require('vm');

  stripBOM = function(content) {
    if (content.charCodeAt(0) === 0xFEFF) {
      return content.substring(1);
    } else {
      return content;
    }
  };

  if (require.extensions) {
    require.extensions['.coffee'] = function(module, filename) {
      var content;
      content = compile(stripBOM(fs.readFileSync(filename, 'utf8')), {
        filename: filename
      });
      return module._compile(content, filename);
    };
  }

  exports.VERSION = '1.4.0';

  exports.RESERVED = RESERVED;

  exports.helpers = require('./helpers');

  exports.compile = compile = function(code, options) {
    var header, js, merge;
    if (options == null) {
      options = {};
    }
    merge = exports.helpers.merge;
    try {
      js = (parser.parse(lexer.tokenize(code))).compile(options);
      if (!options.header) {
        return js;
      }
    } catch (err) {
      if (options.filename) {
        err.message = "In " + options.filename + ", " + err.message;
      }
      throw err;
    }
    header = "Generated by CoffeeScript " + this.VERSION;
    return "// " + header + "\n" + js;
  };

  exports.tokens = function(code, options) {
    return lexer.tokenize(code, options);
  };

  exports.nodes = function(source, options) {
    if (typeof source === 'string') {
      return parser.parse(lexer.tokenize(source, options));
    } else {
      return parser.parse(source);
    }
  };

  exports.run = function(code, options) {
    var mainModule;
    if (options == null) {
      options = {};
    }
    mainModule = require.main;
    mainModule.filename = process.argv[1] = options.filename ? fs.realpathSync(options.filename) : '.';
    mainModule.moduleCache && (mainModule.moduleCache = {});
    mainModule.paths = require('module')._nodeModulePaths(path.dirname(fs.realpathSync(options.filename)));
    if (path.extname(mainModule.filename) !== '.coffee' || require.extensions) {
      return mainModule._compile(compile(code, options), mainModule.filename);
    } else {
      return mainModule._compile(code, mainModule.filename);
    }
  };

  exports["eval"] = function(code, options) {
    var Module, Script, js, k, o, r, sandbox, v, _i, _len, _module, _ref1, _ref2, _require;
    if (options == null) {
      options = {};
    }
    if (!(code = code.trim())) {
      return;
    }
    Script = vm.Script;
    if (Script) {
      if (options.sandbox != null) {
        if (options.sandbox instanceof Script.createContext().constructor) {
          sandbox = options.sandbox;
        } else {
          sandbox = Script.createContext();
          _ref1 = options.sandbox;
          for (k in _ref1) {
            if (!__hasProp.call(_ref1, k)) continue;
            v = _ref1[k];
            sandbox[k] = v;
          }
        }
        sandbox.global = sandbox.root = sandbox.GLOBAL = sandbox;
      } else {
        sandbox = global;
      }
      sandbox.__filename = options.filename || 'eval';
      sandbox.__dirname = path.dirname(sandbox.__filename);
      if (!(sandbox !== global || sandbox.module || sandbox.require)) {
        Module = require('module');
        sandbox.module = _module = new Module(options.modulename || 'eval');
        sandbox.require = _require = function(path) {
          return Module._load(path, _module, true);
        };
        _module.filename = sandbox.__filename;
        _ref2 = Object.getOwnPropertyNames(require);
        for (_i = 0, _len = _ref2.length; _i < _len; _i++) {
          r = _ref2[_i];
          if (r !== 'paths') {
            _require[r] = require[r];
          }
        }
        _require.paths = _module.paths = Module._nodeModulePaths(process.cwd());
        _require.resolve = function(request) {
          return Module._resolveFilename(request, _module);
        };
      }
    }
    o = {};
    for (k in options) {
      if (!__hasProp.call(options, k)) continue;
      v = options[k];
      o[k] = v;
    }
    o.bare = true;
    js = compile(code, o);
    if (sandbox === global) {
      return vm.runInThisContext(js);
    } else {
      return vm.runInContext(js, sandbox);
    }
  };

  lexer = new Lexer;

  parser.lexer = {
    lex: function() {
      var tag, _ref1;
      _ref1 = this.tokens[this.pos++] || [''], tag = _ref1[0], this.yytext = _ref1[1], this.yylineno = _ref1[2];
      return tag;
    },
    setInput: function(tokens) {
      this.tokens = tokens;
      return this.pos = 0;
    },
    upcomingInput: function() {
      return "";
    }
  };

  parser.yy = require('./nodes');

}).call(this);
