/*
	$Id: displaycard_gl_generic.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"
#ifdef USE_OPENGL

#include "displaycard_gl_generic.h"
#include "blit_gl_generic.h"
#include "API/Core/System/cl_assert.h"
#include "API/Core/System/clanapp.h"

void CL_GL_DisplayCard_Generic::set_palette(CL_Palette *palette)
{
	memcpy(
		this->palette.palette,
		palette->palette,
		palette->num_colors);
}

CL_Palette *CL_GL_DisplayCard_Generic::get_palette()
{
	return &palette;
}

const std::list<CL_VidMode*> &CL_GL_DisplayCard_Generic::get_videomodes()
{
	static std::list<CL_VidMode*> modes;
	return modes;
}

CL_Target *CL_GL_DisplayCard_Generic::get_target()
{
//	cl_info(1, "get_target not working in generic GL impl");
	return NULL;
}

CL_Target *CL_GL_DisplayCard_Generic::get_frontbuffer()
{
//	cl_info(1, "get_frontbuffer not working in generic GL impl");
	return NULL;
}

void CL_GL_DisplayCard_Generic::sync_buffers()
{
//	cl_info(1, "sync not working in generic GL impl... yet");
}

void CL_GL_DisplayCard_Generic::clear_display(
	float red,
	float green,
	float blue,
	float alpha)
{
	glClearColor(red, green, blue, 1-alpha);
	glClear(GL_COLOR_BUFFER_BIT);
}

void CL_GL_DisplayCard_Generic::fill_rect(
	int x1,
	int y1,
	int x2,
	int y2,
	float r,
	float g,
	float b,
	float a)
{
	begin_2d();
	glDisable(GL_TEXTURE_2D);
	glBegin(GL_QUADS);
		glColor4f(r,g,b,a);
		glVertex2i(x1, y1);
		glVertex2i(x2, y1);
		glVertex2i(x2, y2);
		glVertex2i(x1, y2);
		glColor4f(1.0, 1.0, 1.0, 1.0);
	glEnd();
	glEnable(GL_TEXTURE_2D);
	end_2d();
}

void CL_GL_DisplayCard_Generic::draw_line(
	int x1,
	int y1,
	int x2,
	int y2,
	float r,
	float g,
	float b,
	float a)
{
	begin_2d();
	glDisable(GL_TEXTURE_2D);
	glBegin(GL_LINES);
		glColor4f(r,g,b,a);
		glVertex2i(x1, y1);
		glVertex2i(x2, y2);
		glColor4f(1.0, 1.0, 1.0, 1.0);
	glEnd();
	glEnable(GL_TEXTURE_2D);
	end_2d();
}

void CL_GL_DisplayCard_Generic::begin_2d()
{
	uses_count--;
	if (uses_count==-1)
	{
		glPushAttrib(GL_ALL_ATTRIB_BITS);	// todo: narrow range of what is saved

		glEnable(GL_TEXTURE_2D);
		glEnable(GL_BLEND);
		glDisable(GL_FOG);
		glDisable(GL_DEPTH_TEST);

		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );

		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	
		glColor4f(1.0, 1.0, 1.0, 1.0);

		glMatrixMode(GL_PROJECTION);
		glPushMatrix();
		glLoadIdentity();

		gluOrtho2D(0.0, (GLdouble) get_width(), (GLdouble) get_height(), 0.0);

		glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
		glLoadIdentity();

		m_uses_gl = false;
	}
}

void CL_GL_DisplayCard_Generic::end_2d()
{
	uses_count++;
	if (uses_count==0)
	{
		glPopMatrix();
		glMatrixMode(GL_PROJECTION);
		glPopMatrix();

		glPopAttrib();

		m_uses_gl = true;
	}
}

CL_Blitters CL_GL_DisplayCard_Generic::create_hw_blitters(CL_SurfaceProvider *provider)
{
	// TODO: Use another blitter if texture is larger than max_texture_size...
	CL_Blit_GLTexture *blitter = new CL_Blit_GLTexture(this, provider);

	CL_Blitters hw;
	hw.set_noclip(blitter);
	hw.set_clip(blitter);
	hw.set_scale_noclip(blitter);
	hw.set_scale_clip(blitter);

	return hw;
}

CL_Blitters CL_GL_DisplayCard_Generic::create_hw_dynamic_blitters(CL_SurfaceProvider *provider)
{
	// TODO: Use another blitter if texture is larger than max_texture_size...
	CL_Blit_GLTexture *blitter = new CL_Blit_GLTexture(this, provider);

	CL_Blitters hw;
	hw.set_noclip(blitter);
	hw.set_clip(blitter);
	hw.set_scale_noclip(blitter);
	hw.set_scale_clip(blitter);

	return hw;
}

#endif
