/*
	$Id: surface_manager.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Surface manager

*/

#include "Core/precomp.h"
/*
#include "API/Core/SurfaceProviders/surface_manager.h"

CL_SurfaceManager_Card::CL_SurfaceManager_Card(CL_DisplayCard *_card)
{
	card = _card == NULL ? CL_Display::get_current_card() : _card;
}

int CL_SurfaceManager_Card::compare_surfaces(const void *s1, const void *s2)
{
	int p1 = (*((CL_SurfaceManager_Priority **) s1))->get_priority();
	int p2 = (*((CL_SurfaceManager_Priority **) s2))->get_priority();

	if (p1 < p2) return 1;
	else if (p1 > p2) return -1;
	else return 0;
}

void CL_SurfaceManager_Card::add_surface(CL_SurfaceManager_Priority *surf_prio)
{
	priority_list.push_back(surf_prio);
}

void CL_SurfaceManager_Card::remove_surface(CL_SurfaceManager_Priority *surf_prio)
{
	priority_list.remove(surf_prio);
}

void CL_SurfaceManager_Card::optimize_video()
{
	CL_SurfaceManager_Priority **surfaces = new CL_SurfaceManager_Priority *[priority_list.size()];
	int pos = 0;

	{
		for (
			std::list<CL_SurfaceManager_Priority*>::iterator it = priority_list.begin();
			it != priority_list.end();
			it++)
		{
			 surfaces[pos++] = *it;
		}
	}

	qsort(surfaces, pos, sizeof(CL_SurfaceManager_Priority*), compare_surfaces);

	for (
		std::list<CL_SurfaceManager_Priority*>::iterator it = priority_list.begin();
		it != priority_list.end();
		it++)
	{
		(*it)->reset_priority();
	}

	int i;
	for (i=0;i<pos;i++)
	{
		CL_Surface *surf = surfaces[i]->get_surface();
		if (!surf->is_loaded())
		{
			surf->get_provider()->lock();
			if (!surf->convert_video() && !surf->convert_system())
			{
				cout << "Dammit - we're in a lot of trouble (surface could not be loaded into memory (video or system))" << endl;
			}
			surf->get_provider()->unlock();
		}
		else surf->convert_video();
	}

	bool still_video = true;
	int memory_limit_pos = 0;
	int memory_needed = 0;
	for (i=0; i<pos; i++)
	{
		CL_Surface *cur_surface = surfaces[i]->get_surface();

		bool video = cur_surface->is_video();
		if (!video && still_video) 
		{
			// no need for speculations if memory is plentiful
			if (cur_surface->convert_video()) continue;
			
			memory_needed = cur_surface->get_provider()->get_width()*
											cur_surface->get_provider()->get_height()*
											cur_surface->get_provider()->get_no_sprs();

			int memory_attainable = 0;
			for (int o=i+1;o<pos;o++)
			{
				CL_Surface *check_surf = surfaces[o]->get_surface();
				if (check_surf->is_video())
				{
					CL_SurfaceProvider *prov = check_surf->get_provider();
					memory_attainable += prov->get_width()*
															 prov->get_height()*
															 prov->get_no_sprs();
				}
			}
			if (memory_needed <= memory_attainable)
			{
				still_video = false;
				memory_limit_pos = i;
			}
		}
		else if (video && !still_video) 
		{
			cur_surface->convert_system(card);
			memory_needed -= cur_surface->get_provider()->get_width()*
											 cur_surface->get_provider()->get_height()*
											 cur_surface->get_provider()->get_no_sprs();

			if (memory_needed < 0)
			{
				if (!surfaces[memory_limit_pos]->get_surface()->convert_video())
				{
//					cout << "Mal-aligned memory... retrying" << endl;
					continue;
				}

				while (memory_limit_pos < i)
				{
					memory_limit_pos++;
					CL_SurfaceProvider *prov = surfaces[memory_limit_pos]->get_surface()->get_provider();

					int new_mem_needed = memory_needed + prov->get_width()*
																							 prov->get_height()*
																							 prov->get_no_sprs();
					int memory_attainable = 0;
					for (int o=i+1;o<pos;o++)
					{
						if (surfaces[o]->get_surface()->is_video())
						{
							CL_SurfaceProvider *prov = surfaces[o]->get_surface()->get_provider();
							memory_attainable += prov->get_width()*
																	 prov->get_height()*
																	 prov->get_no_sprs();
						}
					}

					if (new_mem_needed < memory_attainable)
					{
						memory_needed += prov->get_width()*
														 prov->get_height()*
														 prov->get_no_sprs();
						break;
					}
				}
			}
		}
	}

	for (i=0;i<pos;i++)
	{
		CL_Surface *surf = surfaces[i]->get_surface();
		if (!surf->is_loaded())
		{
			surf->get_provider()->lock();
			if (!surf->convert_video() && !surf->convert_system())
			{
				cout << "Dammit - we're in a lot of trouble (surface could not be loaded into memory (video or system))" << endl;
			}
			surf->get_provider()->unlock();
		}
		else surf->convert_video();
	}

	delete[] surfaces;
}
*/