/*
	$Id: cl_grect.h,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#ifndef CL_GRECT_H
#define CL_GRECT_H

#include "cl_gpoint.h"

///
class CL_GRect
{
 public:
  
  ///
  CL_GRect();
  ///
  CL_GRect( int x, int y, int w, int h);

  ///
  CL_GRect( const CL_GPoint& upperLeft, const CL_GPoint& lowerRight);
  ///
  virtual ~CL_GRect();

  ///
  static CL_GRect invalid;
  ///
  static CL_GRect empty;
  ///
  bool isEmpty() const;
  ///
  bool isValid() const;
  ///
  bool contains( const CL_GPoint &p ) const;
  ///
  bool contains( const CL_GRect &r )  const;

  ///move the rectangle by (dx, dy)
  virtual void translate( int dx, int dy );
  ///move the rectangle, specifying new upperleft corner
  virtual void warp(const CL_GPoint &newUpperLeft);
  ///this keeps the upper left corner and moves the lower right one
  virtual void resize(int w, int h);
  ///
  CL_GRect unite( const CL_GRect &r )    const;
  ///
  CL_GRect intersect( const CL_GRect &r) const;

  ///
  CL_GPoint upperLeft() const { return upperLeft_; };
  ///
  CL_GPoint lowerRight() const { return lowerRight_; };

  ///
  int width() const { return lowerRight_.x - upperLeft_.x ; };
  ///
  int height() const { return lowerRight_.y - upperLeft_.y ; };

  ///
  friend bool operator==(const CL_GRect &p, const CL_GRect &q)
    { return ((p.upperLeft() == q.upperLeft()) &&
	      (p.lowerRight() == q.lowerRight())); };

  ///comparism by size of area (width * height)
  friend bool operator<(const CL_GRect &p, const CL_GRect &q)
    { return (p.width()*p.height()) < (q.width()*q.height()); };


  ///
  friend std::ostream& operator<<(std::ostream& s, const CL_GRect& p);
 
 protected:

  ///
  CL_GPoint upperLeft_;
  ///
  CL_GPoint lowerRight_;

};
#endif
