/*
	$Id: cl_gconnection.h,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#ifndef CL_GCONNECTION_H
#define CL_GCONNECTION_H

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#ifdef DEBUG_CONNECTIONS
#include <iostream>
#endif
#include "cl_gobject.h"

class CL_GObject;

/*
 * This class is used for representing a connection between two objects,
 * for signal-passing.
 */
class CL_GConnection
{
public:
	CL_GConnection(
		CL_GObject *sender,
		CL_GMember signal,
		CL_GObject *reciever,
		CL_GSlot slot)
	{
		send = sender;
		rec = reciever;
		from = signal;
		to = slot;
#ifdef DEBUG_CONNECTIONS
		std::cout << "CL_GConnection ctor called" << std::endl;
#endif
	}
	~CL_GConnection()
	{
#ifdef DEBUG_CONNECTIONS
		std::cout << "CL_GConnection dtor called" << std::endl;
#endif
	}

	CL_GObject *get_sender() { return send; }
//: Returns the object that would send the signal for this connection
//!retval: The object

	CL_GObject *get_reciever() { return rec; }
//: Returns the object that would receive the signal for this connection
//!retval: The object

	CL_GMember get_signal() { return from; }
//: Returns the signal for this connection
//!retval: The signal

	CL_GSlot get_slot() { return to; }
//: Returns the slot for this connection
//!retval: The slot

private:
	CL_GObject *send, *rec;
	CL_GMember from;
	CL_GSlot   to;
};
#endif
