/*
	$Id: provider_ppm.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		PPM surface provider.
*/

//! component="SurfaceProviders"

#ifndef header_ppmprovider
#define header_ppmprovider

#include "generic_surfaceprovider.h"

#include "../Display/pixelformat.h"

class CL_PPMProvider : public CL_SurfaceProvider
{
public:

	static CL_Surface *create(
		std::string handle,
		CL_InputSourceProvider *provider,
		bool transparent=false,
		unsigned char trans_red=0, 
		unsigned char trans_green=0, 
		unsigned char trans_blue=0);

	CL_PPMProvider(
		std::string name,
		CL_InputSourceProvider *provider,
		bool transparent=false,
		unsigned char trans_red=0, 
		unsigned char trans_green=0, 
		unsigned char trans_blue=0);

	virtual ~CL_PPMProvider();

	virtual unsigned int get_pitch() const;
	virtual unsigned int get_width() const;
	virtual unsigned int get_height() const;
	virtual unsigned int get_num_frames() const;
	virtual unsigned int get_depth() const;
	virtual unsigned int get_red_mask() const;
	virtual unsigned int get_green_mask() const;
	virtual unsigned int get_blue_mask() const;
	virtual unsigned int get_alpha_mask() const;
	virtual bool is_indexed() const;
	virtual CL_Palette *get_palette() const;
	virtual bool uses_src_colorkey() const;
	virtual unsigned int get_src_colorkey() const;
	virtual void *get_data() const;
	virtual void lock();
	virtual void unlock();

	unsigned int save_to_file(
		std::string output_name,
		int x_min,
		int y_min,
		int x_max,
		int y_max,
		unsigned char *src);



	int my_get_value(CL_InputSource *datafile);

private:
	int lock_refs;

	bool load_lock;
	
	unsigned char *buffer;

	CL_InputSourceProvider *provider;
	std::string name;
	bool transparent;

	short width;
	short height;
	short max_val;

	unsigned char trans_red; 
	unsigned char trans_green; 
	unsigned char trans_blue;

};
#endif