/*
	$Id: treeview_node.cpp,v 1.10 2002/01/16 19:43:06 sphair Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"

#include "API/GUI/treeview.h"
#include "API/GUI/treeview_item.h"
#include "API/GUI/treeview_node.h"
#include "API/Display/Display/display.h"

/////////////////////////////////////////////////////////////////////////////
// Construction:

CL_TreeView_Node::CL_TreeView_Node(CL_TreeView *root)
{
	rootTree = root;
	component = NULL;
	delete_component = false;
	collapsed = false;
	selected = false;
	userdata = NULL;
}

CL_TreeView_Node::~CL_TreeView_Node()
{
	clear();
}

/////////////////////////////////////////////////////////////////////////////
// Attributes:

void *CL_TreeView_Node::get_userdata() const
{
	return userdata;
}

/////////////////////////////////////////////////////////////////////////////
// Operations:

CL_TreeView_Node *CL_TreeView_Node::insert_item(const std::string &text, int index)
{
	CL_Component *new_component = new CL_TreeView_Item(text, rootTree->get_client_area());

	CL_TreeView_Node *node = new CL_TreeView_Node(rootTree);
	node->component = new_component;
	node->delete_component = true;
	children.push_back(node);

	slots.connect(new_component->sig_mouse_up(), node, &CL_TreeView_Node::on_child_click);

	return node;
}

CL_TreeView_Node *CL_TreeView_Node::insert_item(CL_Component *new_component, int index)
{
	rootTree->get_client_area()->add_child(new_component);

	CL_TreeView_Node *node = new CL_TreeView_Node(rootTree);
	node->component = new_component;
	children.push_back(node);

	slots.connect(new_component->sig_mouse_up(), node, &CL_TreeView_Node::on_child_click);

	return node;
}

void CL_TreeView_Node::draw_nodes(CL_Point &point)
{
	std::list<CL_TreeView_Node *>::iterator it;
	for (it = children.begin(); it != children.end(); ++it)
		(*it)->draw_node(point);
}

void CL_TreeView_Node::draw_node(CL_Point &point)
{
	// Size and place child component
	component->set_position(point.x + 12, point.y);

	int height = component->get_height();
	int mid = (height) / 2;

	// Draw collapse box
	if(!children.empty())
	{
		// Box
		CL_Display::draw_rect(point.x, point.y + mid - 5, point.x + 9, point.y + mid + 4, 0.0f, 0.0f, 0.0f);

		// Horizontal line
		CL_Display::draw_line(point.x + 2, point.y + mid - 1, point.x + 6, point.y + mid - 1, 0.0f, 0.0f, 0.0f);

		// Vertical line
		if(collapsed)
			CL_Display::draw_line(point.x + 4, point.y + mid - 3, point.x + 4, point.y + mid + 1, 0.0f, 0.0f, 0.0f);
	}

	// Draw component
	CL_Display::push_translate_offset(point.x + 12, point.y);
	component->sig_paint()();
	if(selected)
		CL_Display::fill_rect(0, 0, component->get_width(), component->get_height(), 0.5f, 0.5f, 1.0f, 0.3f);
	CL_Display::pop_translate_offset();

	// Move down for next component
	point.y += height;

	// Draw children
	if(collapsed == false)
	{
		point.x += 15;
		draw_nodes(point);
		point.x -= 15;
	}
}

void CL_TreeView_Node::set_selected(bool select)
{
	selected = select;
}

void CL_TreeView_Node::set_selected(CL_TreeView_Node *node, bool select)
{
	node->set_selected(select);
}

void CL_TreeView_Node::clear_selection()
{
	set_selected(false);

	std::list<CL_TreeView_Node *>::iterator it;
	for (it = children.begin(); it != children.end(); ++it)
		(*it)->clear_selection();
}

void CL_TreeView_Node::clear()
{
	std::list<CL_TreeView_Node *>::iterator it;
	for (it = children.begin(); it != children.end(); ++it)
		delete (*it);

	children.clear();

	if(component && delete_component)
		delete component;
}

void CL_TreeView_Node::set_userdata(void *data)
{
	userdata = data;
}

/////////////////////////////////////////////////////////////////////////////
// Callbacks:

void CL_TreeView_Node::on_child_click(const CL_Key &key)
{
	collapsed = !collapsed;

	rootTree->sig_selection_changed()(*this);
}
