/*
	$Id: menuitem_generic.h,v 1.10 2001/09/08 19:12:51 japj Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#ifndef header_menuitem_generic
#define header_menuitem_generic

#include "API/GUI/menuitem.h"
#include "API/Core/System/timer.h"

class CL_MenuItem_Generic
{
// Construction:
public:
	static CL_ComponentOptions create_options(
		const std::string &text,
		bool checkable,
		bool checked,
		bool separator);

	CL_MenuItem_Generic(CL_MenuItem *self, const CL_ComponentOptions &options, CL_StyleManager *style);
	~CL_MenuItem_Generic() {};

// Attributes:
public:
	bool is_checkable() const;
	bool is_separator() const;
	bool is_checked() const;
	bool is_highlighted() const;
	bool has_submenu() const;
	const std::string &get_text() const;

// Operations:
public:
	void set_text(const std::string &text);

// Signals:
public:
	CL_Signal_v0 sig_clicked;

// Slots:
private:
	CL_Slot slot_mouse_enter;
	CL_Slot slot_mouse_left;
	CL_Slot slot_key_down;
	CL_Slot slot_timer_popup;
	CL_Slot slot_child_add;

// Callbacks:
private:
	void on_mouse_enter();
	void on_mouse_leave();

	void on_child_add(CL_Component *child);

	void on_key_down(CL_Component *comp, CL_InputDevice *device, const CL_Key &key);
	void on_timer_popup();

// Implementation:
private:
	CL_MenuItem *menuitem;
	
	CL_Timer timer_popup;

	std::string text;
	
	bool separator;
	bool checked;
	bool checkable;
	bool highlighted;
};

#endif
