/*
	$Id: popupmenu.h,v 1.28 2001/10/10 12:17:10 sphair Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	See http://www.clanlib.org
	------------------------------------------------------------------------
*/

//! clanGUI="Controls"
//! header=gui.h

#ifndef header_popupmenu
#define header_popupmenu

#include "menudata.h"

class CL_PopupMenu_Generic;

//: Popupmenu component
class CL_PopupMenu : public CL_MenuData
{
//! Construction:
public:
	//: PopupMenu Constructor
	CL_PopupMenu(
		const CL_ComponentOptions &options,
		CL_Component *parent,
		CL_StyleManager *style = NULL);

	//: PopupMenu Constructor
	CL_PopupMenu(
		CL_Component *parent,
		CL_StyleManager *style = NULL);

	//: PopupMenu Constructor
	CL_PopupMenu(
		const class CL_Point &pos,
		CL_Component *parent,
		CL_StyleManager *style = NULL);

	//: PopupMenu Destructor
	virtual ~CL_PopupMenu();

//! Attributes:
public:

//! Operations:
public:

//! Signals:
public:
	//: This signal is emitted when the popupmenu is cancelled.
	CL_Signal_v0 &sig_cancelled();

//! Implementation:
private:
	CL_PopupMenu_Generic *impl;
};  

#endif
