/*
	$Id: combobox.h,v 1.26 2001/12/27 22:45:46 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	See http://www.clanlib.org
	------------------------------------------------------------------------
*/

//! clanGUI="Controls"
//! header=gui.h

#ifndef header_combobox
#define header_combobox

#include "component.h"

class CL_ComboBox_Generic;

//: Combobox component
class CL_ComboBox : public CL_Component
{
//! Construction:
public:
	//: ComboBox constructor
	CL_ComboBox(
		CL_Component *parent,
		CL_StyleManager *style = NULL);

	//: ComboBox constructor
	CL_ComboBox(
		const CL_Rect &pos,
		CL_Component *parent,
		CL_StyleManager *style = NULL);

	//: ComboBox destructor
	virtual ~CL_ComboBox();

//! Attributes:
public:
	//: Returns the number of items in the combobox.
	int get_count() const;

	//: Returns all items in the list.
	std::list<std::string> &get_items() const;

	//: Returns the current text item. 
	std::string get_current_text() const;

	//: Returns the text item at a given index.
	std::string get_text(int index) const;

	//: Returns the index of the current combobox item.
	int get_current_item() const;

	//: Returns true if item index is selected. Returns false if it is not selected or if there is an error.
	bool is_selected(int index) const;

//! Operations:
public:
	//: Inserts a text item at position index. 
	//: The item will be appended if index is negative.
	int insert_item(const std::string &text, int index = -1);

	//: Removes and deletes the item at position index.
	//: If index is equal to currentItem(), a new item gets highlighted and the highlighted() signal is emitted. 
	void remove_item(int index);

	//: Replaces the item at position index with a text.
	void change_item(const std::string &text, int index);

	//: Sets the current combobox item. This is the item to be displayed on the combobox button. 
	void set_current_item(int index);

	//: Deselect current selected item.
	void clear_selection();

	//: Sorts the items in ascending order, if ascending is true, or descending otherwise. 
	void sort(bool ascending = true);

	//: Removes all combobox items. 
	void clear();

//! Signals:
public:
	//: This signal is emitted when a new item has been activated (selected).
	//- int index - The position of the item in the popup list. 
	CL_Signal_v1<int> &sig_activated();

	//: This signal is emitted when a new item has been highlighted.
	//- int index - The position of the item in the popup list. 
	CL_Signal_v1<int> &sig_highlighted();

//! Implementation:
private:
	CL_ComboBox(const CL_ComboBox &copy) : CL_Component(NULL, NULL) { return; } // disallow copy construction.
	CL_ComboBox_Generic *impl;
};  

#endif
