#include <iostream.h>

#include <ClanLib/core.h>
#include <ClanLib/gui.h>
#include <ClanLib/application.h>
#include <ClanLib/display.h>

class MenuTest : public CL_ClanApplication
{
public:
	char *get_title() { return "MenuTest"; }

	CL_ResourceManager *resources;
	CL_StyleManager *style;
	CL_ComponentManager *manager;
	CL_GUIManager *gui;

	bool quit;
	CL_Slot slot_quit;
	
	int main(int argc, char** argv)
	{
		// Create a console window for text-output if not available
		CL_ConsoleWindow console("Console");
		console.redirect_stdio();

		std::cout << std::endl;
		std::cout << "'Yeah, I am aware that this examples quits with a segfault...'" << std::endl;
		std::cout << "                                                            - Sphair" << std::endl;
		std::cout << std::endl;

		try
		{
			CL_SetupCore::init();
			CL_SetupGUI::init();
			CL_SetupDisplay::init();
			CL_Display::set_videomode(640,480,16, false);

			resources = new CL_ResourceManager("resources.scr", false);
			style = new CL_StyleManager_Default(resources);
			gui = new CL_GUIManager(style);
			manager = CL_ComponentManager::create("menutest.gui", false, style,gui);
			

			quit = false;

			CL_MenuItem *item_quit = (CL_MenuItem *)manager->get_component("file_quit");
			slot_quit = item_quit->sig_clicked().connect(this, &MenuTest::on_quit);

			while (!CL_Keyboard::get_keycode(CL_KEY_ESCAPE) && quit == false)
			{
				CL_Display::clear_display(0.0, 0.5, 0.5);
				gui->show();
				CL_System::keep_alive();
				CL_Display::flip_display();
			}

			resources->unload_all();
			
			delete gui;
			delete manager;
			delete style;
			delete resources;
			
			CL_SetupDisplay::deinit();
			CL_SetupGUI::deinit();
			CL_SetupCore::deinit();
		}
		catch (CL_Error e)
		{
			std::cout << e.message.c_str() << std::endl;
		}
		// Display console close message and wait for a key
		console.display_close_message();

		return 0;
	}

	void on_quit()
	{
		quit = true;
	}
} app;
