/* print.c - displays checksum listing
   
   Copyright (C) 2000 Bryan Call <bc@fodder.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <stdlib.h>

void pnsfv_head()
{
  clock_t       clock;
  struct tm     *timeinfo;
  
  clock = time(NULL);
  timeinfo = localtime(&clock);
  printf("; Generated by cksfv v%s on ", VERSION);
  printf("%02d-%02d-%02d at %02d:%02d.%02d\n", timeinfo->tm_year+1900,
         timeinfo->tm_mon, timeinfo->tm_mday, timeinfo->tm_hour,
         timeinfo->tm_min, timeinfo->tm_sec);
  printf("; Written by Bryan Call <bc@fodder.org> ");
  printf("- http://www.fodder.org/cksfv\n");
}

void pfileinfo(char **argv)
{
  char          *fn;
  struct stat   sb;
  struct tm     *timeinfo;
  
  printf(";\n");
  
  while(*argv) {
    fn = *argv++;
    if (!(stat(fn, &sb))) {
      timeinfo = localtime(&sb.st_mtime);
      printf(";%13d  %02d:%02d.%02d %02d-%02d-%02d %s\n",
             (int)sb.st_size, timeinfo->tm_hour, timeinfo->tm_min,
             timeinfo->tm_sec,
             timeinfo->tm_year+1900, timeinfo->tm_mon, timeinfo->tm_mday, fn);
    }
  }
}

void pcrc(char *fn, unsigned long val)
{
  printf("%s %.8lX\n", fn, val);
}

void prsfv_head(char *fn)
{
  char          head[81], *p;
  int           len;
  
  fprintf(stderr, "cksfv v%s written by Bryan Call <bc@fodder.org>\n",
          VERSION);
  fprintf(stderr, "           http://www.fodder.org/cksfv\n\n");

  snprintf(head, 80, "--( Verifying: %s", fn);
  len = strlen(head);
  if (len < 76) {
    p = head + len;
    *p++ = ' ';
    *p++ = ')';
      
    for (p = head + len + 2, len = 78 - len; len--; p++)
      *p = '-';
  } else {
    p = head + 76;
    *p++ = ' ';
    *p++ = ')';
    *p++ = '-';
    *p++ = '-';
  }
  head[80] = '\n';
  head[81] = '\0';
  fprintf(stderr, "%s", head);
}

void pusage()
{
  fprintf(stderr, "cksfv v%s written by Bryan Call <bc@fodder.org>\n",
          VERSION);
  fprintf(stderr, "           http://www.fodder.org/cksfv\n\n");
  fprintf(stderr, "usage: cksfv [-iq] [-C directory] [-f file.sfv] ");
  fprintf(stderr, "[file ...]\nsupported options:\n\n");
  fprintf(stderr, " -C\tchange to directory for processing\n");
  fprintf(stderr, " -f\t.sfv file to verify\n");
  fprintf(stderr, " -i\tignore case on filenames\n");
  fprintf(stderr, " -q\tquiet, only prints error messages\n");
  fprintf(stderr, " -v\tverbose, by default this option is on\n");
  exit(1);
}  
