#include "cp_types.h"
#include "cp_proto.h"

/* call only from 'split_flips'; if flag==2 and edge <v,w> is 
shared by two faces, do Whitehead move -- remove <v,w> as an edge and 
make <lv,rv> an edge between common nghb verts lv, rv. If flag==3 and
common nghb's lv, rv form edge, do reverse -- create edge
<v,w>, remove <lv,rv>. Caution: some data not updated between calls.
Return 0 for some improper situations: if flip would result in interior
vert of degree 2 (may be okay on bdry); if the new edge already exists
(can happen, e.g., when one neighbor has degree three). */

int flip_edge(struct p_data *p,int v,int w,int flag)
{
  int j,ind_v,ind_w,ind_c,lv,rv,*newflower;
  double *newol;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  if (flag==2)  /* neighboring verts? */
    {
      if ((ind_v=nghb(p,v,w))<0 || (ind_w=nghb(p,w,v))<0 
	  || (pK_ptr[v].bdry_flag && pK_ptr[v].flower[0]==w)
	  || (pK_ptr[w].bdry_flag && pK_ptr[w].flower[0]==v)
	  || (!pK_ptr[v].bdry_flag && pK_ptr[v].num<=3)
	  || (!pK_ptr[w].bdry_flag && pK_ptr[w].num<=3))
	return 0; /* bdry edge or error */
      lv=pK_ptr[v].flower[ind_v+1];
      rv=pK_ptr[w].flower[ind_w+1];
      if (nghb(p,lv,rv)>=0) return 0; /* <lv,rv> already an edge */
      /* adjust flower of v */
      newflower=(int *)calloc((size_t)(pK_ptr[v].num),sizeof(int));
      for (j=0;j<ind_v;j++) newflower[j]=pK_ptr[v].flower[j];
      for (j=ind_v+1;j<=pK_ptr[v].num;j++)
	newflower[j-1]=pK_ptr[v].flower[j];
      free(pK_ptr[v].flower);
      pK_ptr[v].flower=newflower;
      if (p->overlap_status)
	{
	  newol=(double *)calloc((size_t)(pK_ptr[v].num),sizeof(double));
	  for (j=0;j<ind_v;j++) newol[j]=pK_ptr[v].overlaps[j];
	  for (j=ind_v+1;j<=pK_ptr[v].num;j++)
	    newol[j-1]=pK_ptr[v].overlaps[j];
	  free(pK_ptr[v].overlaps);
	  pK_ptr[v].overlaps=newol;
	}
      pK_ptr[v].num--;
      if (ind_v==0 && !pK_ptr[v].bdry_flag) 
	pK_ptr[v].flower[pK_ptr[v].num]=pK_ptr[v].flower[0];
      /* adjust flower of w */
      newflower=(int *)calloc((size_t)(pK_ptr[w].num),sizeof(int));
      for (j=0;j<ind_w;j++) newflower[j]=pK_ptr[w].flower[j];
      for (j=ind_w+1;j<=pK_ptr[w].num;j++)
	newflower[j-1]=pK_ptr[w].flower[j];
      free(pK_ptr[w].flower);
      pK_ptr[w].flower=newflower;
      if (p->overlap_status)
	{
	  newol=(double *)calloc((size_t)(pK_ptr[w].num),sizeof(double));
	  for (j=0;j<ind_w;j++) newol[j]=pK_ptr[w].overlaps[j];
	  for (j=ind_w+1;j<=pK_ptr[w].num;j++)
	    newol[j-1]=pK_ptr[w].overlaps[j];
	  free(pK_ptr[w].overlaps);
	  pK_ptr[w].overlaps=newol;
	}
      pK_ptr[w].num--;
      if (ind_w==0 && !pK_ptr[w].bdry_flag) 
	pK_ptr[w].flower[pK_ptr[w].num]=pK_ptr[w].flower[0];
      /* adjust nghb flowers */
      ind_v=nghb(p,lv,v);
      newflower=(int *)calloc((size_t)(pK_ptr[lv].num+2),sizeof(int));
      for (j=0;j<=ind_v;j++) newflower[j]=pK_ptr[lv].flower[j];
      for (j=pK_ptr[lv].num;j>ind_v;j--)
	newflower[j+1]=pK_ptr[lv].flower[j];
      newflower[ind_v+1]=rv;
      free(pK_ptr[lv].flower);
      pK_ptr[lv].flower=newflower;
      if (p->overlap_status)
	{
	  newol=(double *)calloc((size_t)(pK_ptr[lv].num+2),sizeof(double));
	  for (j=0;j<=ind_v;j++) newol[j]=pK_ptr[lv].overlaps[j];
	  for (j=pK_ptr[lv].num;j>ind_v;j--)
	    newol[j+1]=pK_ptr[lv].overlaps[j];
	  newol[ind_v+1]=1.0;
	  free(pK_ptr[lv].overlaps);
	  pK_ptr[lv].overlaps=newol;
	}
      pK_ptr[lv].num++;
      ind_w=nghb(p,rv,w);
      newflower=(int *)calloc((size_t)(pK_ptr[rv].num+2),sizeof(int));
      for (j=0;j<=ind_w;j++) newflower[j]=pK_ptr[rv].flower[j];
      for (j=pK_ptr[rv].num;j>ind_w;j--)
	newflower[j+1]=pK_ptr[rv].flower[j];
      newflower[ind_w+1]=lv;
      free(pK_ptr[rv].flower);
      pK_ptr[rv].flower=newflower;
      if (p->overlap_status)
	{
	  newol=(double *)calloc((size_t)(pK_ptr[rv].num+2),sizeof(double));
	  for (j=0;j<=ind_w;j++) newol[j]=pK_ptr[rv].overlaps[j];
	  for (j=pK_ptr[rv].num;j>ind_w;j--)
	    newol[j+1]=pK_ptr[rv].overlaps[j];
	  newol[ind_w+1]=1.0;
	  free(pK_ptr[rv].overlaps);
	  pK_ptr[rv].overlaps=newol;
	}
      pK_ptr[rv].num++;
      return 1;
    }
  if (flag==3) /* find common neighbor */
    {
      if ((ind_c=common_nghbs(p,v,w))<0) return 0;
      else return (flip_edge(p,pK_ptr[v].flower[ind_c],
	pK_ptr[v].flower[ind_c+1],2));
    }
  return 0;
} /* flip_edge */
