#include "cp_types.h"
#include "cp_proto.h"

/* separated from ActivePack.c to try to track down bug */

struct p_light *extract_light_pack(struct p_data *p,int seed,
		struct RedList **redlist,int **green_list,
		int *okay,int n,int nmbr) 
/* Given a redchain defining a simply connected sub-complex 
of p containing seed, the aim is to create a light packing 
structure and vertex map connecting it to p. However, it
may not work out, the sub-complex may be too small or have
too few interiors. So, we build a linked list of the vertices
and failing formation of a light packing we save these to
residual_list for later inclusion in the "residual" light 
packing.

If a light packing is formed, we set entries of green_list to 
-nmbr for these verts. Caution: is assumed that each bdry vert has 
single 'fan' of neighbors inherited from parent (ie, don't have 
'cloning' to worry about); eg, redchain from 'build_grain_redlist'. 
Error returns NULL, but okay==1 means 'okay to continue'. */
{
  int i,j,k,m,v,w,indx,resid_count=0;
  int wflag=0,hits=1,vcount=0,icount=0,tick=1;  
  struct Vertlist *list,*gtrace,*trace,*vertlist;
  struct Vertlist *resid_list=NULL,*strace;
  struct RedList *rtrace;
  struct p_light *pl=NULL;
  struct K_data *pK_ptr;
  extern struct Vertlist *residual_list,*residual_ptr;
  extern int residual_count;
  
  pK_ptr=p->packK_ptr;
  resid_list=strace=(struct Vertlist *)
    calloc((size_t)1,sizeof(struct Vertlist));
  *okay=0;
  pl=(struct p_light *)calloc((size_t)1,sizeof(struct p_light));
  pl->counts=(int *)calloc((size_t)5,sizeof(int));
  pl->counts[1]=(int)p->hes;

  for (i=1;i<=p->nodecount;i++) pK_ptr[i].util_flag=0;

  /* count and mark bdry = outside of red chain. Build list of 
possible residuals so if this build fails, they can be marked 
for exculsion from next attempt yet not overlooked for the residual
packing. */

  rtrace=*redlist;
  wflag=0;
  while (rtrace!=(*redlist) || !(wflag++))
    {
      indx=nghb_tri(p,rtrace->next->face,rtrace->face);
      v=p->faces[rtrace->face].vert[indx];
      if (!pK_ptr[v].util_flag) 
	{
	  pK_ptr[v].util_flag=-1;
	  if (*green_list)
	    {
	      if (!(*green_list)[v])
		{
		  strace->next=(struct Vertlist *)
		    calloc((size_t)1,sizeof(struct Vertlist));
		  strace=strace->next;
		  strace->v=v;
		  resid_count++;
		  /*
fprintf(stderr," grain_count %d, r_count %d, v %d, residual_list %d\n",
grain_count,resid_count,v,(int)residual_list);*/
		}
	      (*green_list)[v]=-nmbr;
	    }
	}
      rtrace=rtrace->next;
    }
  
  /* mark and index interior starting from seed using dynamic linked 
     lists. Start at seed, but if it's bdry, try to find interior
     by first going around the 'left' side of redchain. */

  if (pK_ptr[seed].util_flag || pK_ptr[seed].bdry_flag) /* seed is one of bdry */
    {
      rtrace=*redlist;
      wflag=0;
      while (rtrace!=(*redlist) || !(wflag++))
	{
	  indx=nghb_tri(p,rtrace->face,rtrace->next->face);
	  v=p->faces[rtrace->face].vert[indx];
	  if (!pK_ptr[v].util_flag && !pK_ptr[v].bdry_flag) 
	    {
	      seed=v;
	      break;
	    }
	  rtrace=rtrace->next;
	}
    }
  if (pK_ptr[seed].util_flag || pK_ptr[seed].bdry_flag) /* seed is still bdry */
    {
      *okay=-1;
      vert_free(&resid_list);
      return NULL;
    }

  list=(struct Vertlist *)
    calloc((size_t)1,sizeof(struct Vertlist));
  list->v=seed;
  if (*green_list)
    {
      if (!(*green_list)[seed])
	{
	  strace->next=(struct Vertlist *)
	    calloc((size_t)1,sizeof(struct Vertlist));
	  strace=strace->next;
	  strace->v=seed;
	  resid_count++;
	  /*
fprintf(stderr,"2 grain_count %d, r_count %d, v %d, residual_list %d\n",
grain_count,resid_count,seed,(int)residual_list);*/
	}
      (*green_list)[seed]=-nmbr;
    }
  pK_ptr[seed].util_flag=1;
  hits=0;
  while (!hits && list)
    {
      hits=1;
      vertlist=list;
      list=gtrace=
	(struct Vertlist *)calloc((size_t)1,sizeof(struct Vertlist));
      do
	{
	  v=vertlist->v;
	  for (i=0;i<=pK_ptr[v].num;i++)
	    if (!pK_ptr[(w=pK_ptr[v].flower[i])].util_flag
		&& !pK_ptr[w].bdry_flag)
	      {
		if (*green_list)
		  {
		    if (!(*green_list)[w])
		      {
			strace->next=(struct Vertlist *)
			  calloc((size_t)1,sizeof(struct Vertlist));
			strace=strace->next;
			strace->v=w;
			resid_count++;
			/*
fprintf(stderr,"3 grain_count %d, r_count %d, v %d, residual_list %d\n",
grain_count,resid_count,w,(int)residual_list);*/
		      }
		    (*green_list)[w]=-nmbr;
		  }
		pK_ptr[w].util_flag=1; /* mark as interior */
		gtrace=gtrace->next=(struct Vertlist *)
		  calloc((size_t)1,sizeof(struct Vertlist));
		gtrace->v=w;
		hits=0;
	      }
	  trace=vertlist;
	  vertlist=vertlist->next;
	  free(trace);
	}  
      while (vertlist);
      gtrace=list;
      list=list->next; /* first position was empty */
      free(gtrace);
    } /* end of while */

  /* Decide whether to create light pack. At this point, bdry vers
     marked with util_flag=-1, interior with util_flag=1. Need to
     find size, create 'var_indices' block, set util_flag to new index */

  for (i=1;i<=p->nodecount;i++)
    if (pK_ptr[i].util_flag>0) /* interior */
      {
	icount++;
	pK_ptr[i].util_flag=icount;
	pl->counts[3] += pK_ptr[i].num+1;
      }
  if (icount<n) /* not big enough; attach resid_list verts to global
		   residual_list */
    {
      *okay=1;
      strace=resid_list;
      resid_list=resid_list->next; 
      free(strace);
      residual_ptr=resid_list;  /* attach to global list */
      if (!residual_list) /* create residual_list */
	residual_list=resid_list;
      while (residual_ptr->next) residual_ptr=residual_ptr->next;
      residual_count += resid_count;
      goto CLEAN_UP;
    }

/* ------- Yes, store info for light pack */

  vert_free(&resid_list);
  pl->var_indices=(int *)calloc((size_t)(pl->counts[3]+1),sizeof(int));
  pl->counts[2]=icount; 

  /* count and mark verts neighboring interiors. */

  for (i=1;i<=p->nodecount;i++) 
    if (pK_ptr[i].util_flag<0) pK_ptr[i].util_flag=0; /* get rid of orig
							 bdry markings */
  vcount=icount;
  for (i=1;i<=p->nodecount;i++) /* mark as bdry only those next to interior */
    if (pK_ptr[i].util_flag>0)
      for (j=0;j<=pK_ptr[i].num;j++)
	if (!pK_ptr[pK_ptr[i].flower[j]].util_flag)
	  {
	    vcount++;
	    pK_ptr[pK_ptr[i].flower[j]].util_flag=-vcount;
	  }

  pl->counts[0]=vcount; /* total nodecount */

  pl->radii=(double *)
    calloc((size_t)(pl->counts[0]+1),sizeof(double));

  pl->orig_indices=(int *)calloc((size_t)(pl->counts[0]+1),sizeof(int));
  for (i=1;i<=p->nodecount;i++)
    {
      k=pK_ptr[i].util_flag;
      if (k>0) /* interior */
	{
	  pl->var_indices[tick++]=pK_ptr[i].num;
	  /* create flower list. Note: every flower should be
	     interior, so don't record the redundant last petal index. */
	  for (j=0;j<pK_ptr[i].num;j++)
	    {
	      w=pK_ptr[i].flower[j];
	      if (!(m=pK_ptr[w].util_flag)) 
		goto SCREWUP; /* every petal should be an interior or 
				 bdry, hence >0 or <0 util_flag, resp. */
	      m = (m<0) ? -m : m;
	      pl->var_indices[tick++] = m;
	    }
	  pl->radii[k]=p->packR_ptr[i].rad;
	  pl->orig_indices[k]=i;
	}
      else if (k<0) /* bdry */
	{
	  pl->radii[-k]=p->packR_ptr[i].rad;
	  pl->orig_indices[-k]=i;
	}
    }
  /* success */
  *okay=seed;
  pl->counts[4]=p->nodecount;
  return pl; 

 SCREWUP:
  *okay=0;
 CLEAN_UP:
  free_p_light(&pl);
  return NULL;
} /* extract_light_pack */
