#include "cp_types.h"
#include "cp_proto.h"

/* Convert data from an existing p_light structure (to the extent 
   possible) and put in existing packing p. If flag is set, data is
   for the existing packing (only verify that CHECK_COUNT and hes
   from p_light correspond to p); use 'orig_indices' of p_light pack 
to send data to the right spots. 
   Otherwise, clean out p and create a new packing from p_light data. 
   (I don't know what will happen if the combinatorics of p_light are 
   too stange.) 
   Return 0 on error and flush out p or return pl vertcountt. */

extern int try_contig_pair(),add_to_flower();
int *new_flower,*bit_flower,eptr;

int convert_from_p_light(struct p_data *p,struct p_light *pl,int flag)
{
  int i,j,k,n,u,v,w,m,indx,*iptr,bdry_count,var_count,num;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  if (flag) /* soes this match the size and geometry of p */
    {
      pR_ptr=p->packR_ptr;
      if (!p->status || pl->counts[4]==0 
	  || pl->counts[4]!=p->nodecount
	  || ((pl->counts[1]>0 && p->hes<=0)
	      || (pl->counts[1]==0 && p->hes!=0)
	      || (pl->counts[1]>0 && p->hes<=0)))
	return 0;
      /* read in new radii */
      for (i=1;i<=pl->counts[0];i++)
	pR_ptr[pl->orig_indices[i]].rad=pl->radii[i];
      if (pl->counts[5]>0) /* also have some aims specified in pl */
	{
	  for (i=1;i<=pl->counts[5];i++)
	    p->packR_ptr[pl->orig_indices[pl->aim_indices[i]]].aim
	      =pl->aims[i];
	}
      return pl->counts[0];
    }
  
  /* need to clear packing and enter new data */
  if (!p || !alloc_pack_space(p,pl->counts[0]+1,0))
    return 0;
  pK_ptr=p->packK_ptr;
  pR_ptr=p->packR_ptr;
  p->nodecount=pl->counts[0];
  var_count=pl->counts[2];
  bdry_count=pl->counts[0]-var_count;

  /* build flowers of 'variable' verts first (these are given
     explicitly in p_light 'var_indices' list. */
  iptr=pl->var_indices+1;
  for (i=1;i<=var_count;i++)
    {
      pK_ptr[i].num=*(iptr++);
      pK_ptr[i].flower=(int *)calloc((size_t)(num+1),sizeof(int));
      for (j=0;j<=pK_ptr[i].num;j++)
	pK_ptr[i].flower[j]=*(iptr++); 
      pR_ptr[i].rad=pl->radii[i];
    }
  if (!bdry_count) /* done: there are no 'fixed' verts */
    goto GOBACK;

  /* flowers for 'fixed' verts have to be reconstructed. First,
     we count how often each occurs in variable flowers */

  for (i=var_count+1;i<=p->nodecount;i++)
    pK_ptr[i].num=-1;
  for (k=1;k<=var_count;k++)
    {
      for (j=0;j<pK_ptr[k].num;j++)
	if ((m=pK_ptr[k].flower[j])>var_count) /* petal is 'fixed' */
	  pK_ptr[m].num++;
      if ((m=pK_ptr[k].flower[pK_ptr[k].num])>var_count
	  && m!=pK_ptr[k].flower[0]) /* last petal is 'fixed' and flower
					is open (so not already included */
	pK_ptr[m].num++;
    }
  /* might as well toss any 'fixed' having no neighbors. */
  num=0;
  for (i=var_count+1;i<=p->nodecount;i++)
    if (pK_ptr[i].num<0) 
      {
	for (v=1;v<=var_count;v++) /* look through all var verts */
	  for (j=0;j<=pK_ptr[v].num;j++)
	    if ((w=pK_ptr[v].flower[j])>i)
	      pK_ptr[v].flower[j]--; 
	num++;
      }
  bdry_count -= num;
  p->nodecount -= num;
	
  /* now create the flowers (without regard to petal order)
     Note: will only have 'var' petals for now. */
  for (w=var_count+1;w<=p->nodecount;w++)
    {
      pK_ptr[w].flower=iptr=(int *)
	calloc((size_t)(pK_ptr[w].num),sizeof(int));
      for (v=1;v<=var_count;v++)
	{
	  if (w==pK_ptr[v].flower[pK_ptr[v].num] 
	      && w!=pK_ptr[v].flower[0])
	    *(iptr++)=v;
	  for (j=0;j<pK_ptr[v].num;j++)
	    if (w==pK_ptr[v].flower[j])
	      {
		*(iptr++)=v;
		j=pK_ptr[v].num; /* kick out of for loop */
	      }
	}
    }

  /* might as well toss any 'fixed' w having only one petal */
  for (w=var_count+1;w<=p->nodecount;i++)
    if (pK_ptr[w].num==0) 
      {
	v=pK_ptr[w].flower[0];
	if ((num=pK_ptr[v].num)<=1 ||
	    (num==2 && pK_ptr[v].flower[0]==pK_ptr[v].flower[num]))
	  goto BOMB; /* would be only one petal left */
	if (pK_ptr[v].flower[0]==pK_ptr[v].flower[num]) /* closed */
	  {
	    indx=nghb(p,v,w);
	    if (indx==0)
		for (j=0;j<num-1;j++)
		  pK_ptr[v].flower[j]=pK_ptr[v].flower[j+1];
	    else
	      {
		new_flower=(int *)
		  calloc((size_t)(num-1),sizeof(int));
		n=0;
		for (k=indx+1;k<=num;k++)
		  new_flower[n++]=pK_ptr[v].flower[k];
		for (k=1;k<indx;k++)
		  new_flower[n++]=pK_ptr[v].flower[k];
		free(pK_ptr[v].flower);
		pK_ptr[v].flower=new_flower;
	      }
	    pK_ptr[v].num = num-2;
	  }
	else /* v's flower not closed */
	  {
	    indx=nghb(p,v,w);
	    for (k=indx+1;k<=num;k++)
	      pK_ptr[v].flower[k]=pK_ptr[v].flower[k+1];
	    pK_ptr[v].num=num-1;
	  }
	/* now remove vert w and adjust for its loss */
	for (v=1;v<=p->nodecount;v++) 
	  for (j=0;j<=pK_ptr[v].num;j++)
	    if ((m=pK_ptr[v].flower[j])>w) pK_ptr[v].flower[j]=m-1;
	for (i=w;i<p->nodecount;i++)
	  pK_ptr[i].flower=pK_ptr[i+1].flower;
	p->nodecount--;
      }
  
  /* now the hard part: recreate the flowers of the remaining 'fixed' 
     verts. */
      
  for (w=var_count+1;w<=p->nodecount;w++) /* consider fixed w */
    {
      num=pK_ptr[w].num; /* this will change */
      new_flower=(int *)
	calloc((size_t)(3*(pK_ptr[w].num+2)),sizeof(int));
      bit_flower=(int *)
	calloc((size_t)(3*(pK_ptr[w].num+2)),sizeof(int));
      eptr=0;

      /* will first find all the other 'fixed' that should be
	 nghbs of w (because they're nghbs of w in a flower of
	 some variable vert v) */

      for (j=0;j<=pK_ptr[w].num;j++)
	{
	  v=pK_ptr[w].flower[j];
	  indx=nghb(p,v,w);
	  if (indx==0 && (u=pK_ptr[v].flower[1])>var_count)
	    add_to_flower(p,w,u);
	  else 
	    if (indx==pK_ptr[v].num && (u=pK_ptr[v].flower[num-1])>var_count)
	      add_to_flower(p,w,u);
	  else
	    {
	      add_to_flower(p,w,pK_ptr[v].flower[indx-1]);
	      add_to_flower(p,w,pK_ptr[v].flower[indx+1]);
	    }
	}
	    
      /* build new_flower from chunks of flower, copied over as 
	 they fit in oriented fashion; mark in bit_flower those
	 verts of new_flower which have been added to new_flower. 
	 Have to look to variable nghbs of w to find consecutive
	 petals for w; after the first pair is copied over, add 
	 to either end, keep track of growing size with eptr. */

      for (n=1;n<=pK_ptr[w].num;n++)
	{
	  /* search for a contig pair to move to new_flower
	     (just once); after that contig pair for which 
	     one can be adjoined to those already there. */
	  for (j=0;j<=pK_ptr[w].num;j++)
	    {
	      v=pK_ptr[w].flower[j];
	      indx=nghb(p,v,w);
	      if (indx==0)
		{
		  try_contig_pair(p,w,pK_ptr[v].flower[1],v);
		  if (v==pK_ptr[v].flower[pK_ptr[v].num])
		    try_contig_pair(p,w,v,pK_ptr[v].flower[pK_ptr[v].num-1]);
		}
	      else if (indx==pK_ptr[v].num)
		try_contig_pair(p,v,pK_ptr[v].flower[indx-1]);
	      else 
		{
		  try_contig_pair(p,w,v,pK_ptr[v].flower[indx-1]);
		  try_contig_pair(p,w,pK_ptr[v].flower[indx+1],v);
		}
	    }
	}
      for (k=0;k<pK_ptr[w].num;k++)
	if (!eptr || !bit_flower[k]) /* missed one or more ==> some 
					inconsistent around w; error */
	  {
	    free(new_flower);
	    free(bit_flower);
	    goto BOMB;
	  }
      pK_ptr[w].num=eptr-1;
      free(pK_ptr[w].flower);
      pK_ptr[w].flower=(int *)
	calloc((size_t)(pK_ptr[w].num+1),sizeof(int));
      for (j=0;j<=pK_ptr[w].num;j++)
	pK_ptr[w].flower[j]=new_flower[j];
      free(new_flower);
    } /* end of for loop on 'fixed' w */    

  /* should be done now --- though I can't garantee that there
     aren't combinatoric/oientation/connectivity inconsistencies. */

    GOBACK:
      if (!complex_count(p,0) || !facedraworder(p,0) 
	  || !fillcurves(p) || set_aim_default(p))
	goto BOMB;
      if (pl->counts[5]>0) /* some aims given in pl */
	for (i=1;i<=pl->counts[5];i++)
	  pR_ptr[pl->aim_indices[i]].aim=pl->aims[i];
      return pl->counts[0];

 BOMB:
      alloc_pack_space(p,5000,0); /* clean out any corruption */
      p->status=0;
      return 0;
      
} /* convert_from_p_light */

/* ----------------- local utility routines ----------------- */  

int add_to_flower(struct p_data *p,int w, int u)
{
  int j,num;

  num=p->packK_ptr[w].num;
  for (j=0;j<=num;j++) if (p->packK_ptr[w].flower[j]==u) return 0;
  p->packK_ptr[w].flower[num+1]=u;
  p->packK_ptr[w].num++;
  return num+1;
}

int try_contig_pair(struct p_data *p,int w,int vi,int vj)
     /* Return 1 on success: first pair, or vert to add at
	begin or end. */    
{
  int i,j,k;

  if ((i=nghb(p,w,vi))<0 || (j=nghb(p,w,vj))<0) return 0;
  if (!eptr) /* first pair to new_flower */
    {
      new_flower[0]=p->packK_ptr[w].flower[i];
      new_flower[1]=p->packK_ptr[w].flower[j];
      eptr += 2;
      bit_flower[i]=bit_flower[j]=1;
      return 1;
    }
  if (vj==new_flower[0]) /* shift and add vi at front. */
    {
      for (k=eptr-1;k>=0;k--)
	new_flower[k+1]=new_flower[k];
      new_flower[0]=vi;
      eptr++;
      bit_flower[i]=1;
      return 1;
    }
  else if (vi==new_flower[eptr-1]) /* add vj at end */
    {
      new_flower[eptr++]=vj;
      bit_flower[j]=1;
      return 1;
    }
  return 0;
} /* try_contig_pair */

  
