/* complex_math.c   file of complex arithmetic and utility routines */
/* cc complex_math.c -o complex_math.o -g -c -lm */

#include "cp_types.h"

double cAbs(complex z)
{
  double ans;
  ans=sqrt(z.re*z.re + z.im*z.im);
  return (ans);
} 

complex cadd(complex z1,complex z2)
{
  complex z;
  z.re=z1.re+z2.re;
  z.im=z1.im+z2.im;
  return (z);
}

complex cmult(complex z1,complex z2)
{
  complex z;
  z.re=z1.re*z2.re-z1.im*z2.im;
  z.im=z1.re*z2.im+z2.re*z1.im;
  return (z);
}

complex csub(complex z1,complex z2)
{
  complex z;
  z.re=z1.re-z2.re;
  z.im=z1.im-z2.im;
  return (z);
}

complex cconj(complex z1)
{
  complex z;
  z.re=z1.re;
  z.im=(-z1.im);
  return (z);
}

complex cdiv(complex z1,complex z2)
{
  complex z;
  double av;

  if ((av=z2.re*z2.re+z2.im*z2.im)==0) return (z1); /* error */
  av = 1/av;
  z=cmult(z1,cconj(z2));
  z.re=av*z.re;
  z.im=av*z.im;
  return (z);
}

double Arg(complex w)
{
  double s;

  if (w.re==0)
    {
      if (w.im==0) return (0.0);
      if (w.im>0) return (M_PI_2);
      return (-M_PI_2);
    }
  else if (w.im==0)
    {
      if (w.re>0) return (0.0);
      return (M_PI);
    }
  s=(double)atan((double)(w.im/w.re));
  if (w.re<0)
    {
      if (w.im>0) return (M_PI+s);
      return (s-M_PI);
    }
  return (s);
} 

complex cexp(double r,double t)
     /* returns complex r*e^(it) */
{
  complex w;
  w.re=r*cos(t); w.im=r*sin(t);
  return (w);
}

complex cLog(complex w)
{
  complex z;
  z.im=Arg(w); z.re=log(cAbs(w));
  return (z);
}

double EpsMach(void) 
     /* Utility suggested by Monica Hurdal: determine machine precsion,
	return (?? I'm still trying to find the right balance here;
	square root was what Monica suggested, but that's too large
	in general ??? ) for use in minimizing calculation errors. */
{
  double eps, factor=1000.0;
  
  eps = 1.0;
  eps = eps /2.0;
  while (1.0 != (eps+1.0)) eps = eps/2.0;
  /*  return sqrt(eps); */
  return (factor*eps);
} /* EpsMach */


