#include "cp_types.h"
#include "cp_proto.h"

/* How accurately do red faces get laid out using red chain 
(recompute as you go along), and how close end is to start?
Append results to /tmp/diagnostic_log */

double check_red_layout(struct p_data *p)
{
  int f,vert,worst=0,wflag=0,count=1,debug=0,v,n0,indx;
  double max_err=0.0,lerr,err;
  complex begin_ctr,end_ctr;
  struct RedList *trace;
  FILE *diagfp;

  if (!p->redfaces
      || !(diagfp=fopen("/tmp/diagnostic_log","a"))) return 0;
  fprintf(diagfp,"\n\nCheck red faces layout:   ");
  worst=p->redfaces->face;
  v=p->faces[worst].vert[(indx=(p->faces[worst].index_flag+2)%3)];
  n0=nghb(p,v,p->faces[worst].vert[(indx+1)%3]);
  fancy_comp_center(p,v,n0,n0,1,0,1,1,toler);
  vert=p->faces[p->redfaces->face].
    vert[p->redfaces->v_flag];
  begin_ctr=p->packR_ptr[vert].center; /* compare later to where
					  this circle gets placed
					  at the end of layout */
  trace=p->redfaces;
  while ((trace=trace->next)!=p->redfaces->next || !(wflag++))
    {
      f=trace->face;
      lerr=0.0;
      v=p->faces[f].vert[(indx=trace->v_flag)];
      n0=nghb(p,v,p->faces[f].vert[(indx+1)%3]);
      fancy_comp_center(p,v,n0,n0,1,0,1,1,toler);
      lerr= fabs(invdist_err(p,p->faces[f].
	vert[(trace->v_flag+1) % 3],p->faces[f].vert[(trace->v_flag+2) % 3]));
      err= fabs(invdist_err(p,p->faces[f].
	vert[(trace->v_flag+2) % 3],p->faces[f].vert[trace->v_flag]));
      lerr=(err>lerr) ? err : lerr;
      err= fabs(invdist_err(p,p->faces[f].
	vert[trace->v_flag],p->faces[f].vert[(trace->v_flag+1) % 3]));
      lerr=(err>lerr) ? err : lerr;
      if (lerr>max_err)
	{
	  max_err=lerr;
	  worst=f;
	  if (debug) 
	    {
	      draw_any_face(p,trace->face,33,FG_COLOR,FG_COLOR,1);
	      draw_any_circle(p,p->faces[trace->face].
			      vert[(trace->v_flag+1) % 3],33,1,1,1);
	      draw_any_circle(p,p->faces[trace->face].
			      vert[(trace->v_flag+2) % 3],33,1,1,1);
	      draw_any_circle(p,p->faces[trace->face].
			      vert[trace->v_flag],35,1,1,1);
	      fprintf(stderr," plotted vert = %d\n",p->faces[trace->face].
		      vert[(trace->v_flag+2) % 3]);
	      draw_any_face(p,trace->prev->face,33,FG_COLOR,FG_COLOR,1);
	      debug=0;
	    }
	}
      count++;
    }
  end_ctr=p->packR_ptr[vert].center;
  fprintf(diagfp,"\n   Worst face is index %d, with error %f."
	  "\n   Difference in placement of center of first/last "
	  "vertex (index %d) is %f.",
	  worst,max_err,vert,cAbs(csub(begin_ctr,end_ctr)));
  fclose(diagfp);
  return max_err;
} /* check_red_layout */

