#include "cp_types.h"
#include "cp_proto.h"

/* Note user has to set color_ramp_size, default generally COLOR_RAMP.
Here we set up color ramp, starting with dark blue, ending with dark red. 
Index color_ramp_size/2 is white. If flag, do ramp only, and not the
'other' colors; caution, other colors are specified based on 
color_ramp_size=200. */

extern unsigned char red[],green[],blue[];
extern int color_ramp_size;

int blue_to_red_ramp(int flag)
{
  int i,mid,col_factor=0;

  if ((mid=(int)(color_ramp_size/2.0))>0)
    {
      col_factor=(int)(255.0/mid);
      /* blue ramp */
      for (i=0;i<mid;i++)
	{blue[i]=255;red[i]=green[i]=i*col_factor;}
      /* middle is white */
      blue[mid]=red[mid]=green[mid]=255;
      /* red ramp */
      for (i=mid+1;i<2*mid;i++)
	{red[i]=255;blue[i]=green[i]=255-(i-mid)*col_factor;}
      if (flag) return 1;
    }
  else if (flag) return 1;

  if (mid<1) mid=1;
  
  /* Some mixed colors for filler */
  for (i=2*mid;i<210;i++) 
    {red[i]=green[i]=blue[i]=255-255*((int)((i-2*mid)/(210-2*mid)));}
  for (i=231;i<255;i++)
    {red[i]=0;green[i]=blue[i]=255-10*(i-230);}
  /* additional colors by Monica Hurdal */

  red[201]=255;green[201]=200;blue[201]=200; /* light pink */
  red[202]=200;green[202]=225;blue[202]=255; /* light blue */
  red[203]=200;green[203]=255;blue[203]=200; /* light green */
  red[204]=255;green[204]=230;blue[204]=200; /* light orange */
  red[205]=180;green[205]=180;blue[205]=240; /* light purple */
  red[206]=50;green[206]=128;blue[206]=50;   /* dark green */
  red[207]=128;green[207]=50;blue[207]=128;  
  red[208]=203;green[208]=255;blue[208]=102;
  red[209]=255;green[209]=255;blue[209]=0;   /* yellow */
  red[210]=255;green[210]=0;blue[210]=0;     /* red */
  red[211]=245;green[211]=94;blue[211]=0;    /* orange ramp: very dark */
  red[212]=255;green[212]=146;blue[212]=29;  /* orange ramp: dark */
  red[213]=255;green[213]=159;blue[213]=56;  /* orange ramp: medium */
  red[214]=255;green[214]=172;blue[214]=84;  /* orange ramp: light */
  red[215]=255;green[215]=185;blue[215]=110; /* orange ramp: lighter */
  red[216]=255;green[216]=204;blue[216]=152; /* orange ramp: lighter */
  red[217]=255;green[217]=218;blue[217]=178; /* orange ramp: very light */
  red[218]=0;green[218]=255;blue[218]=0;     /* bright green */
  red[219]=34;green[219]=139;blue[219]=34;
  red[220]=64;green[220]=224;blue[220]=208;
  red[221]=0;green[221]=255;blue[221]=255;   /* cyan */
  red[222]=135;green[222]=206;blue[222]=250;
  red[223]=95;green[223]=158;blue[223]=160;
  red[224]=205;green[224]=133;blue[224]=63;
  red[225]=160;green[225]=82;blue[225]=45;
  red[226]=235;green[226]=110;blue[226]=100;
  red[227]=255;green[227]=140;blue[227]=0;   /* orange */
  red[228]=221;green[228]=160;blue[228]=221;
  red[229]=185;green[229]=48;blue[229]=185;
  red[230]=205;green[230]=205;blue[230]=205; /* light grey */
  red[231]=50;green[231]=50;blue[231]=50;    /* dark grey */
  red[232]=128;green[232]=128;blue[232]=128; /* grey */
  red[233]=66;green[233]=138;blue[233]=66;   /* forest green */
  red[234]=0;green[234]=0;blue[234]=255;     /* blue */
  red[235]=255;green[235]=0;blue[235]=255;   /* magenta (pink) */
  red[236]=234;green[236]=138;blue[236]=0;   /* orange */
  red[237]=160;green[237]=80;blue[237]=0;    /* brown */
  red[238]=0;green[238]=0;blue[238]=0;       /* black */
  red[239]=178;green[239]=0;blue[239]=255;   /* purple */
  return 1;
} /* blue_to_red_ramp */
