#include "cp_types.h"
#include "cp_proto.h"

/* apply Mobius Mob (flag==1), or inverse (flag==-1) to
specified list of circles. Note: iff "a" is specified and redfaces exist,
then adjust red list centers/pair_mob also. */

int apply_Mobius(struct p_data *p,char *datastr,int flag,Mobius Mob)
{
  int v,hits,wflag=0,rflg=0,count=0,n;
  double R;
  complex Z;
  char *endptr,*tptr;
  struct Vertlist *vertlist,*trace;
  struct RedList *rtrace;
  struct R_data *pR_ptr;

  if ((n=strlen(datastr))>0)
    {
      tptr=(char *)calloc((size_t)(n+2),sizeof(char));
      strcpy(tptr,datastr);
      stripsp(tptr);
    }
  else 
    {
      tptr=(char *)calloc((size_t)2,sizeof(char));
      tptr[0]='a';tptr[1]='\0';
      rflg=1;
    }
  if (*tptr=='a' && *(tptr+1)!='(') rflg=1;
  if ( !(vertlist=Node_link_parse(p,tptr,&endptr,&hits,
		  &Vlist,&Elist,&Flist,&region,pathlist,pathlength)))
    {free(tptr);return 0;}
  pR_ptr=p->packR_ptr;
  trace=vertlist;
  do 
    {
      v=trace->v;
      count += mobius_of_circle(Mob,p->hes,pR_ptr[v].center,pR_ptr[v].rad,
	       &Z,&R,flag);
      if (p->hes==0 && R<0) R=fabs(R);
      pR_ptr[v].center=Z;
      pR_ptr[v].rad=R;
      trace=trace->next;
    } while (trace!=NULL);
  vert_free(&vertlist);

  /* fix centers in redlist, too */
  if (rflg && (rtrace=p->redfaces)) 
    while (rtrace!=p->redfaces || !(wflag++))
      {
	v=p->faces[rtrace->face].vert[rtrace->v_flag];
	mobius_of_circle(Mob,p->hes,rtrace->center,rtrace->rad,
	       &Z,&R,flag);
	if (p->hes==0 && R<0) R=fabs(R);
	rtrace->center=Z;
	rtrace->rad=R;
	rtrace=rtrace->next;
      }

  /* fix side-pairing mobius transforms also */
  if (p->hes<=0 && rflg && p->edge_pair[2].edge)
    update_pair_mob(p);
  /* fixup: side-pairing transforms not yet implemented */
  free(tptr);
  return count;
} /* apply_Mobius */








