/* pack_types.h		type declarations for basic packing data structures.
For use with CirclePack routines. 		 		1/98 */

#define float double

typedef struct
 {
	int vert[3];		/* ordered triple of vertices */
	int index_flag;		/* which to draw first, 0,1, or 2 */
	int next_face;		/* next face in drawing order. */
	int rwb_flag;		/* red/white/blue faces:0=white,1=red,2=blue
				   see info file for description */
	int next_red;		/* next red face */
	int plot_flag;		/* useful flag */
	int color;		/* color index */
	int mark;		/* mark */
  } f_data;

/*==================== structure for circle data ====================*/

struct K_data
 {
	int num;                /* number of faces this node is in.*/
				/* 'flower' has entries from 0 to num */
	int bdry_flag; 		/* true for boundary nodes */
	int plot_flag;		/* true if node has been plotted - used
				   when circles are being plotted */
	int *flower;		/* ptr to list of nodes in flower;
				   in positive orientation, last = first if
				   flower is closed */
	float *overlaps;	/* cosine of overlap angle or inv dist */
	int color;		/* gives color value, 0=background */
	int mark;		/* mark */
 };

struct R_data
 {
	complex center;		/* center as complex number */
	float rad;		/* radius of circle for this node. 
				   hyperbolic case: called 's_radius' for 
				   special. exp(-r) is stored for
				   finite radii; for infinite hyp radius,
				   we store the negative of the eucl radius
				   (can then use eucl data for plotting). */
	float curv;		/* angle sum at this vertex. */
	float aim;		/* desired curvature at this vertex */
 };


/* ==================== structure for pack data ====================*/

struct p_data
 {
	int status;		/* 0 if pack empty, 1 otherwise */
	char fhead[64];		/* pack header <= 40 char*/
	char file_name[NAME_MAX]; /* filename when file was written */
	int hes;		/* curvature of geometry,-1=hyp,0=eucl,1=sph */
	struct K_data *packK_ptr;	/* pointer to corres complex data */
	struct R_data *packR_ptr;	/* pointer to corres rad data */
	int sizelimit;		/* max number of node space allocated */
	int nodecount;		/* number of nodes */
	int facecount;		/* number of faces = 1+edges-nodes */
	int intnode;		/* number of interior nodes */
	int num_bdry_comp;	/* number of bdry components */
	int num_int_comp;	/* number of components of interior verts */
	int bdry_starts[MAX_COMPONENTS+1];	
				/* indices for nodes marking bdry components */
	int int_starts[MAX_COMPONENTS+1];	
				/* indices of nodes marking int components */
	int first_face;		/* index of first face to plot */
	int first_red_face;	/* index of "red" chain of faces */
	int beta;		/* index of beta node (on boundary) */
	int alpha;		/* index of alpha node (origin) */
	int gamma;		/* index of node to be plotted on y>0 axis */
	int euler;		/* Euler characteristic */
	int genus;		/* genus of complex. Euler+#bdry=2-2g */
	int active_node;	/* currently active_node */
	int locks;		/* locks placed by remote processes;
					bitwise flags */
	int overlap_status;	/* true if some non-trivial overlaps set */
	f_data *faces;		/* pointer to face data */
	struct s_data *screen;	/* pointer to screen for display */
 };
