
// I stole this from fdisk
struct systypes {
	unsigned char index;
	char *name;
	} sys_types[] = {
		{0, "Empty"},
		{1, "DOS 12-bit FAT"},
		{2, "XENIX root"},
		{3, "XENIX usr"},
		{4, "DOS 16-bit <32M"},
		{5, "Extended"},
		{6, "DOS 16-bit >=32M"},
		{7, "OS/2 HPFS"},		/* or QNX? */
		{8, "AIX"},
		{9, "AIX bootable"},
		{10, "OPUS"},
		{0x40, "Venix 80286"},
		{0x51, "Novell?"},
		{0x52, "Microport"},		/* or CPM? */
		{0x63, "GNU HURD"},		/* or System V/386? */
		{0x64, "Novell"},
		{0x75, "PC/IX"},
		{0x80, "Old MINIX"},		/* Minix 1.4a and earlier */
		{0x81, "Linux/MINIX"}, /* Minix 1.4b and later */
		{0x82, "Linux swap"},
		{0x83, "Linux native"},
		{0x93, "Amoeba"},
		{0x94, "Amoeba BBT"},		/* (bad block table) */
		{0xb7, "BSDI fs"},
		{0xb8, "BSDI swap"},
		{0xc7, "Syrinx"},
		{0xdb, "CP/M"},			/* or Concurrent DOS? */
		{0xe1, "DOS access"},
		{0xe3, "DOS R/O"},
		{0xf2, "DOS secondary"},
		{0xff, "unknown"}		/* Bad Track Table */
	};


char* parttype(int nr)
{
	int i;
	
	for(i=0;sys_types[i].index!=0xff;i++){
		if(sys_types[i].index==nr)
			break;
	}
	return sys_types[i].name;
};

void print_types(void)
{
	int	i;
	
	printf("Known partition types:\n");
	for(i=0;sys_types[i].index!=0xff;i++)
		printf(" 0x%02x:\t%s\n",sys_types[i].index,sys_types[i].name);
}