/* GNU Chess 5.0 - cmd.c - command parser
   Copyright (c) 1999 Free Software Foundation, Inc.

   GNU Chess is based on the two research programs 
   Cobalt by Chua Kong-Sian and Gazebo by Stuart Cracraft.

   GNU Chess is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GNU Chess is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Chess; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     bug-gnu-chess@gnu.org
     cracraft@ai.mit.edu, cracraft@stanfordalumni.org, cracraft@earthlink.net
*/

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
#include "common.h"
#include "eval.h"
#ifdef UNIVERSAL
#include "univ.h"
#include <conio.h>
char fromboard[10];
#endif

#define prompt ':'

extern short stage, InChkDummy, terminal;
static char inputstr[80], cmd[80], s[80], logfile[80], 
            gamefile[80],resultstr[80];

char userinput[80],subcmd[80],setting[80],subsetting[80];


#ifdef UNIVERSAL
void univ_check (int signal_type)
{
/*
  printf("Univ_check entry: Set alarm to come back to univ_check\n");
*/
  if (univ_read(fromboard)) {
    printf("Read %s from Universal.\n",fromboard);
    if (strcmp(fromboard,"J") == 0) strcpy(fromboard,"go");
    else if (strcmp(fromboard,"N") == 0) strcpy(fromboard,"new");
    else if (strcmp(fromboard,"T") == 0) strcpy(fromboard,"undo");
  }
  alarm(1);
}
#endif

void InputCmd ()
/*************************************************************************
 *
 *  This is the main user command interface driver.
 *
 *************************************************************************/
{
   char color[2][6] = { "White", "Black" };
   short suffix;
   int i;
   leaf *ptr; 
   int ncmds;
#ifdef UNIVERSAL
   char *p,c;
#endif

   CLEAR (flags, THINK);
/*   if (!(flags&SELF) || ((flags & SELF) && (flags & ENDED))) { */
#ifdef UNIVERSAL
  strcpy(userinput,'\000');
  strcpy(cmd,'\000');
  if (1) {
    if (flags & UNIV) {
      userinput[0] = '\000';
      p = userinput;
      if (kbhit()) {
        for (;;) {
	  c = getchar();
	  while (c != '\015' && c != '\012' && c != EOF) {
	    *p++ = c;
	    c = getchar();
	  }
	  *p = '\000';
	  break;
	}
      }
      if (strlen(fromboard) != 0) {
	strcpy(userinput,fromboard);
	fromboard[0] = '\0';
      }
      if (strlen(userinput) != 0) {
/*
        printf("userinput=%s\n",userinput);
*/
#else
	if (!(flags & XBOARD)) {
	  printf ("%s (%d) %c ", color[board.side], (GameCnt+1)/2 + 1, prompt);
	  fflush(stdout);
        }
	fgets (inputstr, 64, stdin);
/*NEW */
	inputstr[strlen(inputstr)-1] = '\000';
/*END NEW */
	cmd[0] = '\n';
	strcpy(userinput,inputstr);
	sscanf (inputstr, "%s %[^\n]", cmd, inputstr);
	if (cmd[0] == '\n')
	  return;
#endif
        ncmds = sscanf (userinput,"%s %s %s %s",cmd,subcmd,setting,subsetting);
#ifdef UNIVERSAL
        userinput[0] = '\000';
        printf ("%s (%d) %c ", color[board.side], (GameCnt+1)/2 + 1, prompt);
        fflush(stdout);
      }
    } else {
      printf ("%s (%d) %c ", color[board.side], (GameCnt+1)/2 + 1, prompt);
      fflush(stdout);
      gets(userinput);
      ncmds = sscanf (userinput,"%s %s %s %s",cmd,subcmd,setting,subsetting);
    }
  }
#endif
/*
  printf("cmd=%s,subcmd=%s,setting=%s,subsetting=%s\n",cmd,subcmd,setting,subsetting);
  fflush(stdout);
*/
  sprintf(inputstr,"%s %s %s",subcmd,setting,subsetting);
/*
  printf("inputstr=%s\n",inputstr);
   printf("cmd = %s, inputstr = %s, subcmd = %s\n",cmd,inputstr,subcmd);
*/
   if (strcmp (cmd, "quit") == 0 || strcmp (cmd, "exit") == 0)
      SET (flags, QUIT);
   else if (strcmp (cmd, "help") == 0)
      ShowHelp ();
   else if (strcmp (cmd, "show") == 0)
      ShowCmd (inputstr);
   else if (strcmp (cmd, "book") == 0) {
      sscanf (inputstr, "%s %[^\n]", cmd, inputstr);
printf("inputstr = %s\n",inputstr);
      if (strncmp (inputstr, "compile", 7) == 0) {
printf("calling genbook.\n");
        genbook ();
      } else if (strcmp (inputstr, "on") == 0) {
	bookmode = BOOKBEST;
	printf("book now on.\n");
      } else if (strcmp (inputstr, "off") == 0) {
	bookmode = BOOKOFF;
	printf("book now off.\n");
      }
   } else if (strcmp (cmd, "test") == 0)
      TestCmd (inputstr);
   else if (strcmp (cmd, "version") == 0)
      ShowVersion ();
   else if (strcmp (cmd, "pgnsave") == 0)
      PGNSaveToFile (inputstr);
   else if (strcmp (cmd, "pgnload") == 0)
      PGNReadFromFile (inputstr);
   else if (strcmp (cmd, "manual") == 0)
      SET (flags, MANUAL);
   else if (strcmp (cmd, "debug") == 0)
   {
      SET (flags, DEBUGG);
      Debugmvl = 0;
      if (strcmp (inputstr, "debug") == 0)
      {
         while (strcmp (inputstr, s))
         {
            sscanf (inputstr, "%s %[^\n]", s, inputstr);
            ptr = ValidateMove (s);
            Debugmv[Debugmvl++] = ptr->move;
            MakeMove (board.side, &ptr->move);
         } 
         i = Debugmvl;
         while (i)
         {
            UnmakeMove (board.side, &Debugmv[--i]);
         } 
      }
   }
   else if (strcmp (cmd, "force") == 0)
	SET (flags, MANUAL);
   else if (strcmp (cmd, "white") == 0)
	;
   else if (strcmp (cmd, "black") == 0)
	;
   else if (strcmp (cmd, "hard") == 0)
	;
   else if (strcmp (cmd, "easy") == 0)
	;
   else if (strcmp (cmd, "post") == 0)
	SET (flags, POST);
   else if (strcmp (cmd, "nopost") == 0)
	CLEAR (flags, POST);
   else if (strcmp (cmd, "name") == 0) {
      strcpy(name, inputstr);
      suffix = 0;
      for (;;) {
	sprintf(logfile,"log.%03d",suffix);
 	sprintf(gamefile,"game.%03d",suffix);
	if (access(logfile,F_OK) < 0) {
	  ofp = fopen(logfile,"w");
	  break;
	} else 
	  suffix++;
      }
   }
   else if (strcmp (cmd, "result") == 0) {
     if (ofp != stdout) {  
	fprintf(ofp, "result: %s\n",inputstr);
	fclose(ofp); 
	ofp = stdout;
        printf("Save to %s\n",gamefile);
        PGNSaveToFile (gamefile);
     }
#ifdef NEVER
     if (flags & XBOARD) {
	printf("tellics shout GNU 5.0 (Gazebo) ready to play!\n");
	printf("tellics seek 5 1 rated f\n");
	printf("tellics seek 3 0 rated f\n");
	printf("tellics seek 1 0 rated f\n");
	printf("tellics seek 3 1 rated f\n");
	printf("tellics seek 1 1 rated f\n");
     }
#endif
   }	
   else if (strcmp (cmd, "rating") == 0) {
      sscanf(inputstr,"%d %d",&myrating,&opprating); 
      fprintf(ofp,"my rating = %d, opponent rating = %d\n",myrating,opprating); 
   }
   else if (strcmp (cmd, "activate") == 0) {
	CLEAR (flags, TIMEOUT);
	CLEAR (flags, ENDED);
   }
   else if (strcmp (cmd, "new") == 0) {
     InitVars ();
     NewPosition ();
     CLEAR (flags, MANUAL);
     CLEAR (flags, THINK);
   }
   else if (strcmp (cmd, "time") == 0) {
     sscanf (inputstr, "%s %[^\n]", s, inputstr);
     TimeLimit[1^board.side] = atoi(s) / 100;
   }
   else if (strcmp (cmd, "otim") == 0)
	;
   else if (strcmp (cmd, "random") == 0)
	;
   else if (strcmp (cmd, "debugply") == 0)
      DebugPly = atoi (inputstr);
   else if (strcmp (cmd, "debugdepth") == 0)
      DebugDepth = atoi (inputstr);
   else if (strcmp (cmd, "debugnode") == 0)
      DebugNode = atoi (inputstr);
   else if (strcmp (cmd, "hash") == 0)
   {
      sscanf (inputstr, "%s %[^\n]", cmd, inputstr);
      if (strcmp (cmd, "off") == 0)
         CLEAR (flags, USEHASH);
      else if (strcmp (cmd, "on") == 0)
         SET (flags, USEHASH);
      printf ("Hashing %s\n", flags & USEHASH ? "on" : "off");
   }
   else if (strcmp (cmd, "hashsize") == 0)
   {
      i = atoi (inputstr);
      TTHashMask = 0;
      while ((i >>= 1) > 0)
      {
         TTHashMask <<= 1;
         TTHashMask |= 1;
      }
      HashSize = TTHashMask + 1;
      printf ("Adjusting HashSize to %d slots\n", HashSize);
      InitHashTable (); 
   }
   else if (strcmp (cmd, "null") == 0)
   {
      sscanf (inputstr, "%s %[^\n]", cmd, inputstr);
      if (strcmp (cmd, "off") == 0)
         CLEAR (flags, USENULL);
      else if (strcmp (cmd, "on") == 0)
         SET (flags, USENULL);
      printf ("Null moves %s\n", flags & USENULL ? "on" : "off");
   }
   else if (strcmp (cmd, "xboard") == 0)
   {
      sscanf (inputstr, "%s %[^\n]", cmd, inputstr);
      if (strcmp (cmd, "off") == 0)
         CLEAR (flags, XBOARD);
      else if (strcmp (cmd, "on") == 0)
         SET (flags, XBOARD);
      else if (!(flags & XBOARD)) { /* set if unset and only xboard called */
	 SET (flags, XBOARD);	    /* like in xboard/winboard usage */
      }
   }
#ifdef UNIVERSAL
  else if (strcmp(cmd,"universal") == 0) {
    if (strcmp(subcmd,"on") == 0) {
/*
      printf("INITIALIZE UNIVERSAL\n");
      getchar();
*/
      SET (flags, UNIV);
      univ_init ();
      signal (SIGALRM, univ_check);
      alarm(1);
    } else if (strcmp(subcmd,"off") == 0) {
      CLEAR (flags, UNIV);
      signal (SIGALRM, SIG_IGN);
    }
  }
#endif
   else if (strcmp (cmd, "depth") == 0) {
      SearchDepth = atoi (inputstr);
      printf("Search to a depth of %d\n",SearchDepth);
   }
   else if (strcmp (cmd, "level") == 0)
   {
      SearchDepth = 0;
      sscanf (inputstr, "%hd %f %hd", &TCMove, &TCTime, &TCinc);
      if (TCMove == 0) {
	TCMove = 60;
	suddendeath = 1;
      } else
	suddendeath = 0;
      if (TCTime == 0) {
         SET (flags, TIMECTL);
	 SearchTime = TCinc / 2;
         printf("Fischer increment of %d seconds\n",TCinc);
      }
      else
      {
         SET (flags, TIMECTL);
         MoveLimit[white] = MoveLimit[black] = TCMove - (GameCnt+1)/2;
         TimeLimit[white] = TimeLimit[black] = TCTime * 60;
	 if (!(flags & XBOARD)) {
	   printf ("Time Control: %d moves in %.2f secs\n", 
	          MoveLimit[white], TimeLimit[white]);
	   printf("Fischer increment of %.2f seconds\n",TCinc);
	 }
      }
   }
   else if (strcmp (cmd, "load") == 0 || strcmp (cmd, "epdload") == 0)
   {
      LoadEPD (inputstr);
      if (!ValidateBoard())
      {
	 SET (flags, ENDED);
         printf ("Board is wrong!\n");
      }
   }
   else if (strcmp (cmd, "save") == 0 || strcmp (cmd, "epdsave") == 0)
      SaveEPD (inputstr);
   else if (strcmp (cmd, "epd") == 0)
   {
      ParseEPD (inputstr);
      printf ("\n%s : Best move = %s\n", id, solution); 
   }
   else if (strcmp (cmd, "switch") == 0)
   {
      board.side = 1^board.side;
      printf ("%s to move\n", board.side == white ? "White" : "Black");
   }
   else if (strcmp (cmd, "go") == 0)
   {
      SET (flags, THINK);
      CLEAR (flags, MANUAL);
      computer = board.side;
/*
      printf ("Computer is playing %s\n", computer ? "black" : "white");
*/
   }
   else if (strcmp (cmd, "solve") == 0 || strcmp (cmd, "solveepd") == 0)
      Solve (inputstr);
   else if (strcmp (cmd,"remove") == 0) {
    if (GameCnt >= 0) {
       CLEAR (flags, ENDED);
       CLEAR (flags, TIMEOUT);
       UnmakeMove (board.side, &Game[GameCnt].move);
       if (GameCnt >= 0) {
         UnmakeMove (board.side, &Game[GameCnt].move);
         if (!(flags & XBOARD))
           ShowBoard ();
       }
       PGNSaveToFile ("game.log");
    } else
       printf ("No moves to undo! \n");
   }
   else if (strcmp (cmd, "undo") == 0)
   {
      if (GameCnt >= 0)
         UnmakeMove (board.side, &Game[GameCnt].move);
      else
	 printf ("No moves to undo! \n");
      MoveLimit[board.side]++;
      TimeLimit[board.side] += Game[GameCnt+1].et;
      if (!(flags & XBOARD)) ShowBoard ();
   }

   /* everything else must be a move */
   else
   {
      ptr = ValidateMove (cmd);
      if (ptr != NULL) 
      {
	 SANMove (ptr->move, 1);
	 MakeMove (board.side, &ptr->move);
	 strcpy (Game[GameCnt].SANmv, SANmv);
	 printf("%d. ",GameCnt/2+1);
	 printf("%s",cmd);
	 if (ofp != stdout) {
	   fprintf(ofp,"%d. ",GameCnt/2+1);
	   fprintf(ofp,"%s",cmd);
	 }
	 putchar('\n');
	 fflush(stdout);
  	 if (ofp != stdout) {
	   fputc('\n',ofp);
	   fflush(ofp);
         }
         if (!(flags & XBOARD)) ShowBoard (); 
	 SET (flags, THINK);
      }
      else {
#ifdef NEVER
         printf ("Illegal move: %s\n",cmd);
         if (ofp != stdout) fprintf (ofp,"Illegal move\n");
#endif
      }
   }
}



void ShowCmd (char *subcmd)
/************************************************************************
 *
 *  The show command driver section.
 *
 ************************************************************************/
{
   char cmd[10];
   short i;

   sscanf (subcmd, "%s %[^\n]", cmd, subcmd);
/*
   printf("subcmd = %s, cmd = %s\n",subcmd,cmd);
*/
   if (strcmp (cmd, "board") == 0)
      ShowBoard ();
   else if (strcmp (cmd, "time") == 0)
      ShowTime ();
   else if (strcmp (cmd, "moves") == 0)
   {
      GenCnt = 0;
      TreePtr[2] = TreePtr[1];
      GenMoves (1);      
      ShowMoveList (1);
      printf ("No. of moves generated = %ld\n", GenCnt);
   }
   else if (strcmp (cmd, "escape") == 0)
   {
      GenCnt = 0;
      TreePtr[2] = TreePtr[1];
      GenCheckEscapes (1);      
      ShowMoveList (1);
      printf ("No. of moves generated = %ld\n", GenCnt);
   }
   else if (strcmp (cmd, "noncapture") == 0)
   {
      GenCnt = 0;
      TreePtr[2] = TreePtr[1];
      GenNonCaptures (1);      
      FilterIllegalMoves (1);
      ShowMoveList (1);
      printf ("No. of moves generated = %ld\n", GenCnt);
   }
   else if (strcmp (cmd, "capture") == 0)
   {
      GenCnt = 0;
      TreePtr[2] = TreePtr[1];
      GenCaptures (1);      
      FilterIllegalMoves (1);
      ShowMoveList (1);
      printf ("No. of moves generated = %ld\n", GenCnt);
   }
   else if (strcmp (cmd, "eval") == 0 || strcmp (cmd, "score") == 0)
   {
      int s, wp, bp, wk, bk;
      short r, c, sq;
      BitBoard *b;

      phase = PHASE;
      GenAtaks ();
      FindPins (&pinned);
      hunged[white] = EvalHung(white);
      hunged[black] = EvalHung(black);
      b = board.b[white];
      pieces[white] = b[knight] | b[bishop] | b[rook] | b[queen]; 
      b = board.b[black];
      pieces[black] = b[knight] | b[bishop] | b[rook] | b[queen]; 
      wp = ScoreP (white);
      bp = ScoreP (black);
      wk = ScoreK (white);
      bk = ScoreK (black);
      printf ("White:  Mat:%4d/%4d  P:%d  N:%d  B:%d  R:%d  Q:%d  K:%d  Dev:%d  h:%d\n",
	board.pmaterial[white], board.material[white], wp, ScoreN(white), 
        ScoreB(white), ScoreR(white), ScoreQ(white), wk, 
        ScoreDev(white), hunged[white]);
      printf ("Black:  Mat:%4d/%4d  P:%d  N:%d  B:%d  R:%d  Q:%d  K:%d  Dev:%d  h:%d\n",
	board.pmaterial[black], board.material[black], bp, ScoreN(black), 
        ScoreB(black), ScoreR(black), ScoreQ(black), bk,
        ScoreDev(black), hunged[black]);
      printf ("Phase: %d\t", PHASE);
      s = ( EvaluateDraw () ? DRAWSCORE : Evaluate (-INFINITY, INFINITY));
      printf ("score = %d\n", s);
      printf ("\n");
      for (r = 56; r >= 0; r -= 8)
      {
         printf ("     +---+---+---+---+---+---+---+---+\n");
         printf ("   %d |", (r >> 3) + 1);
         for (c = 0; c < 8; c++)
         {
            sq = r + c;
	    if (cboard[sq] == 0)
 	       printf ("   |");
	    else
               printf ("%3d|", pscore[sq]);
         }
         printf ("\n");
      }
      printf ("     +---+---+---+---+---+---+---+---+\n");
      printf ("       a   b   c   d   e   f   g   h  \n");
   }
   else if (strcmp (cmd, "game") == 0)
     ShowGame ();
   else if (strcmp (cmd, "pin") == 0)
   {
      BitBoard b;
      GenAtaks ();
      FindPins (&b);
      ShowBitBoard (&b);
   }
}


void BookCmd (char *subcmd)
/*************************************************************************
 *
 *  The book command driver section.
 *
 *************************************************************************/
{
   char cmd[10];
   char bookfile[64];
   short bookply;

   sscanf (subcmd, "%s %[^\n]", cmd, subcmd);
   if (strcmp (cmd, "make") == 0)
   {
      sscanf (subcmd, "%s %hd\n", bookfile, &bookply);
      /* MakeBinBook (bookfile, bookply); */
   }
}



void TestCmd (char *subcmd)
/*************************************************************************
 *
 *  The test command driver section.
 *
 *************************************************************************/
{
   int ncmds;
   char cmd[10];

   sscanf (subcmd, "%s %[^\n]", cmd, subcmd);
   if (strcmp (cmd, "movelist") == 0)
      TestMoveList ();
   else if (strcmp (cmd, "capture") == 0)
      TestCaptureList ();
   else if (strcmp (cmd, "movegenspeed") == 0)
      TestMoveGenSpeed ();
   else if (strcmp (cmd, "capturespeed") == 0)
      TestCaptureGenSpeed ();
   else if (strcmp (cmd, "eval") == 0)
      TestEval ();
   else if (strcmp (cmd, "evalspeed") == 0)
      TestEvalSpeed ();
}


void ShowHelp ()
/**************************************************************************
 *
 *  Display all the help commands.
 *
 **************************************************************************/
{
   printf ("+-----------------------------------------------+\n");
   printf ("|                    H E L P                    |\n");
   printf ("+-----------------------------------------------+\n");
}

