/*
 * Cheops Network User Interface
 *
 * Copyright (C) 1999, Adtran, Inc.
 * 
 * Distributed under the terms of the GNU GPL
 *
 */

#define EVENT_DEBUG    0
#define EVENT_NOTIFY   2
#define EVENT_WARNING  3
#define EVENT_CRITICAL 4

struct event {
	int lev;		/* Level of event */
	char *date;		/* Time of event*/
	char *who;		/* Who recorded the event (static) */
	char *host;		/* Host of the event (dynamic) */
	char *svc;		/* Name of service (static) */
	char *msg;		/* Log message (dynamic); */
};


/* We keep track of all event windows so that when an event comes in we show
   it in all applicable windows */

struct event_window {
	char *hostname;
	GtkWidget *window;
	GtkWidget *clist;
	
};

extern void log_event(int lev, char *who, char *svc, char *host, char *msg);
extern void show_event_window(char *);
extern int events_exist(char *);

extern void close_logfile(void);
extern void clear_logfile(void);
extern void make_logfile(void);
extern void make_email(void);
extern char logfile[];
extern char email[];
