/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          interface_widget_equivtable.cpp  -  description
                             -------------------
    begin                : Sun Apr 8 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface_widget_equivtable.h"
#include <gdk/gdkkeysyms.h>

int Equivalence_Table::Orderlist_Colors[] = {
    10, 20, 30,
    100, 200, 100,
    230, 250, 230,
    30, 30, 30,
    30, 40, 50
};

gint Equivalence_Table::button_press_event_impl(GdkEventButton* p0) {

	grab_focus(); // is this the best way to do it? I cant figure it out!
        im_focused=true;
	draw_single_mode();
	return 0;
}

gint  Equivalence_Table::focus_out_event_impl(GdkEventFocus* p0) {

        im_focused=false;
	draw_single_mode();

	return 0;
}
void Equivalence_Table::allocate_colormap () {

	Gdk_Color tmpcolor;
	int i;

	for (i=0;i<Colormap_max_Colors*3;i+=3) {

                //tmpcolor=colors[i/3];
		//tmpcolor=colors[i/3];

		colors[i/3].red = Orderlist_Colors[i] * 0xFFFF / 0xFF;
		colors[i/3].green = Orderlist_Colors[i+1] * 0xFFFF / 0xFF;
		colors[i/3].blue = Orderlist_Colors[i+2] * 0xFFFF / 0xFF;
	        get_colormap().alloc(colors[i/3]);
	}

}


void Equivalence_Table::realize_impl() {

	Gdk_WindowAttr attributes;
        int attributes_mask;

	set_flags(GTK_REALIZED|GTK_CAN_FOCUS|GTK_HAS_GRAB);

	attributes->x=gtkobj()->allocation.x;
	attributes->y=gtkobj()->allocation.y;
	attributes->width = width();
	attributes->height = height();
	attributes->wclass = GDK_INPUT_OUTPUT;
	attributes->window_type = GDK_WINDOW_CHILD;
	attributes->event_mask = get_events () | GDK_EXPOSURE_MASK;
	attributes->visual = get_visual ();
	attributes->colormap = get_colormap ();	

	attributes_mask = GDK_WA_X | GDK_WA_Y | GDK_WA_VISUAL | GDK_WA_COLORMAP;

	window.create(get_parent_window(), attributes, attributes_mask);
	gtkobj()->window=window;

	expose_event.connect(slot(this,&Equivalence_Table::do_expose_event));

	allocate_colormap();

        bgcol.create(get_window());
	fgcol.create(get_window());
	cursorcol.create(get_window());
	sepcol.create(get_window());
	playcol.create(get_window());

	bgcol.set_foreground(colors[Col_BackGround]);
	fgcol.set_foreground(colors[Col_ForeGround]);
	cursorcol.set_foreground(colors[Col_Cursor]);
	sepcol.set_foreground(colors[Col_Separator]);
	playcol.set_foreground(colors[Col_BeingPlayed]);

	bgcol.set_exposures(1);
	window.set_user_data(gtkobj());
	window.set_background(colors[Col_BackGround]);

 	font.load("-adobe-courier-bold-r-normal--*-120-*-*-*-*-*-*");
}

int Equivalence_Table::get_font_width() {

	return (font.string_width("X"));

}

int Equivalence_Table::get_font_height() {

	return (font.ascent()+font.descent());
}


void Equivalence_Table::draw_single_cursor() {

	int initx,inity;
	const int cursor_spacing[6]={0,2,4,5,6,7};

	initx=get_font_width()*4+cursor_spacing[cursor_x]*get_font_width();
	inity=get_font_height()*(cursor_y-row_offset);

	window.draw_rectangle(cursorcol,FALSE,10+initx-1,inity-1,get_font_width()+2,get_font_height()+2);
}

void Equivalence_Table::draw_single_mode() {

	int i;


	int rows_to_draw;

      	if ( (tone==NULL)) return;

	rows_to_draw=height()/get_font_height();

	if (cursor_y<row_offset) row_offset=cursor_y;
	if (cursor_y>=(row_offset+rows_to_draw)) row_offset=(cursor_y-rows_to_draw)+1;

	for (i=0;i<rows_to_draw;i++) {



		window.draw_rectangle(bgcol,TRUE,0,get_font_height()*i,width(),get_font_height());

		if ((i+row_offset)<128) {

			string left_note;
			string right_note;
			char instr_number[5]={'.','.','.','.',0};

			if (tone->sample.sample[i+row_offset]!=-1) {

				instr_number[0]='0'+((tone->sample.sample[i+row_offset])/1000) % 10;
				instr_number[1]='0'+((tone->sample.sample[i+row_offset])/100) % 10;
				instr_number[2]='0'+((tone->sample.sample[i+row_offset])/10) %10;
				instr_number[3]='0'+(tone->sample.sample[i+row_offset]) % 10;
			}

			left_note=Utils::note_to_string(i+row_offset);
			right_note=Utils::note_to_string(tone->sample.note[i+row_offset]);

//                        tmpord=song->variables->get_cstring_order(i+row_offset);

//			aux=song->get_order(i+row_offset);

			window.draw_string(font,cursorcol,10,get_font_height()*i+get_font_height(),left_note);
			window.draw_string(font,fgcol,10+get_font_width()*4,get_font_height()*i+get_font_height(),right_note);
			window.draw_string(font,fgcol,10+get_font_width()*8,get_font_height()*i+get_font_height(),instr_number);

		}

	}

	window.draw_rectangle(sepcol,TRUE,13+get_font_width()*3,0,3,height());

	if (im_focused) {

		window.draw_rectangle(cursorcol,FALSE,0,0,width()-1,height()-1);
		draw_single_cursor();
	}
}

void Equivalence_Table::MoveUp() {

        if (cursor_y>0) cursor_y--;

}

void Equivalence_Table::MoveDown() {

        if (cursor_y<126) cursor_y++;
	
}

void Equivalence_Table::MoveLeft() {

        if (cursor_x>0) cursor_x--;
	
}

void Equivalence_Table::MoveRight() {

        if (cursor_x<5) cursor_x++;

}

void Equivalence_Table::PageUp() {

       cursor_y-=8;
       if (cursor_y<0) cursor_y=0;
}

void Equivalence_Table::PageDown() {

       cursor_y+=8;
       if (cursor_y>=128) cursor_y=127;
}


void Equivalence_Table::AddSeparator() {

//	song->variables->orderlist[cursor_y]=253;
//	song->set_order(cursor_y,253);
	MoveDown();
}

void Equivalence_Table::ClearOrder() {

	if (cursor_x>1) tone->sample.sample[cursor_y]=-1;
	sample_mask=-1;
	MoveDown();
}

void Equivalence_Table::InsertValue(int number) {


	switch (cursor_x) {

		case 0: {

			int tmpkey = Utils::key_to_note(number);			
			if (tmpkey!=-1) {

				tone->sample.note[cursor_y]=tmpkey;
				tone->sample.sample[cursor_y]=sample_mask;

				MoveDown();
			}
		} break;
		case 1: {
			
			if ((number>='0') && (number<='9')) {

				int aux_numb=tone->sample.note[cursor_y] % 12;

				tone->sample.note[cursor_y]=(number-'0')*12+aux_numb;
				MoveDown();
			}
		} break;
		case 2: {
			
			if ((number>='0') && (number<='9')) {

				int aux_numb=tone->sample.sample[cursor_y];
                                int new_digit=number-'0';
				if (aux_numb==-1) aux_numb=0;

				aux_numb-=((aux_numb/1000)%10)*1000;
				aux_numb+=new_digit*1000;

				sample_mask=aux_numb;				
				tone->sample.sample[cursor_y]=aux_numb;
				
				MoveRight();
			}
		} break;
		case 3: {
			
			if ((number>='0') && (number<='9')) {

				int aux_numb=tone->sample.sample[cursor_y];
                                int new_digit=number-'0';
				if (aux_numb==-1) aux_numb=0;

				aux_numb-=((aux_numb/100)%10)*100;
				aux_numb+=new_digit*100;

				sample_mask=aux_numb;				
				tone->sample.sample[cursor_y]=aux_numb;
				
				MoveRight();
			}
		} break;
		case 4: {
			
			if ((number>='0') && (number<='9')) {

				int aux_numb=tone->sample.sample[cursor_y];
                                int new_digit=number-'0';
				if (aux_numb==-1) aux_numb=0;


				aux_numb-=((aux_numb/10)%10)*10;
				aux_numb+=new_digit*10;

				sample_mask=aux_numb;				
				tone->sample.sample[cursor_y]=aux_numb;
				
				MoveRight();
			}
		} break;
		case 5: {
			
			if ((number>='0') && (number<='9')) {

				int aux_numb=tone->sample.sample[cursor_y];
                                int new_digit=number-'0';
				if (aux_numb==-1) aux_numb=0;


				aux_numb-=aux_numb%10;
				aux_numb+=new_digit;

				sample_mask=aux_numb;				
				tone->sample.sample[cursor_y]=aux_numb;
			
				MoveLeft();
				MoveDown();
			}
		} break;

	}

}

void Equivalence_Table::InsertBlank() {
	


	if (cursor_x>1) tone->sample.sample[cursor_y]=-1;
/*
	for (i=NOTE_NOTES-1;i>cursor_y;i--) {

		song->set_order(i,song->get_order(i-1));
	}
	song->set_order(cursor_y,255);
*/
}

void Equivalence_Table::DeleteRow() {


  /*
	for (i=cursor_y;i<NOTE_NOTES-1;i++) {

		song->set_order(i,song->get_order(i+1));
	}
	song->set_order(NOTE_NOTES-1,255);
*/
}

void Equivalence_Table::InsertRepeat() {

//	song->set_order(cursor_y,254);
	MoveDown();
}



gint Equivalence_Table::do_expose_event(GdkEventExpose* p0) {


/*	if (song==NULL) {

		return 0;
	}

	adjust_editor();
	print_rows();
                 */

	draw_single_mode();

	return 0;

}



gint Equivalence_Table::key_press_event_impl(GdkEventKey* event) {

	bool stop_signal=true;

        if (event->keyval>='a' && event->keyval<='z') event->keyval-=('a'-'A');

	switch (event->keyval) {

		case GDK_Up: {

			MoveUp();
 				
		} break;

		case GDK_Down: {

			MoveDown();
		} break;

		case GDK_Left: {

			MoveLeft(); 		
		} break;
		case GDK_Right: {

			MoveRight();	
		} break;
		case GDK_Page_Up: {

			PageUp();	
		 		
		} break;
		case GDK_Page_Down: {

			PageDown();	 		
		} break;        	

		case '.':{

			ClearOrder();
		} break;
		case GDK_Insert: {

			InsertBlank();		
		} break;
		case GDK_Delete: {

			DeleteRow();				
		} break;
		case GDK_KP_Add: {

			AddSeparator();
		} break;
		case GDK_KP_Subtract: {
			
			InsertRepeat();		
		} break;
		default: {
			if (((event->keyval>='0') && (event->keyval<='9')) || ((event->keyval>='A') && (event->keyval<='Z'))) InsertValue(event->keyval);
		}break;

	}

	queue_draw();

	if (stop_signal) {

		gtk_signal_emit_stop_by_name(GTK_OBJECT(gtkobj()),"key_press_event");

		return TRUE;
	} else {

		return FALSE;
	}

}

void Equivalence_Table::link_to_tone(Tone *p_tone) {

	tone=p_tone;
	queue_draw();

}

Equivalence_Table::Equivalence_Table(){

	row_offset=0;
	cursor_x=0;
	cursor_y=0;
	tone=NULL;
}

Equivalence_Table::~Equivalence_Table(){
}
