/***************************************************************************
                          sound_driver_oss.h  -  description
                             -------------------
    begin                : Sun Jan 28 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SOUND_DRIVER_OSS_H
#define SOUND_DRIVER_OSS_H

#include <unistd.h>

#include <sound_driver.h>
#include <fcntl.h>
#include <sys/soundcard.h>
#include <sys/ioctl.h>

#include "mutex_lock_pthreads.h"
/**Sound driver for OSS
  *@author Juan Linietsky
  */


/******************************
 sound_driver_OSS.h
 --------

This is an OSS sound driver!
********************************/

class Sound_Driver_OSS : public Sound_Driver  {


	int sound_fd;

	Sint8 *audiobuffer;
	int buffersize;
	int play_precision;

	int fragsize;
	int numfrags;

	bool active;

public:

	int get_mix_frequency();
	bool get_mix_stereo();
	bool get_mix_16bits();
	int get_mix_buffer_size();

 	int init();
	bool finish();
	bool update();
	bool is_active() {return active; };

       	string get_name() { return "OSS Sound Driver"; };

	Sound_Driver_OSS();
	~Sound_Driver_OSS();
};

#endif
