/***************************************************************************
                          mixer_procedure_interpolated_volramped.h  -  description
                             -------------------
    begin                : Sun Jan 20 2002
    copyright            : (C) 2002 by red
    email                : red@server
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MIXER_PROCEDURE_INTERPOLATED_VOLRAMPED_H
#define MIXER_PROCEDURE_INTERPOLATED_VOLRAMPED_H

#include "mixer_procedure.h"

/**
  *@author red
  */


#define RAMP_BITS 11
#define RAMP_LENGTH (1<<11)


class Mixer_Procedure_Interpolated_VolRamped : public Mixer_Procedure {

        int ramp_threshold;



       template<class Precision,class Depth >

        void mix_internal() {

        	MIXER_STEP_1_INIT
        	
        	Precision real_index;
	       	Precision sizemax=sample->size-1;
        	
        	vol_l=l_volume_prev;
	        vol_r=r_volume_prev;       	
	        float ramp_l,ramp_r;
	        Sint32 ramp_l_fp,ramp_r_fp;	
	        ramp_l=(float)(l_volume-l_volume_prev)/(float)samples_to_mix;
	        ramp_r=(float)(r_volume-r_volume_prev)/(float)samples_to_mix;
	
	        ramp_l_fp=ramp_l*RAMP_LENGTH;
	        ramp_r_fp=ramp_r*RAMP_LENGTH;
	
		l_volume_prev<<=RAMP_BITS;
		r_volume_prev<<=RAMP_BITS;
	
        	
        	MIXER_STEP_2_LOOP_BEGIN

			//ramp_volume(vol_l,l_volume);
			//ramp_volume(vol_r,r_volume);
			l_volume_prev+=ramp_l_fp;
			r_volume_prev+=ramp_r_fp;

	        	real_index=aux_index >> FRACBITS;

	        	final_data=data_ptr[real_index];
	        	
	        	if (real_index<sizemax) {    	
				
				final_data=final_data+((data_ptr[real_index+1]-final_data)*(aux_index&FRACMASK)>>FRACBITS);
	
			}
			
        		MIXER_STEP_3_CONVERT_TO_16BITS
	        	MIXER_STEP_3_BIS_PASS_FILTER
	        	
	        	vol_l=l_volume_prev>>RAMP_BITS;
	        	vol_r=r_volume_prev>>RAMP_BITS;       	
			rev_send_l=(reverb_send_amount*vol_l) >> 8;
			rev_send_r=(reverb_send_amount*vol_r) >> 8;
			send_l=vol_l-rev_send_l;
			send_r=vol_r-rev_send_r;
			
        	MIXER_STEP_4_MIX_TO_BUFFER_AND_EXIT
        	r_volume_prev=vol_r;
		l_volume_prev=vol_l;
	}
public:

	Mixer_Procedure_Interpolated_VolRamped();
	~Mixer_Procedure_Interpolated_VolRamped();

	string get_name() { return "Volume Ramped (slow!)"; };

        void register_sample(Sample_Data *p_sample) {};
	void unregister_sample(Sample_Data *p_sample) {};

	Sint64 mix_mono();
	Sint64 mix_stereo();
	Sint64 mix_surround();


};


#endif
