/***************************************************************************
                          interface_update_variables.cpp  -  description
                             -------------------
    begin                : Sun Mar 25 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface.h"


void Interface::update_variables() {

	variables_page_updating_in_progress=true;

	spinbutton_variables_tempo->set_value(song->initial_variables.tempo);
	spinbutton_variables_speed->set_value(song->initial_variables.speed);
	spinbutton_variables_glb_volume->set_value(song->initial_variables.global_volume);
	spinbutton_variables_mix_volume->set_value(song->variables.mixing_volume);
	spinbutton_variables_stereo_separation->set_value(song->variables.stereo_separation);
	
	checkbutton_variables_old_effects.set_active(song->variables.old_effects);
	checkbutton_variables_compat_gxx.set_active(song->variables.compatible_gxx);

	if (song->variables.use_stereo) radiobutton_variables_playback_stereo->set_active(true);
	else radiobutton_variables_playback_mono->set_active(true);

	if (song->variables.use_linear_slides) radiobutton_variables_slides_linear->set_active(true);
	else radiobutton_variables_slides_amiga->set_active(true);

	if (song->variables.use_instruments) radiobutton_variables_control_instruments->set_active(true);
	else radiobutton_variables_control_samples->set_active(true);

	text_variables_message.delete_text(0,-1);
	text_variables_message.insert(song->variables.message);
       	if (text_variables_message.get_length()>7999) text_variables_message.delete_text(7999,-1);
	variables_page_updating_in_progress=false;

}