/***************************************************************************
                          interface_update_samples.cpp  -  description
                             -------------------
    begin                : Sun Jan 21 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "interface.h"

void Interface::update_clist_samples_list() {

	int i;

	clist_samples_list.freeze();

	for (i=0;i<MAX_SAMPLES;i++) {

		if ( song->get_sample(i)->in_use ) {
                	
			clist_samples_list.set_text(i,1,"*");
		} else {

       			clist_samples_list.set_text(i,1," ");
		}

  		clist_samples_list.set_text(i,2,song->get_sample(i)->name); 		
	}

	clist_samples_list.thaw();

}

void Interface::update_selected_sample_info() {

	#define SET_SPIN_MAX(spinbtn,maxval) tmp_adjustment=spinbtn->get_adjustment(); tmp_adjustment->set_upper(maxval); spinbtn->set_adjustment(tmp_adjustment)
	#define SET_SPIN_MIN(spinbtn,maxval) tmp_adjustment=spinbtn->get_adjustment(); tmp_adjustment->set_lower(maxval); spinbtn->set_adjustment(tmp_adjustment)

	const char* quality[2]={"8 Bits","16 Bits"};
	char length_string[20];
	Gtk::Adjustment *tmp_adjustment;
	int i;

	selected_sample_updating_in_progress=true;

	i=selected_sample;

	spinbutton_samples_def_volume->set_value(song->get_sample(i)->def_volume);
	spinbutton_samples_glb_volume->set_value(song->get_sample(i)->glb_volume);
	spinbutton_samples_def_pan->set_value(song->get_sample(i)->def_panning);
	spinbutton_samples_vibrato_speed->set_value(song->get_sample(i)->vibrato_speed);
	spinbutton_samples_vibrato_depth->set_value(song->get_sample(i)->vibrato_depth);
	spinbutton_samples_vibrato_rate->set_value(song->get_sample(i)->vibrato_rate);
//	spinbutton_samples_speed->set_value(song->get_sample(i)->data.base_speed);
	
	SET_SPIN_MAX(spinbutton_samples_loop_begin,song->get_sample(i)->data.loop_end-1);
	SET_SPIN_MIN(spinbutton_samples_loop_end,song->get_sample(i)->data.loop_begin+1);
	SET_SPIN_MAX(spinbutton_samples_loop_end,song->get_sample(i)->data.size);

	SET_SPIN_MAX(spinbutton_samples_susloop_begin,song->get_sample(i)->data.sustain_loop_end-1);
	SET_SPIN_MIN(spinbutton_samples_susloop_end,song->get_sample(i)->data.sustain_loop_begin+1);
	SET_SPIN_MAX(spinbutton_samples_susloop_end,song->get_sample(i)->data.size);

	spinbutton_samples_loop_begin->set_value(song->get_sample(i)->data.loop_begin);
	spinbutton_samples_loop_end->set_value(song->get_sample(i)->data.loop_end);
	spinbutton_samples_susloop_begin->set_value(song->get_sample(i)->data.sustain_loop_begin);
	spinbutton_samples_susloop_end->set_value(song->get_sample(i)->data.sustain_loop_end);

	checkbutton_samples_def_pan.set_active(song->get_sample(i)->def_panning_on);
	spinbutton_samples_base_note->set_value(song->get_sample(i)->data.note_offset+48);
	spinbutton_samples_finetune->set_value(song->get_sample(i)->data.finetune);

	entry_samples_base_note.set_text(editor.get_single_note_string(song->get_sample(i)->data.note_offset+48));

	entry_samples_filename.set_text(song->get_sample(i)->filename);

	if (song->get_sample(i)->in_use) {

		entry_samples_quality.set_text(quality[song->get_sample(i)->data.is_16bits?1:0]);
	} else {

		entry_samples_quality.set_text("No Sample.");
	}

	sprintf(length_string,"%d Samples",song->get_sample(i)->data.size);

	entry_samples_length.set_text(length_string);
	entry_samples_samplename.set_text(song->get_sample(i)->name);
	
	if ((player!=NULL) && (song!=NULL) && (player->get_mixer_ptr()!=NULL)){

		sample_view_samples_current.set_sample(&song->get_sample(i)->data);
		sample_view_samples_current.set_mixer(player->get_mixer_ptr());
	        realtime_keyboard.sample_set(song->get_sample(i)->in_use?&song->get_sample(i)->data:NULL);

	}

	if (song->get_sample(i)->data.loop_on) {

		if (song->get_sample(i)->data.pingpong_loop) {

			combo_samples_loop_type.get_entry()->set_text("<-Ping Pong->");

		} else {


			combo_samples_loop_type.get_entry()->set_text("|Forward->");

		}

	} else {

		combo_samples_loop_type.get_entry()->set_text("|None|");

	}

	selected_sample_updating_in_progress=false;

}


void Interface::load_sample() {


 	string filename;
      	bool load_ok=false;

	realtime_keyboard.instrument_stop_all();
	realtime_keyboard.sample_stop_all();
      	player->play_stop();				

      	file_select_popup= new File_Access_Widget;
      	file_select_popup->set_mode(File_Access_Widget::LOAD);
        if (data_path!="") file_select_popup->set_filename(data_path);
	file_select_popup->make_default.connect(SigC::bind<string>(slot(this,&Interface::set_some_default_path),"data"));       					
      	do {

      		file_select_popup->poll_until_action(*kit);
      		filename=file_select_popup->get_filename();

      		if (file_select_popup->get_action()!=File_Access_Widget::CANCEL) {

			// let's see if we can load a simple sample!			
			if (file_manager->load_sample((char*)filename.c_str(),selected_sample)==FUNCTION_SUCCESS) {
				//hooray! we got a sample!
				load_ok=true;

			} else {
				// no? then we try if the file is a song and we can rip samples from it
				Loader* aux_loader;
	
				variables_lock->grab();
		      		aux_loader=file_manager->check_file_in_loaders((char*)filename.c_str());

				if (aux_loader==NULL) {

					aux_loader=file_manager->load_sample_library((char*)filename.c_str());
				}
		
				variables_lock->release();
	
				
				if (aux_loader!=NULL) {
	                        //Okay, fine It's a song!
	
					sample_import = new Sample_Import(aux_loader,&realtime_keyboard,selected_sample);
				        sample_import->clist_sample_import.key_press_event.connect(slot(this,&Interface::on_samples_piano_enabled_widgets_key_pressed));
					sample_import->clist_sample_import.key_release_event.connect(slot(this,&Interface::on_samples_piano_enabled_widgets_key_released));
					load_ok=sample_import->do_main_loop(*kit);
					aux_loader->free_info();				
					delete sample_import;
				}
			
	      		}
		}

      	} while (!load_ok && (file_select_popup->get_action()!=File_Access_Widget::CANCEL));

      	delete file_select_popup;

        update_clist_instrments_names();
        update_selected_instrument_info();
}

void Interface::save_sample() {


 	string filename;
      	bool load_ok=false;

        if (!song->get_sample(selected_sample)->in_use) return;
	
	realtime_keyboard.instrument_stop_all();
	realtime_keyboard.sample_stop_all();
      	player->play_stop();				

      	file_select_popup= new File_Access_Widget;
      	file_select_popup->set_mode(File_Access_Widget::SAVE);
        if (data_path!="") file_select_popup->set_filename(data_path);
	file_select_popup->make_default.connect(SigC::bind<string>(slot(this,&Interface::set_some_default_path),"data"));
      	do {

      		file_select_popup->poll_until_action(*kit);
      		filename=file_select_popup->get_filename();

      		if (file_select_popup->get_action()!=File_Access_Widget::CANCEL) {

			int error;
			
			if ((error=file_manager->save_sample((char*)filename.c_str(),selected_sample))==Saver::SAVE_OK) {
				//hooray! we got a sample!
				load_ok=true;

			} else if  (error==Saver::SAVE_ERROR) {
 				
 				accept_dialog = new Dialog_Accept("Error opening file for writing",*kit);
      				delete accept_dialog;
			
	      		} else if  (error==Saver::UNKNOWN_TYPE) {
	      		
      				accept_dialog = new Dialog_Accept("Unknown file format (check extension?)",*kit);      			
      				delete accept_dialog;      				
	      		}
	      		
		}

      	} while (!load_ok && (file_select_popup->get_action()!=File_Access_Widget::CANCEL));

      	delete file_select_popup;

}
