/***************************************************************************
                          interface_popups.h  -  description
                             -------------------
    begin                : Thu Apr 12 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INTERFACE_POPUPS_H
#define INTERFACE_POPUPS_H
#include <gtk--/window.h>
#include <gtk--/button.h>
#include <gtk--/box.h>
#include <gtk--/frame.h>
#include <gtk--/main.h>
#include <gtk--/fileselection.h>
#include <gtk--/dialog.h>
#include <gtk--/spinbutton.h>
#include <gtk--/adjustment.h>
#include <gtk--/menu.h>
#include <gtk--/separator.h>
#include <gtk--/table.h>
#include <gtk--/fontselection.h>
#include <gtk--/text.h>
#include <gtk--/clist.h>
#include <gtk--/pixmap.h>
#include <gtk--/scrolledwindow.h>
#include <interface_widget_posvar.h>
#include <unistd.h>

#include "sample.h"


using SigC::bind;
/**All the popups!

  *@author Juan Linietsky
  */

/******************************
 interface_popups.h
 ----------

All the nitty-witty popups that
will help us throught out quest
to madness
********************************/

class Window_File_Popup : public Gtk::Window {
public:
        Gtk::Button button_popup_file_load;
        Gtk::Button button_popup_file_new;
        Gtk::Button button_popup_file_save_current;
        Gtk::Button button_popup_file_save_as;
        Gtk::Button button_popup_file_quit;
        Gtk::VBox vbox2;
        Gtk::Frame frame1;

	enum actions {
                WAITING,
		PRESSED_LOAD,
		PRESSED_NEW,
		PRESSED_SAVE_CURRENT,
		PRESSED_SAVE_AS,
		PRESSED_QUIT,
		PRESSED_NOTHING
	};
	
	int action;

	void poll_until_action(Gtk::Main &p_kit);

	void on_button_press_set_action(int p_action);

	gint delete_event_impl(GdkEventAny* p_event) {

		action=PRESSED_NOTHING;
		return 1;
	}

	Window_File_Popup();
	~Window_File_Popup();
};

class File_Access_Widget : public Gtk::FileSelection {

	int current_mode;
	int action;
        Gtk::Main *kit;
        Gtk::Button help;
	Gtk::Pixmap help_pixie;
        Gtk::Button make_default_path;
public:
	enum modes {

		SAVE,
		LOAD,
	};

	enum actions {
                WAITING,
		OK,
		CANCEL
	};

	gint delete_event_impl(GdkEventAny* p_event) {

		action=CANCEL;
		return 1;
	}

 	SigC::Signal1<void,string> make_default;

	void set_mode(int p_mode);
	void button_ok_pressed();
	void button_cancel_pressed();
	void button_help_pressed();
	void button_make_default_path_pressed();

        int get_action () {  return action; };

	void poll_until_action(Gtk::Main &p_kit);

	File_Access_Widget();
	~File_Access_Widget();

};

class Dialog_Accept : public Gtk::Dialog {

	Gtk::Button button;
	Gtk::Label *label;

	Dialog_Accept() {};

        void button_ok_pressed();

       	gint delete_event_impl(GdkEventAny* p_event) {

		button_clicked=true;
		return 1;
	}

	bool button_clicked;
public:
	Dialog_Accept(string p_label_text,Gtk::Main &p_kit);
	~Dialog_Accept();
	

};


class Popup_Sample_Utils {

public:

	enum options {

		SEPARATOR_1,
		OPTION_COPY,
		OPTION_PASTE,
		OPTION_PASTE_EXCHANGE,
		OPTION_PASTE_EXCHANGE_SONG,
		OPTION_DELETE,
		SEPARATOR_2,
		OPTION_LOAD,
		OPTION_SAVE,
		SEPARATOR_3,
		OPTION_REVERSE,
		OPTION_PRE_LOOP_CUT,
		OPTION_POST_LOOP_CUT,
		OPTION_AMPLIFY,
		OPTION_CHANGE_SIGN,
		OPTION_TOGGLE_QUALITY,
		OPTION_RESIZE_INTERP,
		OPTION_RESIZE_NONINTERP,
		OPTION_CENTRALIZE,
		ITEM_OPTION_MAX
	};

		
	static const char * option_names[ITEM_OPTION_MAX];

        Gtk::MenuItem *items[ITEM_OPTION_MAX];
	Gtk::Menu sample_menu;

	Popup_Sample_Utils ();

	~Popup_Sample_Utils ();

};


class Dialog_Enter_Value : public Gtk::Dialog {

	Gtk::Button button;
	Gtk::Label *label;

	Dialog_Enter_Value() {};

        void button_ok_pressed();

       	gint delete_event_impl(GdkEventAny* p_event) {

		action=CANCEL;
		return 1;
	}

	Scroll_Bar *spinbutton_value;
	Gtk::Adjustment *spinbutton_value_adj;
        int value;
	int action;
	void spinbutton_value_changed();
public:

	enum actions {

		WAITING,
		PRESS,
		CANCEL
	};

	int get_action() { return action; };
	int get_value() { return value; };

	

	Dialog_Enter_Value(string p_label_text,int default_value, int min_value, int max_value, Gtk::Main &p_kit);
	~Dialog_Enter_Value();
	

};


class Popup_Instrument_Utils {

public:

	enum options {

		SEPARATOR_1,
		OPTION_COPY,
		OPTION_PASTE,
		OPTION_PASTE_EXCHANGE,
		OPTION_PASTE_EXCHANGE_SONG,
		OPTION_DELETE,
		OPTION_DELETE_SAMPLES,
		SEPARATOR_2,
		OPTION_LOAD,
		OPTION_SAVE,
		ITEM_OPTION_MAX
	};

		
	static const char * option_names[ITEM_OPTION_MAX];

        Gtk::MenuItem *items[ITEM_OPTION_MAX];
	Gtk::Menu instrument_menu;

	Popup_Instrument_Utils ();

	~Popup_Instrument_Utils ();

};

class Dialog_OkCancel : public Gtk::Dialog {

	Gtk::Button button;
	Gtk::Button button2;

	Gtk::Label *label;

	Dialog_OkCancel() {};

        void button_ok_pressed();
        void button_cancel_pressed();

       	gint delete_event_impl(GdkEventAny* p_event) {

		action=CANCEL;
		return 1;
	}

	int action;
public:

	enum actions {

		WAITING,
		OK,
		CANCEL
	};

	int get_action() { return action; };

	Dialog_OkCancel(string p_label_text,Gtk::Main &p_kit);
	~Dialog_OkCancel();
	

};

class PopUp_Pattern_Properties : public Gtk::Window {


        PopUp_Pattern_Properties();

public:

        Gtk::HSeparator hseparator1;
        Gtk::HSeparator hseparator2;
        Gtk::HSeparator hseparator3;
        Gtk::HSeparator hseparator4;
        Gtk::HSeparator hseparator5;
        Gtk::HSeparator hseparator6;
        Gtk::HSeparator hseparator7;
        Gtk::HSeparator hseparator8;
        Gtk::Label label1;
        Gtk::Label label2;
        Gtk::Label label3;
        Gtk::Label label4;
        Gtk::SpinButton *spinbutton_base_octave;
        Gtk::Adjustment *spinbutton_base_octave_adj;
        Gtk::SpinButton *spinbutton_cursor_step;
        Gtk::Adjustment *spinbutton_cursor_step_adj;
        Gtk::SpinButton *spinbutton_row_highlight_minor;
        Gtk::Adjustment *spinbutton_row_highlight_minor_adj;
        Gtk::SpinButton *spinbutton_row_highlight_major;
        Gtk::Adjustment *spinbutton_row_highlight_major_adj;
        Gtk::Table table1;
        Gtk::Frame frame1;
        Gtk::HSeparator hseparator9;
        Gtk::HSeparator hseparator10;
        Gtk::HSeparator hseparator11;
        Gtk::Label label5;
        Gtk::SpinButton *spinbutton_pattern_length;
        Gtk::Adjustment *spinbutton_pattern_length_adj;
        Gtk::Label label6;
        Gtk::Label label7;
        Gtk::SpinButton *spinbutton_repeat_pattern_length;
        Gtk::Adjustment *spinbutton_repeat_pattern_length_adj;
        Gtk::Table table2;
        Gtk::Frame frame2;
        Gtk::Button button_ok;
        Gtk::HSeparator hseparator13;
        Gtk::Button button_cancel;
        Gtk::HBox hbox1;
        Gtk::Frame frame3;
        Gtk::VBox vbox1;

        void on_button_cancel_clicked();
 	
  	gint key_press_event_impl(GdkEventKey* p_event) {

		if (p_event->keyval==GDK_Escape) {

    			delete this;
       		}
         	return 0;
    	}


	PopUp_Pattern_Properties(int p_base_octave,int p_cursor_step,int p_row_hl_minor,int p_row_hl_major,int p_pattern_length,int p_pattern_repeat);
        ~PopUp_Pattern_Properties();
};


class Popup_Undo_Window : public Gtk::Window {

public:
        Gtk::CList clist_undo_actions;
        Gtk::ScrolledWindow scrolledwindow1;
        Gtk::Button button_undo;
        Gtk::HSeparator hseparator1;
        Gtk::Button button_cancel;
        Gtk::HBox hbox1;
        Gtk::HSeparator hseparator2;
        Gtk::VBox vbox1;
        int counter;
	int selected_row;
        void button_cancel_pressed();
	void on_clist_undo_select_row(gint row, gint column, GdkEvent *event);
        void add_row(int p_pattern,string p_reason);
        Popup_Undo_Window();

        ~Popup_Undo_Window();
};

class Window_FontSelect_PopUp : public Gtk::FontSelectionDialog {
public:

	enum actions {
                WAITING,
		PRESSED_OK,
 		PRESSED_NOTHING
	};
	
	int action;

	void poll_until_action(Gtk::Main &p_kit);
 	void button_ok_pressed();
  	void button_cancel_pressed();

	gint delete_event_impl(GdkEventAny* p_event) {

		action=PRESSED_NOTHING;
		return 1;
	}

	Window_FontSelect_PopUp();
	~Window_FontSelect_PopUp();
};

class Window_Get_Key : public Gtk::Window {
 	
	Window_Get_Key() {};
public:

	Gtk::Label legend;

	enum actions {
                WAITING,
		PRESSED_KEY,
 		PRESSED_NOTHING
	};
	
	int action;
 	int key_pressed;

	void poll_until_action(Gtk::Main &p_kit);

	gint delete_event_impl(GdkEventAny* p_event) {

		action=PRESSED_NOTHING;
		return 1;
	}

 	gint key_press_event_impl(GdkEventKey* p_event);

 	Window_Get_Key(string p_title);
  	~Window_Get_Key();
};

class Window_Help : public Gtk::Dialog {
 	
	Window_Help() {};
public:

	Gtk::ScrolledWindow scroll;
	Gtk::Button button;
        Gtk::Text text;

	enum actions {
                WAITING,
		PRESSED_KEY,
 		PRESSED_NOTHING
	};
	
	int action;
 	int key_pressed;

	void poll_until_action(Gtk::Main &p_kit);

	void button_ok_pressed();

	gint delete_event_impl(GdkEventAny* p_event) {

		action=PRESSED_NOTHING;
		return 1;
	}

 	gint key_press_event_impl(GdkEventKey* p_event) {

		if (p_event->keyval==GDK_Escape) {

    			action=PRESSED_NOTHING;
       		}
    	}

 	Window_Help(int p_help_page);
  	~Window_Help();
};

/******************************************/

class Popup_Splash : public Gtk::Window {
public:
	Gtk::Pixmap splash;
	Popup_Splash();

};

#endif
