/***************************************************************************
                          interface_popups.cpp  -  description
                             -------------------
    begin                : Thu Apr 12 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface_popups.h"
#include <stdio.h>
#include "interface_help_text.h"
#include "../icons/help.xpm"
#include "../icons/ctsplash.xpm"

/************************
	WINDOW FILE POPUP
	**************************/

Window_File_Popup::Window_File_Popup() : Gtk::Window(GTK_WINDOW_TOPLEVEL), button_popup_file_load("Load"), button_popup_file_new("New"), button_popup_file_save_current("Save Current"), button_popup_file_save_as("Save As"), button_popup_file_quit("Quit"), frame1("File Menu") {   button_popup_file_load.set_usize(67, -1);

	button_popup_file_load.set_name("button_popup_file_load");
	button_popup_file_new.set_name("button_popup_file_new");
	button_popup_file_save_current.set_name("button_popup_file_save_current");
	button_popup_file_save_as.set_name("button_popup_file_save_as");
	button_popup_file_quit.set_name("button_popup_file_quit");
	vbox2.set_usize(179, -1);
	vbox2.set_name("vbox2");
	vbox2.set_border_width(6);
	vbox2.pack_start(button_popup_file_load, true, true, 1);
	vbox2.pack_start(button_popup_file_new, false, false, 1);
	vbox2.pack_start(button_popup_file_save_current, false, false, 1);
	vbox2.pack_start(button_popup_file_save_as, false, false, 2);
	vbox2.pack_start(button_popup_file_quit, false, false, 1);
	frame1.set_name("frame1");
	frame1.set_border_width(6);
	frame1.set_label_align(0.5, 0);
	frame1.set_shadow_type(GTK_SHADOW_ETCHED_OUT);
	frame1.add(vbox2);
	set_name("file_popup");
	set_title("File");
	set_policy(false, false, false);
	add(frame1);
	button_popup_file_load.show();
	button_popup_file_new.show();
	button_popup_file_save_current.show();
	button_popup_file_save_as.show();
	button_popup_file_quit.show();
	vbox2.show();
	frame1.show();
	set_position(GTK_WIN_POS_CENTER);
	set_modal(true);
	show();
	action=WAITING;
	button_popup_file_load.grab_focus();

	button_popup_file_load.clicked.connect(bind<int>(slot(this,&Window_File_Popup::on_button_press_set_action),PRESSED_LOAD));
	button_popup_file_new.clicked.connect(bind<int>(slot(this,&Window_File_Popup::on_button_press_set_action),PRESSED_NEW));
	button_popup_file_save_current.clicked.connect(bind<int>(slot(this,&Window_File_Popup::on_button_press_set_action),PRESSED_SAVE_CURRENT));
	button_popup_file_save_as.clicked.connect(bind<int>(slot(this,&Window_File_Popup::on_button_press_set_action),PRESSED_SAVE_AS));
	button_popup_file_quit.clicked.connect(bind<int>(slot(this,&Window_File_Popup::on_button_press_set_action),PRESSED_QUIT));

}
void Window_File_Popup::poll_until_action(Gtk::Main &p_kit) {

        action=WAITING;

	do {

		while (p_kit.events_pending()) p_kit.iteration();
		usleep(10000);

	} while (action==WAITING);
}

void Window_File_Popup::on_button_press_set_action(int p_action) {


	action=p_action;
}

Window_File_Popup::~Window_File_Popup() {
}


/*************************
	FILE ACCESS_WIDGET
	***************************/

	
void File_Access_Widget::set_mode(int p_mode) {

	if (p_mode==SAVE) {

		set_title("Save file..");
		current_mode=SAVE;

	} else if (p_mode==LOAD) {

		set_title("Load file..");
		current_mode=LOAD;

	}
}

void File_Access_Widget::button_ok_pressed() {
	
	string tmp_filename;
	
        tmp_filename=get_filename();

	if (tmp_filename[tmp_filename.length()-1]=='/') {

		/* might as well change directory */

		return;
	}
	
	if (current_mode==LOAD) {

		action=OK;

	} else {

                FILE *t_f;
                Dialog_OkCancel *confirm_overwrite;
		t_f=fopen(tmp_filename.c_str(),"r");
		if (t_f!=NULL) {

			confirm_overwrite=new Dialog_OkCancel("File exists! overwrite?",*kit);
			if (confirm_overwrite->get_action()==Dialog_OkCancel::OK) action=OK;
			delete confirm_overwrite;
			fclose(t_f);
		} else {
		
                	action=OK;
		}
	}
}

void File_Access_Widget::button_cancel_pressed() {


	action=CANCEL;

}

void File_Access_Widget::poll_until_action(Gtk::Main &p_kit) {

        action=WAITING;
        kit=&p_kit;
	do {

		while (kit->events_pending()) kit->iteration();
		usleep(10000);

	} while (action==WAITING);

}

File_Access_Widget::File_Access_Widget() : help(), help_pixie((gchar**)help_xpm), make_default_path("Make default path") {

        get_ok_button()->clicked.connect(slot(this,&File_Access_Widget::button_ok_pressed));
        get_cancel_button()->clicked.connect(slot(this,&File_Access_Widget::button_cancel_pressed));
	set_position(GTK_WIN_POS_CENTER);
	set_modal(true);
 	get_action_area()->pack_start(make_default_path, FALSE, FALSE, 0);
	make_default_path.show();
 	get_action_area()->pack_start(help, FALSE, FALSE, 0);
  	help.add(help_pixie);
   	help_pixie.show();
  	help.show();
   	help.clicked.connect(slot(this,&File_Access_Widget::button_help_pressed));
   	make_default_path.clicked.connect(slot(this,&File_Access_Widget::button_make_default_path_pressed));

	show();
	action=WAITING;
}

void File_Access_Widget::button_help_pressed() {

	Window_Help help(10);
 	help.poll_until_action(*kit);
}

void File_Access_Widget::button_make_default_path_pressed() {

	string path;
        path=get_filename();
        for (int i=path.size()-1;i>=0;i--) {

          	if (path[i]!='/') {
             		path=path.substr(0,path.size()-1);
                } else {

			break;                  	
                }
   	}
           		
        make_default.emit(path);

 	
}

File_Access_Widget::~File_Access_Widget() {


}

/********************
	DIALOG ACCEPT
	**********************/


void Dialog_Accept::button_ok_pressed() {

	button_clicked=true;
}

Dialog_Accept::Dialog_Accept(string p_label_text,Gtk::Main &p_kit) : button("Ok!") {

	set_position(GTK_WIN_POS_CENTER);
	set_modal(true);
	label = new Gtk::Label(p_label_text);
	get_action_area()->pack_start(button, FALSE, FALSE, 0);
	get_vbox()->pack_start (*label, TRUE, TRUE, 0);
	label->set_padding(20,20);
	button.show();
	button.clicked.connect(slot(this,&Dialog_Accept::button_ok_pressed));	
	label->show();
	set_policy(false, false, false);
	set_title("(!)");
	show();

        button.grab_focus();
	button_clicked=false;

	do {

		while (p_kit.events_pending()) p_kit.iteration();
		usleep(10000);

	} while (!button_clicked);

}
Dialog_Accept::~Dialog_Accept() {

 	delete label;
}

/*===================-.
    ~\\ SAMPLE:OPTIONS \\_
       ~-====================*/


const char *Popup_Sample_Utils::option_names[ITEM_OPTION_MAX]={
	"-",
	"Copy","Paste","Paste<->Exchange","Paste<->Exchange(in song too)","Delete",
	"-",
	"Load","Save",
	"-",
	"Reverse","Pre-Loop Cut","Post-Loop Cut","Amplify",
	"Toggle Signed/Unsigned","Toggle Quality","Resize with interpolation","Resize raw","Centralize"
};

Popup_Sample_Utils::Popup_Sample_Utils () {


	int i;

       	for (i=0;i<ITEM_OPTION_MAX;i++) {

       		if (strcmp(option_names[i],"-")==0) {
                       	/* Separator */
       			items[i] = new Gtk::MenuItem();
       		} else {

       			items[i] = new Gtk::MenuItem(option_names[i]);
       		}
		
       		sample_menu.append(*items[i]);
       		items[i]->show();
       	}
}

Popup_Sample_Utils::~Popup_Sample_Utils () {

        int i;
       	for (i=0;i<ITEM_OPTION_MAX;i++) delete items[i];
}

/*************************
	DIALOG ENTER VALUE
	**************************/



Dialog_Enter_Value::Dialog_Enter_Value(string p_label_text,int default_value, int min_value, int max_value, Gtk::Main &p_kit) : button("Ok!") {

	set_position(GTK_WIN_POS_CENTER);
	set_modal(true);
	set_policy(false, false, false);
	set_title("-=_/-([?])-\\_=-");

	label = new Gtk::Label(p_label_text);

	if (default_value>max_value) default_value=max_value;
	spinbutton_value_adj = new Gtk::Adjustment(default_value, min_value, max_value, 1, 10, 10);
	spinbutton_value = new Scroll_Bar(*spinbutton_value_adj);

	get_action_area()->pack_start(button, FALSE, FALSE, 0);
	get_vbox()->pack_start (*label, TRUE, TRUE, 0);
	get_vbox()->pack_start (*spinbutton_value, FALSE, FALSE, 5);

	spinbutton_value->set_usize(50,20);	
	label->set_padding(10,10);

	button.show();
	spinbutton_value->show();
        button.grab_focus();

	button.clicked.connect(slot(this,&Dialog_Enter_Value::button_ok_pressed));	
	spinbutton_value_adj->value_changed.connect(slot(this,&Dialog_Enter_Value::spinbutton_value_changed));

	label->show();
	show();

        value=default_value;
	action=WAITING;

	do {

		while (p_kit.events_pending()) p_kit.iteration();
		usleep(10000);

	} while (action==WAITING);

}

void Dialog_Enter_Value::spinbutton_value_changed() {

	value=spinbutton_value->get_value_as_int();
}

void Dialog_Enter_Value::button_ok_pressed() {

	action=PRESS;
}

Dialog_Enter_Value::~Dialog_Enter_Value() {

 	delete label;
	delete spinbutton_value;
	delete spinbutton_value_adj;
}

/*=======================-.
    ~\\ INSTRUMENT:OPTIONS \\\_
       ~-=======================*/


const char *Popup_Instrument_Utils::option_names[ITEM_OPTION_MAX]={
	"-",
	"Copy","Paste","Paste<->Exchange","Paste<->Exchange(in song too)","Delete","Delete (samples too)",
	"-",
	"Load","Save",
};

Popup_Instrument_Utils::Popup_Instrument_Utils () {


	int i;

       	for (i=0;i<ITEM_OPTION_MAX;i++) {

       		if (strcmp(option_names[i],"-")==0) {
                       	/* Separator */
       			items[i] = new Gtk::MenuItem();
       		} else {

       			items[i] = new Gtk::MenuItem(option_names[i]);
       		}
		
       		instrument_menu.append(*items[i]);
       		items[i]->show();
       	}
}

Popup_Instrument_Utils::~Popup_Instrument_Utils () {

        int i;
       	for (i=0;i<ITEM_OPTION_MAX;i++) delete items[i];
}


/*************************
	DIALOG OK - CANCEL
	**************************/


void Dialog_OkCancel::button_ok_pressed() {

	action=OK;
}

void Dialog_OkCancel::button_cancel_pressed() {

	action=CANCEL;
}

Dialog_OkCancel::Dialog_OkCancel(string p_label_text,Gtk::Main &p_kit) : button("OK"), button2("Cancel") {

	set_position(GTK_WIN_POS_CENTER);
	set_modal(true);
	label = new Gtk::Label(p_label_text);
	get_action_area()->pack_start(button, FALSE, FALSE, 3);
	get_action_area()->pack_start(button2, FALSE, FALSE, 3);

	get_vbox()->pack_start (*label, TRUE, TRUE, 0);
	label->set_padding(20,20);
	button.show();
	button.clicked.connect(slot(this,&Dialog_OkCancel::button_ok_pressed));	
	button2.show();
	button2.clicked.connect(slot(this,&Dialog_OkCancel::button_cancel_pressed));	

	label->show();
	set_policy(false, false, false);
	set_title("-=_/-([?])-\\_=-");
	show();
	button.grab_focus();

	action=WAITING;

	do {

		while (p_kit.events_pending()) p_kit.iteration();
		usleep(10000);

	} while (action==WAITING);

}
Dialog_OkCancel::~Dialog_OkCancel() {

 	delete label;
}

/****************************/



Window_FontSelect_PopUp::Window_FontSelect_PopUp() {

	set_policy(false, false, false);
	set_title("-=_/-([?])-\\_=-");
	set_modal(true);
	set_position(GTK_WIN_POS_CENTER);

	show();

	get_ok_button()->clicked.connect(slot(this,&Window_FontSelect_PopUp::button_ok_pressed));
	get_cancel_button()->clicked.connect(slot(this,&Window_FontSelect_PopUp::button_cancel_pressed));
}
Window_FontSelect_PopUp::~Window_FontSelect_PopUp() {

}

void Window_FontSelect_PopUp::button_ok_pressed() {

        action=PRESSED_OK;

}
void Window_FontSelect_PopUp::button_cancel_pressed() {

        action=PRESSED_NOTHING;

}

void Window_FontSelect_PopUp::poll_until_action(Gtk::Main &p_kit) {

        action=WAITING;

	do {

		while (p_kit.events_pending()) p_kit.iteration();
		usleep(10000);

	} while (action==WAITING);

}


void Window_Get_Key::poll_until_action(Gtk::Main &p_kit) {

        action=WAITING;

	do {

		while (p_kit.events_pending()) p_kit.iteration();
		usleep(10000);

	} while (action==WAITING);

}
gint Window_Get_Key::key_press_event_impl(GdkEventKey* p_event) {

	if ((p_event->keyval<32) || (p_event->keyval>255)) return 0;

	if ((p_event->keyval>'a') && (p_event->keyval<'z')) {

		p_event->keyval-=('a'-'A');
   	}

	key_pressed=p_event->keyval;
 	action=PRESSED_KEY;

  	return 0;
}

Window_Get_Key::Window_Get_Key(string p_title) : legend("Press a Key for " + p_title) {
	
 	set_policy(false, false, false);
	set_title("-=_/-([?])-\\_=-");
	set_modal(true);
	set_position(GTK_WIN_POS_CENTER);

  	add(legend);
   	legend.show();
    	show();
}

Window_Get_Key::~Window_Get_Key() {}


/*************************************************/

Window_Help::Window_Help(int p_help_page) : button("Got it!") {

	set_position(GTK_WIN_POS_CENTER);
	set_modal(true);
 	
  	switch (p_help_page) {

    		case 0: {
			
        		text.insert(help_pattern);                      	
        	} break;
    		case 1: {
			
        		text.insert(help_samples);                      	
        	} break;
    		case 2: {
			
        		text.insert(help_instruments);                      	
        	} break;
    		case 3: {
			
        		text.insert(help_info_page);                      	
        	} break;
    		case 4: {
			
        		text.insert(help_orderlist);                      	
        	} break;
    		case 10: {
			
        		text.insert(help_files);                      	
        	} break;
         	default: {
        		
          		text.insert(help_other);                      	
            	};
    	}

	get_action_area()->pack_start(button, FALSE, FALSE, 0);
	get_vbox()->pack_start (scroll, TRUE, TRUE, 0);
 	scroll.add(text);
  	scroll.show();
 	text.set_usize(500,500);
  	text.show();

	button.show();
	button.clicked.connect(slot(this,&Window_Help::button_ok_pressed));	

	set_policy(false, true, false);
	set_title("CheeseTracker HELP!");
	show();

        button.grab_focus();


}

void Window_Help::poll_until_action(Gtk::Main &p_kit) {

        action=WAITING;

	do {

		while (p_kit.events_pending()) p_kit.iteration();
		usleep(10000);

	} while (action==WAITING);

}

void Window_Help::button_ok_pressed() {

	action=PRESSED_NOTHING;

}

Window_Help::~Window_Help() {


}

/*************************************************/

Popup_Splash::Popup_Splash() : Gtk::Window(GTK_WINDOW_TOPLEVEL), splash((gchar**)ctsplash_xpm) {

  	add(splash);
   	splash.show();
	set_modal(true);
	set_policy(false, false, false);
	set_position(GTK_WIN_POS_CENTER);


};
